/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.launch.GameEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraft.launchwrapper.Launch;

public abstract class StartupEnvironment
implements GameEnvironment {
    private List<String> singularLaunchArgs = new ArrayList<String>();
    private Map<String, String> launchArgs;
    private ArgumentAcceptingOptionSpec<String> modsDirOption;
    private ArgumentAcceptingOptionSpec<String> modsOption;
    private ArgumentAcceptingOptionSpec<String> apisOption;
    private NonOptionArgumentSpec<String> unparsedOptions;
    private OptionSet parsedOptions;
    private final File gameDirectory;
    private final File assetsDirectory;
    private final String profile;

    public StartupEnvironment(List<String> args, File gameDirectory, File assetsDirectory, String profile) {
        this.gameDirectory = gameDirectory;
        this.assetsDirectory = assetsDirectory;
        this.profile = profile;
        this.initArgs(args);
    }

    public abstract void registerCoreAPIs(List<String> var1);

    public abstract int getEnvironmentTypeId();

    public void initArgs(List<String> args) {
        this.launchArgs = (Map)Launch.blackboard.get("launchArgs");
        if (this.launchArgs == null) {
            this.launchArgs = new HashMap<String, String>();
            Launch.blackboard.put("launchArgs", this.launchArgs);
        }
        this.parseOptions(args.toArray(new String[args.size()]));
        this.parseArgs(this.parsedOptions.valuesOf(this.unparsedOptions));
        this.provideRequiredArgs();
    }

    private void parseOptions(String[] args) {
        OptionParser optionParser = new OptionParser();
        optionParser.allowsUnrecognizedOptions();
        this.modsOption = optionParser.accepts("mods", "Comma-separated list of mods to load").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        this.apisOption = optionParser.accepts("api", "Additional API classes to load").withRequiredArg().ofType(String.class);
        this.modsDirOption = optionParser.accepts("modsDir", "Path to 'mods' folder to use instead of default").withRequiredArg().ofType(String.class);
        this.unparsedOptions = optionParser.nonOptions();
        this.parsedOptions = optionParser.parse(args);
    }

    private void parseArgs(List<String> args) {
        String classifier = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (classifier != null) {
                    this.addClassifiedArg(classifier, "");
                    classifier = null;
                    continue;
                }
                if (arg.contains("=")) {
                    this.addClassifiedArg(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                classifier = arg;
                continue;
            }
            if (classifier != null) {
                this.addClassifiedArg(classifier, arg);
                classifier = null;
                continue;
            }
            this.singularLaunchArgs.add(arg);
        }
        if (classifier != null) {
            this.singularLaunchArgs.add(classifier);
        }
    }

    public void addClassifiedArg(String classifiedArg, String arg) {
        this.launchArgs.put(classifiedArg, arg);
    }

    public void provideRequiredArgs() {
        if (this.launchArgs.get("--version") == null) {
            this.addClassifiedArg("--version", "1.7.10");
        }
        if (this.launchArgs.get("--gameDir") == null && this.gameDirectory != null) {
            this.addClassifiedArg("--gameDir", this.gameDirectory.getAbsolutePath());
        }
        if (this.launchArgs.get("--assetsDir") == null && this.assetsDirectory != null) {
            this.addClassifiedArg("--assetsDir", this.assetsDirectory.getAbsolutePath());
        }
    }

    public String[] getLaunchArguments() {
        ArrayList<String> args = new ArrayList<String>();
        for (String string : this.singularLaunchArgs) {
            args.add(string);
        }
        for (Map.Entry entry : this.launchArgs.entrySet()) {
            args.add(((String)entry.getKey()).trim());
            args.add(((String)entry.getValue()).trim());
        }
        this.singularLaunchArgs.clear();
        this.launchArgs.clear();
        return args.toArray(new String[args.size()]);
    }

    public List<String> getModFilterList() {
        return this.parsedOptions.has(this.modsOption) ? this.modsOption.values(this.parsedOptions) : null;
    }

    public List<String> getAPIsToLoad() {
        ArrayList<String> apisToLoad = new ArrayList<String>();
        this.registerCoreAPIs(apisToLoad);
        if (this.parsedOptions.has(this.apisOption)) {
            apisToLoad.addAll(this.apisOption.values(this.parsedOptions));
        }
        return apisToLoad;
    }

    public File getOptionalDirectory(File baseDirectory, ArgumentAcceptingOptionSpec<String> option, String defaultDir) {
        if (this.parsedOptions.has(option)) {
            String path = (String)option.value(this.parsedOptions);
            File dir = new File(path);
            if (dir.isAbsolute()) {
                return dir;
            }
            return new File(baseDirectory, path);
        }
        return new File(baseDirectory, defaultDir);
    }

    @Override
    public File getGameDirectory() {
        return this.gameDirectory;
    }

    @Override
    public File getAssetsDirectory() {
        return this.assetsDirectory;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public File getModsFolder() {
        return this.getOptionalDirectory(this.gameDirectory, this.modsDirOption, "mods");
    }
}

