/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.transformers.ClassOverlayTransformer;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MinecraftOverlayTransformer
extends ClassOverlayTransformer {
    private static final String overlayClassName = "com.mumfrey.liteloader.client.overlays.MinecraftOverlay";
    private static final String LITELOADER_TWEAKER_CLASS = LiteLoaderTweaker.class.getName().replace('.', '/');
    private static final String METHOD_INIT = "init";
    private static final String METHOD_POSTINIT = "postInit";

    public MinecraftOverlayTransformer() {
        super(overlayClassName);
        this.setSourceFile = false;
    }

    @Override
    protected void postOverlayTransform(String transformedName, ClassNode targetClass, ClassNode overlayClass) {
        if (Obf.Minecraft.name.equals(transformedName) || Obf.Minecraft.obf.equals(transformedName)) {
            for (MethodNode method : targetClass.methods) {
                if (!Obf.startGame.obf.equals(method.name) && !Obf.startGame.srg.equals(method.name) && !Obf.startGame.name.equals(method.name)) continue;
                this.transformStartGame(method);
            }
        }
    }

    private void transformStartGame(MethodNode method) {
        InsnList insns = new InsnList();
        boolean found = false;
        for (AbstractInsnNode insn : method.instructions) {
            insns.add(insn);
            if (insn instanceof TypeInsnNode && insn.getOpcode() == 187 && insns.getLast() != null) {
                TypeInsnNode typeNode = (TypeInsnNode)insn;
                if (!found && (Obf.EntityRenderer.obf.equals(typeNode.desc) || Obf.EntityRenderer.ref.equals(typeNode.desc))) {
                    LiteLoaderLogger.info("MinecraftOverlayTransformer found INIT injection point, this is good.", new Object[0]);
                    found = true;
                    insns.add((AbstractInsnNode)new MethodInsnNode(184, LITELOADER_TWEAKER_CLASS, METHOD_INIT, "()V", false));
                    insns.add((AbstractInsnNode)new MethodInsnNode(184, LITELOADER_TWEAKER_CLASS, METHOD_POSTINIT, "()V", false));
                }
            }
            if (!LiteLoaderTweaker.loadingBarEnabled()) continue;
            if (insn instanceof LdcInsnNode) {
                LdcInsnNode ldcInsn = (LdcInsnNode)insn;
                if ("textures/blocks".equals(ldcInsn.cst)) {
                    insns.add((AbstractInsnNode)new MethodInsnNode(184, Obf.LoadingBar.ref, "initTextures", "()V", false));
                }
            }
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Obf.LoadingBar.ref, "incrementProgress", "()V", false));
        }
        method.instructions = insns;
        if (!found) {
            LiteLoaderLogger.severe("MinecraftOverlayTransformer failed to find the INIT injection point, the game will probably crash pretty soon.", new Object[0]);
        }
    }
}

