/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.ChatFilter;
import com.mumfrey.liteloader.ChatListener;
import com.mumfrey.liteloader.PostLoginListener;
import com.mumfrey.liteloader.PreJoinGameListener;
import com.mumfrey.liteloader.client.ClientPluginChannelsClient;
import com.mumfrey.liteloader.common.transformers.PacketEventInfo;
import com.mumfrey.liteloader.core.ClientPluginChannels;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.PacketEvents;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;

public class PacketEventsClient
extends PacketEvents {
    private FastIterableDeque<ChatListener> chatListeners = new HandlerList<ChatListener>(ChatListener.class);
    private FastIterableDeque<ChatFilter> chatFilters = new HandlerList<ChatFilter>(ChatFilter.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private FastIterableDeque<PreJoinGameListener> preJoinGameListeners = new HandlerList<PreJoinGameListener>(PreJoinGameListener.class, HandlerList.ReturnLogicOp.OR);
    private FastIterableDeque<PostLoginListener> postLoginListeners = new HandlerList<PostLoginListener>(PostLoginListener.class);

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        super.registerInterfaces(delegate);
        delegate.registerInterface(ChatListener.class);
        delegate.registerInterface(ChatFilter.class);
        delegate.registerInterface(PreJoinGameListener.class);
        delegate.registerInterface(PostLoginListener.class);
    }

    public void registerChatFilter(ChatFilter chatFilter) {
        this.chatFilters.add(chatFilter);
    }

    public void registerChatListener(ChatListener chatListener) {
        if (chatListener instanceof ChatFilter) {
            LiteLoaderLogger.warning("Interface error initialising mod '%1s'. A mod implementing ChatFilter and ChatListener is not supported! Remove one of these interfaces", chatListener.getName());
        } else {
            this.chatListeners.add(chatListener);
        }
    }

    public void registerPreJoinGameListener(PreJoinGameListener joinGameListener) {
        this.preJoinGameListeners.add(joinGameListener);
    }

    public void registerPostLoginListener(PostLoginListener postLoginListener) {
        this.postLoginListeners.add(postLoginListener);
    }

    @Override
    protected void handlePacket(PacketEventInfo<ft> e, fb netHandler, hd packet) {
        if (!(netHandler instanceof fv)) {
            return;
        }
        e.cancel();
        if (((PreJoinGameListener)this.preJoinGameListeners.all()).onPreJoinGame(netHandler, packet)) {
            return;
        }
        ((fv)netHandler).a(packet);
        super.handlePacket(e, netHandler, packet);
        ClientPluginChannels clientPluginChannels = LiteLoader.getClientPluginChannels();
        if (clientPluginChannels instanceof ClientPluginChannelsClient) {
            ((ClientPluginChannelsClient)clientPluginChannels).onJoinGame(netHandler, packet);
        }
    }

    @Override
    protected void handlePacket(PacketEventInfo<ft> e, fb netHandler, js packet) {
        if (netHandler instanceof jr) {
            jr netHandlerLoginClient = (jr)netHandler;
            ClientPluginChannels clientPluginChannels = LiteLoader.getClientPluginChannels();
            if (clientPluginChannels instanceof ClientPluginChannelsClient) {
                ((ClientPluginChannelsClient)clientPluginChannels).onPostLogin(netHandlerLoginClient, packet);
            }
            ((PostLoginListener)this.postLoginListeners.all()).onPostLogin(netHandlerLoginClient, packet);
        }
    }

    @Override
    protected void handlePacket(PacketEventInfo<ft> e, fb netHandler, gj packet) {
        if (packet.c() == null) {
            return;
        }
        fj chat = packet.c();
        String message = chat.d();
        for (ChatFilter chatFilter : this.chatFilters) {
            if (chatFilter.onChat(packet, chat, message)) {
                chat = packet.c();
                message = chat.d();
                continue;
            }
            e.cancel();
            return;
        }
        ((ChatListener)this.chatListeners.all()).onChat(chat, message);
    }
}

