/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.WeightedRandomNBTTag;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;

public class WorldGenDungeon
extends WorldGenerator {
    private final List<WeightedRandomBlock> walls;
    private final WeightedRandomBlock[] genBlock;
    private final WeightedRandomNBTTag[] spawners;
    public int minWidthX = 2;
    public int maxWidthX = 3;
    public int minWidthZ = 2;
    public int maxWidthZ = 3;
    public int minHeight = 3;
    public int maxHeight = 3;
    public int minHoles = 1;
    public int maxHoles = 5;
    public int maxChests = 2;
    public int maxChestTries = 3;
    public List<DungeonHooks.DungeonMob> lootTables = Arrays.asList(new DungeonHooks.DungeonMob(100, "dungeonChest"));
    public List<WeightedRandomBlock> floor;

    public WorldGenDungeon(List<WeightedRandomBlock> blocks, List<WeightedRandomBlock> material, List<WeightedRandomNBTTag> mobs) {
        this.walls = blocks;
        this.floor = this.walls;
        this.spawners = mobs.toArray(new WeightedRandomNBTTag[mobs.size()]);
        this.genBlock = material.toArray(new WeightedRandomBlock[material.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int xStart, int yStart, int zStart) {
        int y;
        int z;
        int x;
        if (yStart <= 2) {
            return false;
        }
        int height = WorldGenDungeon.nextInt(rand, this.maxHeight - this.minHeight + 1) + this.minHeight;
        int xWidth = WorldGenDungeon.nextInt(rand, this.maxWidthX - this.minWidthX + 1) + this.minWidthX;
        int zWidth = WorldGenDungeon.nextInt(rand, this.maxWidthZ - this.minWidthZ + 1) + this.minWidthZ;
        int holes = 0;
        int floor = yStart - 1;
        int ceiling = yStart + height + 1;
        for (x = xStart - xWidth - 1; x <= xStart + xWidth + 1; ++x) {
            for (z = zStart - zWidth - 1; z <= zStart + zWidth + 1; ++z) {
                for (y = floor; y <= ceiling; ++y) {
                    if (y == floor && !WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.genBlock)) {
                        return false;
                    }
                    if (y == ceiling && !WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.genBlock)) {
                        return false;
                    }
                    if (Math.abs(x - xStart) != xWidth + 1 && Math.abs(z - zStart) != zWidth + 1 || y != yStart || !world.func_147437_c(x, y, z) || !world.func_147437_c(x, y + 1, z)) continue;
                    ++holes;
                }
            }
        }
        if (holes < this.minHoles || holes > this.maxHoles) {
            return false;
        }
        NBTTagCompound tag = (NBTTagCompound)((WeightedRandomNBTTag)WeightedRandom.func_76274_a((Random)rand, (WeightedRandom.Item[])this.spawners)).tag;
        ChestGenHooks table = ChestGenHooks.getInfo((String)((DungeonHooks.DungeonMob)WeightedRandom.func_76271_a((Random)rand, this.lootTables)).type);
        for (x = xStart - xWidth - 1; x <= xStart + xWidth + 1; ++x) {
            for (z = zStart - zWidth - 1; z <= zStart + zWidth + 1; ++z) {
                for (y = yStart + height; y >= floor; --y) {
                    if (y != floor) {
                        if (Math.abs(x - xStart) != xWidth + 1 && Math.abs(z - zStart) != zWidth + 1) {
                            world.func_147468_f(x, y, z);
                            continue;
                        }
                        if (y >= 0 && !WorldGenMinableCluster.canGenerateInBlock(world, x, y - 1, z, this.genBlock)) {
                            world.func_147468_f(x, y, z);
                            continue;
                        }
                    }
                    if (!WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.genBlock)) continue;
                    if (y == floor) {
                        WorldGenMinableCluster.generateBlock(world, x, y, z, this.floor);
                        continue;
                    }
                    WorldGenMinableCluster.generateBlock(world, x, y, z, this.walls);
                }
            }
        }
        int i = this.maxChests;
        block6: while (i-- > 0) {
            int j = this.maxChestTries;
            while (j-- > 0) {
                x = xStart + WorldGenDungeon.nextInt(rand, xWidth * 2 + 1) - xWidth;
                if (!world.func_147437_c(x, yStart, z = zStart + WorldGenDungeon.nextInt(rand, zWidth * 2 + 1) - zWidth)) continue;
                int walls = 0;
                if (this.isWall(world, x - 1, yStart, z)) {
                    ++walls;
                }
                if (this.isWall(world, x + 1, yStart, z)) {
                    ++walls;
                }
                if (this.isWall(world, x, yStart, z - 1)) {
                    ++walls;
                }
                if (this.isWall(world, x, yStart, z + 1)) {
                    ++walls;
                }
                if (walls < 1 || walls > 2) continue;
                world.func_147465_d(x, yStart, z, (Block)Blocks.field_150486_ae, 0, 2);
                TileEntityChest chest = (TileEntityChest)world.func_147438_o(x, yStart, z);
                if (chest == null) continue block6;
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])table.getItems(rand), (IInventory)chest, (int)table.getCount(rand));
                continue block6;
            }
        }
        world.func_147465_d(xStart, yStart, zStart, Blocks.field_150474_ac, 0, 2);
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(xStart, yStart, zStart);
        if (spawner != null) {
            spawner.func_145881_a().func_98270_a(tag);
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + xStart + ", " + yStart + ", " + zStart + ")");
        }
        return true;
    }

    private static int nextInt(Random rand, int v) {
        if (v <= 1) {
            return 0;
        }
        return rand.nextInt(v);
    }

    private boolean isWall(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        return WeightedRandomBlock.isBlockContained(world.func_147439_a(x, y, z), metadata, this.walls);
    }
}

