/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.network.handlers;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketRegistry;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.tasks.TaskInteractItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class NetTaskInteract {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:task_interact");

    public static void registerHandler() {
        ((IPacketRegistry)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_REG)).registerServerHandler(ID_NAME, NetTaskInteract::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestInteraction(boolean isHit) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74757_a("isHit", isHit);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = (EntityPlayerMP)message.func_76340_b();
        NBTTagCompound tag = (NBTTagCompound)message.func_76341_a();
        ParticipantInfo pInfo = new ParticipantInfo((EntityPlayer)sender);
        List actQuest = ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests());
        boolean isHit = tag.func_74767_n("isHit");
        for (DBEntry entry : actQuest) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract(pInfo, (DBEntry<IQuest>)entry, null, null, -1, MathHelper.func_76128_c((double)sender.field_70165_t), MathHelper.func_76128_c((double)sender.field_70163_u), MathHelper.func_76128_c((double)sender.field_70161_v), isHit);
            }
        }
    }
}

