/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.tasks.TaskLocation;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class PanelTaskLocation
extends CanvasEmpty {
    private final TaskLocation task;

    public PanelTaskLocation(IGuiRect rect, TaskLocation task) {
        super(rect);
        this.task = task;
    }

    public void initPanel() {
        super.initPanel();
        String desc = QuestTranslation.translate((String)this.task.name, (Object[])new Object[0]);
        if (!this.task.hideInfo) {
            desc = desc + " (" + TaskLocation.getDimName(this.task.dim) + ")";
            if (this.task.range >= 0) {
                desc = desc + "\n" + QuestTranslation.translate((String)"bq_standard.gui.location", (Object[])new Object[]{"(" + this.task.x + ", " + this.task.y + ", " + this.task.z + ")"});
                desc = desc + "\n" + QuestTranslation.translate((String)"bq_standard.gui.distance", (Object[])new Object[]{(int)Minecraft.func_71410_x().field_71439_g.func_70011_f((double)this.task.x, (double)this.task.y, (double)this.task.z) + "m"});
            }
        }
        desc = this.task.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) ? desc + "\n" + EnumChatFormatting.BOLD + EnumChatFormatting.GREEN + QuestTranslation.translate((String)"bq_standard.gui.found", (Object[])new Object[0]) : desc + "\n" + EnumChatFormatting.BOLD + EnumChatFormatting.RED + QuestTranslation.translate((String)"bq_standard.gui.undiscovered", (Object[])new Object[0]);
        this.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(new Vector4f(0.0f, 0.0f, 1.0f, 0.3f), new GuiPadding(0, 0, 0, 0), 0), desc).setColor(PresetColor.TEXT_MAIN.getColor()));
        IGuiTexture texCompass = new IGuiTexture(){

            public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick) {
                this.drawTexture(x, y, width, height, zDepth, partialTick, null);
            }

            public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick, IGuiColor color) {
                Minecraft mc = Minecraft.func_71410_x();
                double la = Math.atan2((double)((PanelTaskLocation)PanelTaskLocation.this).task.z - mc.field_71439_g.field_70161_v, (double)((PanelTaskLocation)PanelTaskLocation.this).task.x - mc.field_71439_g.field_70165_t);
                int radius = width / 2 - 12;
                int cx = x + width / 2;
                int cy = y + height / 2;
                int dx = (int)(Math.cos(la) * (double)radius);
                int dy = (int)(Math.sin(la) * (double)(-radius));
                int txtClr = color == null ? -1 : color.getRGB();
                Gui.func_73734_a((int)(cx - radius), (int)(cy - radius), (int)(cx + radius), (int)(cy + radius), (int)Color.BLACK.getRGB());
                RenderUtils.DrawLine((int)(cx - radius), (int)(cy - radius), (int)(cx + radius), (int)(cy - radius), (float)4.0f, (int)Color.WHITE.getRGB());
                RenderUtils.DrawLine((int)(cx - radius), (int)(cy - radius), (int)(cx - radius), (int)(cy + radius), (float)4.0f, (int)Color.WHITE.getRGB());
                RenderUtils.DrawLine((int)(cx + radius), (int)(cy + radius), (int)(cx + radius), (int)(cy - radius), (float)4.0f, (int)Color.WHITE.getRGB());
                RenderUtils.DrawLine((int)(cx + radius), (int)(cy + radius), (int)(cx - radius), (int)(cy + radius), (float)4.0f, (int)Color.WHITE.getRGB());
                mc.field_71466_p.func_78276_b(EnumChatFormatting.BOLD + "N", cx - 4, cy - radius - 9, txtClr);
                mc.field_71466_p.func_78276_b(EnumChatFormatting.BOLD + "S", cx - 4, cy + radius + 2, txtClr);
                mc.field_71466_p.func_78276_b(EnumChatFormatting.BOLD + "E", cx + radius + 2, cy - 4, txtClr);
                mc.field_71466_p.func_78276_b(EnumChatFormatting.BOLD + "W", cx - radius - 8, cy - 4, txtClr);
                if (((PanelTaskLocation)PanelTaskLocation.this).task.hideInfo || ((PanelTaskLocation)PanelTaskLocation.this).task.range < 0 || mc.field_71439_g.field_71093_bK != ((PanelTaskLocation)PanelTaskLocation.this).task.dim) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    mc.field_71466_p.func_78276_b(EnumChatFormatting.BOLD + "?", cx / 2 - 4, cy / 2 - 4, Color.RED.getRGB());
                    GL11.glPopMatrix();
                } else {
                    RenderUtils.DrawLine((int)cx, (int)cy, (int)(cx + dx), (int)(cy - dy), (float)4.0f, (int)Color.RED.getRGB());
                }
            }

            public ResourceLocation getTexture() {
                return null;
            }

            public IGuiRect getBounds() {
                return null;
            }
        };
        int innerSize = Math.min(this.getTransform().getWidth(), (int)Math.floor((double)this.getTransform().getHeight() * 0.7));
        PanelGeneric innerCanvas = new PanelGeneric((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(0.5f, 0.65f, 0.5f, 0.65f), -innerSize / 2, -innerSize / 2, innerSize, innerSize, 0), texCompass, PresetColor.TEXT_MAIN.getColor());
        this.addPanel((IGuiPanel)innerCanvas);
    }
}

