/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import wildCaves.BlockDecorations;
import wildCaves.BlockFlora;
import wildCaves.BlockFossils;
import wildCaves.BlockStalactite;
import wildCaves.BlockStoneStalactite;
import wildCaves.EventManager;
import wildCaves.ItemStalactite;
import wildCaves.MultiItemBlock;
import wildCaves.WorldGenWildCaves;

@Mod(modid="wildcaves3", name="Wild Caves 3", useMetadata=true)
public class WildCaves {
    public static final String modid = "wildcaves3";
    public static final ArrayList<String> stalacs = new ArrayList<String>(Arrays.asList("stalactite1", "stalactite2", "stalactite3", "stalactite4", "stalactiteConnection1", "stalactiteConnection2", "stalactiteConnection3", "stalactiteConnection4", "stalactiteEnd", "stalacmiteEnd", "stalacmite1", "stalacmite2", "stalacmite3"));
    public static final ArrayList<String> sandStalacs = new ArrayList<String>(Arrays.asList("sandstoneStalactite1", "sandstoneStalactite2", "sandstoneStalactite3", "sandstoneStalactite4", "sandstoneStalactiteConnection1", "sandstoneStalactiteConnection2", "sandstoneStalactiteConnection3", "sandstoneStalactiteConnection4", "sandstoneStalactiteEnd", "sandstoneStalacmiteEnd", "sandstoneStalacmite1", "sandstoneStalacmite2", "sandstoneStalacmite3"));
    public static final ArrayList<String> icicles = new ArrayList<String>(Arrays.asList("icicle1", "icicle2", "icicle3"));
    public static final ArrayList<String> caps = new ArrayList<String>(Arrays.asList("glowcap1", "glowcap2", "glowcap3", "gloweed1", "glowcap4top", "glowcap4bottom", "bluecap1", "bluecap2", "bluecap3", "bluecap4"));
    public static final ArrayList<String> fossils = new ArrayList<String>(Arrays.asList("fossil1"));
    public static Block blockFlora;
    public static Block blockDecorations;
    public static Block blockFossils;
    public static Block blockStoneStalactite;
    public static Block blockSandStalactite;
    public static int floraLightLevel;
    public static int chanceForNodeToSpawn;
    public static int chestSkull;
    public static boolean solidStalactites;
    public static boolean damageWhenFallenOn;
    public static Configuration config;
    public static final CreativeTabs tabWildCaves;

    public void initBlocks() {
        blockStoneStalactite = GameRegistry.registerBlock((Block)new BlockStoneStalactite(stalacs.size()), ItemStalactite.class, (String)"StoneStalactite", (String)modid, (Object[])new Object[]{stalacs});
        blockSandStalactite = GameRegistry.registerBlock((Block)new BlockStalactite(sandStalacs.size(), Item.func_150898_a((Block)Blocks.field_150322_A)).func_149663_c("sandstoneStalactiteBlock").func_149658_d(":sandstoneStructure"), ItemStalactite.class, (String)"SandstoneSalactite", (String)modid, (Object[])new Object[]{sandStalacs});
        blockDecorations = GameRegistry.registerBlock((Block)new BlockDecorations(icicles.size()), MultiItemBlock.class, (String)"Decorations", (String)modid, (Object[])new Object[]{icicles});
        blockFlora = GameRegistry.registerBlock((Block)new BlockFlora(caps.size()).func_149715_a(floraLightLevel), MultiItemBlock.class, (String)"Flora", (String)modid, (Object[])new Object[]{caps});
        blockFossils = GameRegistry.registerBlock((Block)new BlockFossils(fossils.size()), MultiItemBlock.class, (String)"FossilBlock", (String)modid, (Object[])new Object[]{fossils});
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        WorldGenWildCaves gen = new WorldGenWildCaves(config);
        if (WorldGenWildCaves.maxLength > 0) {
            MinecraftForge.EVENT_BUS.register((Object)gen);
        }
        if (chestSkull > 0) {
            for (String txt : new String[]{"dungeonChest", "mineshaftCorridor", "strongholdCorridor"}) {
                for (int i = 0; i < 5; ++i) {
                    if (i == 1) continue;
                    ChestGenHooks.getInfo((String)txt).addItem(new WeightedRandomChestContent(new ItemStack(Items.field_151144_bL, 1, i), 1, 2, chestSkull));
                }
            }
        }
        if (chanceForNodeToSpawn > 0) {
            EventManager eventmanager = new EventManager(chanceForNodeToSpawn);
            MinecraftForge.ORE_GEN_BUS.register((Object)eventmanager);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        solidStalactites = config.get("general", "Solid stalactites/stalgmites", false).getBoolean(false);
        damageWhenFallenOn = config.get("general", "Stalgmites damage entities when fallen on", false).getBoolean(false);
        floraLightLevel = config.get("general", "Flora light level", 5).getInt(5);
        if (floraLightLevel > 15) {
            floraLightLevel = 15;
        }
        chanceForNodeToSpawn = config.get("general", "Chance for a fossil node to generate", 5).getInt(5);
        chestSkull = config.get("general", "Chance for a skull to be added in chests", 50).getInt(50);
        config.save();
        this.initBlocks();
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, String.class, String.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), "https://raw.github.com/GotoLink/WildCaves3/master/update.xml", "https://raw.github.com/GotoLink/WildCaves3/master/changelog.md");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        tabWildCaves = new CreativeTabs("WildCaves3"){

            public Item func_78016_d() {
                return Items.field_151061_bv;
            }
        };
    }
}

