/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.furnace;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1710.furnace.SetFuelPattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FuelTweaker {
    public static final FuelTweaker INSTANCE = new FuelTweaker();
    private List<IFuelHandler> original;
    private final HashMap<Item, List<SetFuelPattern>> quickList = new HashMap();

    private FuelTweaker() {
    }

    public void register() {
        try {
            Field fuelHandlers = GameRegistry.class.getDeclaredField("fuelHandlers");
            fuelHandlers.setAccessible(true);
            this.original = (List)fuelHandlers.get(null);
            ArrayList<OverridingFuelHandler> modified = new ArrayList<OverridingFuelHandler>();
            modified.add(new OverridingFuelHandler());
            fuelHandlers.set(null, modified);
        }
        catch (NoSuchFieldException ex) {
            System.out.println("[MineTweaker] Error: could not get GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
        catch (SecurityException ex) {
            System.out.println("[MineTweaker] Error: could not alter GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
        catch (IllegalAccessException ex) {
            System.out.println("[MineTweaker] Error: could not alter GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
    }

    public void addFuelPattern(SetFuelPattern pattern) {
        List<IItemStack> items = pattern.getPattern().getItems();
        if (items == null) {
            MineTweakerAPI.logError("Cannot set fuel for <*>");
            return;
        }
        for (IItemStack item : pattern.getPattern().getItems()) {
            ItemStack itemStack = MineTweakerMC.getItemStack(item);
            Item mcItem = itemStack.func_77973_b();
            if (!this.quickList.containsKey(mcItem)) {
                this.quickList.put(mcItem, new ArrayList());
            }
            this.quickList.get(mcItem).add(pattern);
        }
    }

    public void removeFuelPattern(SetFuelPattern pattern) {
        for (IItemStack item : pattern.getPattern().getItems()) {
            ItemStack itemStack = MineTweakerMC.getItemStack(item);
            Item mcItem = itemStack.func_77973_b();
            if (!this.quickList.containsKey(mcItem)) continue;
            this.quickList.get(mcItem).remove(pattern);
        }
    }

    private class OverridingFuelHandler
    implements IFuelHandler {
        private OverridingFuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (FuelTweaker.this.quickList.containsKey(fuel.func_77973_b())) {
                IItemStack stack = MineTweakerMC.getIItemStack(fuel);
                for (SetFuelPattern override : (List)FuelTweaker.this.quickList.get(fuel.func_77973_b())) {
                    if (!override.getPattern().matches(stack)) continue;
                    return override.getValue();
                }
            }
            int max = 0;
            for (IFuelHandler handler : FuelTweaker.this.original) {
                max = Math.max(max, handler.getBurnTime(fuel));
            }
            return max;
        }
    }
}

