/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.skin.cape.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tlauncher.skin.cape.model.MinecraftProfileTextureDTO;
import org.tlauncher.skin.cape.model.PreparedTextureData;
import org.tlauncher.skin.cape.util.TextureUtils;

public class PreparedProfileManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService pool = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build());
    private final Set<String> addedNames = new HashSet<String>();
    private LinkedBlockingQueue<PreparedTextureData> preparedData = new LinkedBlockingQueue();
    private static final int UP_VERGE_LOAD_FRAME = 30;
    private static int machinePerformance = 1;

    public PreparedProfileManager() {
        this.calculateSizeCape();
        this.addNewName(Minecraft.func_71410_x().func_110432_I().func_111285_a());
    }

    private void calculateSizeCape() {
        try {
            PreparedTextureData texture = new PreparedTextureData();
            final MinecraftProfileTextureDTO test = new MinecraftProfileTextureDTO();
            test.setCapeHeight(272);
            test.setAnimatedCape(true);
            texture.setProfileTextureDTO((Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO>)new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO>(){
                {
                    this.put(MinecraftProfileTexture.Type.CAPE, test);
                }
            });
            final BufferedImage image = ImageIO.read(PreparedProfileManager.class.getResource("cape_test_272.png"));
            texture.setImages((Map<MinecraftProfileTexture.Type, BufferedImage>)new HashMap<MinecraftProfileTexture.Type, BufferedImage>(){
                {
                    this.put(MinecraftProfileTexture.Type.CAPE, image);
                }
            });
            List<BufferedImage> list = this.cutAnimatedCape(texture, test);
            long l = System.currentTimeMillis();
            for (BufferedImage b : list) {
                new DynamicTexture(b);
            }
            l = (System.currentTimeMillis() - l) / (long)list.size();
            if (l > 30L) {
                machinePerformance = 2;
            }
            LOGGER.debug(String.format("middle time to prepare frame of the org.tlauncher.skin.cape is %s, performance %s", l, machinePerformance));
        }
        catch (Throwable t) {
            LOGGER.error("couldn't calculate size of the org.tlauncher.skin.cape", t);
        }
    }

    public void addNewName(String playerName) {
        if (!this.addedNames.contains(playerName)) {
            this.addedNames.add(playerName);
            CompletableFuture.runAsync(() -> {
                PreparedTextureData texture = new PreparedTextureData();
                texture.setName(playerName);
                try {
                    Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> profile = this.loadProfileData0(playerName);
                    texture.setProfileTextureDTO(profile);
                    this.downloadAndValidateImage(profile, texture);
                    this.preparedFramesForCape(texture);
                    this.preparedFrameForSkin(texture);
                    LOGGER.debug("finished downloading data " + playerName);
                }
                catch (Throwable io) {
                    LOGGER.warn("error", io);
                }
                this.preparedData.add(texture);
            }, this.pool);
        }
    }

    private void preparedFrameForSkin(PreparedTextureData texture) {
        BufferedImage image = texture.getImages().get(MinecraftProfileTexture.Type.SKIN);
        if (Objects.nonNull(image)) {
            image = TextureUtils.getRightSkin(image);
            texture.getImages().put(MinecraftProfileTexture.Type.SKIN, image);
            int[] elm = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), elm, 0, image.getWidth());
            texture.setSkin(elm);
        }
    }

    private void preparedFramesForCape(PreparedTextureData texture) {
        MinecraftProfileTextureDTO p = texture.getProfileTextureDTO().get(MinecraftProfileTexture.Type.CAPE);
        if (Objects.isNull(p)) {
            return;
        }
        if (!Objects.equals(p.isAnimatedCape(), true)) {
            BufferedImage bufferedImage = texture.getImages().get(MinecraftProfileTexture.Type.CAPE);
            p.setCapeWidth(bufferedImage.getWidth());
            p.setCapeHeight(bufferedImage.getHeight());
            texture.getCapeFrames().add(bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth()));
            return;
        }
        for (BufferedImage image : this.cutAnimatedCape(texture, p)) {
            texture.getCapeFrames().add(image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth()));
        }
    }

    private List<BufferedImage> cutAnimatedCape(PreparedTextureData texture, MinecraftProfileTextureDTO p) {
        BufferedImage image = texture.getImages().get(MinecraftProfileTexture.Type.CAPE);
        int frameHeight = p.getCapeHeight();
        int frameWidth = p.getCapeHeight() / 17 * 22;
        p.setCapeWidth(frameWidth);
        int xFrames = image.getWidth() / frameWidth;
        int yFrames = image.getHeight() / frameHeight;
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
        for (int j = 0; j < xFrames; ++j) {
            for (int i = 0; i < yFrames; ++i) {
                BufferedImage image1 = new BufferedImage(frameWidth / 22 * 64, frameHeight / 17 * 32, 6);
                boolean flag = false;
                for (int y = 0; y < frameHeight; ++y) {
                    for (int x = 0; x < frameWidth; ++x) {
                        int alpha;
                        int color = image.getRGB(j * frameWidth + x, i * frameHeight + y);
                        if (!flag && (alpha = color >>> 24 & 0xFF) != 0) {
                            flag = true;
                        }
                        try {
                            image1.setRGB(x, y, color);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            LOGGER.error("Coordinates: x " + x + " y " + y + " color " + color, (Throwable)e);
                        }
                    }
                }
                if (!flag) {
                    return list;
                }
                list.add(image1);
            }
        }
        return list;
    }

    private Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> loadProfileData0(String playerName) throws IOException {
        IOException exception = new IOException("can't download profile");
        for (int i = 0; i < 3; ++i) {
            try {
                return this.loadProfileData(playerName);
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw exception;
    }

    private Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> loadProfileData(String playerName) throws IOException {
        Gson gson = new Gson();
        playerName = URLEncoder.encode(playerName, "UTF-8");
        URL url = new URL(String.format("http://auth.tlauncher.org:8080/skin/profile/texture/login/%s", playerName));
        URLConnection urlConnection = url.openConnection();
        urlConnection.setConnectTimeout(40000);
        urlConnection.setReadTimeout(30000);
        StringWriter writer = new StringWriter();
        InputStream inputStream = urlConnection.getInputStream();
        IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        String response = writer.toString();
        Map textureMap = (Map)gson.fromJson(response, new TypeToken<HashMap<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO>>(){}.getType());
        inputStream.close();
        return textureMap;
    }

    private void downloadAndValidateImage(Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> profile, PreparedTextureData texture) throws IOException {
        for (Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> entry : profile.entrySet()) {
            BufferedImage image = this.downloadImage0(entry);
            if (entry.getKey().equals((Object)MinecraftProfileTexture.Type.CAPE) && (image.getWidth() % 22 != 0 || image.getHeight() % 17 != 0) && (image.getWidth() % 64 != 0 || image.getHeight() % 32 != 0)) continue;
            if (entry.getKey().equals((Object)MinecraftProfileTexture.Type.CAPE) && machinePerformance == 2) {
                profile.get(MinecraftProfileTexture.Type.CAPE).setCapeHeight(136);
                image = TextureUtils.resize(image, image.getWidth() / 2, image.getHeight() / 2);
            }
            texture.getImages().put(entry.getKey(), image);
        }
    }

    private BufferedImage downloadImage0(Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> entry) throws IOException {
        IOException exception = new IOException("can't load image");
        for (int i = 0; i < 3; ++i) {
            try {
                return ImageIO.read(new URL(entry.getValue().getUrl()));
            }
            catch (IOException io) {
                exception = io;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw exception;
    }

    public void removeByName(String name) {
        this.addedNames.remove(name);
    }

    public PreparedTextureData peek() {
        return this.preparedData.peek();
    }

    public void poll() {
        this.preparedData.poll();
    }
}

