/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import reifnsk.minimap.GLTextureBufferedImage;

public class GLTexture {
    private static String DEFAULT_PACK;
    private static String pack;
    private static ArrayList<GLTexture> list;
    private static GLTexture missing;
    protected static final GLTexture TEMPERATURE;
    protected static final GLTexture HUMIDITY;
    protected static final GLTexture ROUND_MAP;
    protected static final GLTexture ROUND_MAP_MASK;
    protected static final GLTexture SQUARE_MAP;
    protected static final GLTexture SQUARE_MAP_MASK;
    protected static final GLTexture ENTITY;
    protected static final GLTexture ENTITY2;
    protected static final GLTexture LIGHTNING;
    protected static final GLTexture N;
    protected static final GLTexture E;
    protected static final GLTexture W;
    protected static final GLTexture S;
    protected static final GLTexture MMARROW;
    protected static final GLTexture WAYPOINT1;
    protected static final GLTexture WAYPOINT2;
    protected static final GLTexture MARKER1;
    protected static final GLTexture MARKER2;
    private final String fileName;
    private final boolean blur;
    private final boolean clamp;
    private int textureId;

    protected static void setPack(String newPack) {
        if (!newPack.equals(pack)) {
            for (GLTexture glt : list) {
                glt.release();
            }
            pack = newPack;
        }
    }

    private GLTexture(String name, boolean blur, boolean clamp) {
        this.fileName = name;
        this.blur = blur;
        this.clamp = clamp;
        list.add(this);
    }

    protected int[] getData() {
        BufferedImage image = GLTexture.read(this.fileName);
        int w = image.getWidth();
        int h = image.getHeight();
        int[] rgbArray = new int[w * h];
        image.getRGB(0, 0, w, h, rgbArray, 0, w);
        return rgbArray;
    }

    protected void bind() {
        if (this.textureId == 0) {
            BufferedImage image = GLTexture.read(this.fileName);
            if (image == null) {
                this.textureId = this == missing ? -2 : -1;
            } else {
                this.textureId = GL11.glGenTextures();
                int w = image.getWidth();
                int h = image.getHeight();
                int[] rgbArray = new int[w * h];
                image.getRGB(0, 0, w, h, rgbArray, 0, w);
                GLTextureBufferedImage.createTexture(rgbArray, w, h, this.textureId, this.blur, this.clamp);
            }
        }
        if (this.textureId == -2) {
            GL11.glBindTexture((int)3553, (int)0);
        } else {
            if (this.textureId == -1) {
                missing.bind();
            }
            GL11.glBindTexture((int)3553, (int)this.textureId);
        }
    }

    protected void release() {
        if (this.textureId > 0) {
            GL11.glDeleteTextures((int)this.textureId);
        }
        this.textureId = 0;
    }

    private static BufferedImage read(String name) {
        BufferedImage image = GLTexture.readImage(pack + name);
        return image == null ? GLTexture.readImage(DEFAULT_PACK + name) : image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readImage(String stream) {
        BufferedImage bufferedimage2;
        InputStream in = GLTexture.class.getResourceAsStream(stream);
        if (in == null) {
            return null;
        }
        try {
            BufferedImage bufferedimage2;
            BufferedImage bufferedImage = bufferedimage2 = ImageIO.read(in);
            return bufferedImage;
        }
        catch (Exception e) {
            bufferedimage2 = null;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return bufferedimage2;
    }

    static {
        pack = DEFAULT_PACK = "/assets/reifnsk/textures/minimap/";
        list = new ArrayList();
        missing = new GLTexture("missing.png", true, false);
        TEMPERATURE = new GLTexture("temperature.png", true, true);
        HUMIDITY = new GLTexture("humidity.png", true, true);
        ROUND_MAP = new GLTexture("roundmap.png", true, true);
        ROUND_MAP_MASK = new GLTexture("roundmap_mask.png", false, true);
        SQUARE_MAP = new GLTexture("squaremap.png", true, true);
        SQUARE_MAP_MASK = new GLTexture("squaremap_mask.png", false, true);
        ENTITY = new GLTexture("entity.png", true, true);
        ENTITY2 = new GLTexture("entity2.png", true, true);
        LIGHTNING = new GLTexture("lightning.png", true, true);
        N = new GLTexture("n.png", true, true);
        E = new GLTexture("e.png", true, true);
        W = new GLTexture("w.png", true, true);
        S = new GLTexture("s.png", true, true);
        MMARROW = new GLTexture("mmarrow.png", true, true);
        WAYPOINT1 = new GLTexture("waypoint.png", true, true);
        WAYPOINT2 = new GLTexture("waypoint2.png", true, true);
        MARKER1 = new GLTexture("marker.png", true, true);
        MARKER2 = new GLTexture("marker2.png", true, true);
    }
}

