/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest.worldManager;

import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.quest.worldManager.SchematicStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class OnTickBuilder {
    int mobID;
    boolean replaceBanner;
    int buildingStep;
    Schematic cachedSchematic;
    int schematicSize;
    int schematicStep;
    List<SchematicStorage> buildingPlans = new ArrayList<SchematicStorage>();
    Random rand = new Random();

    protected void setSchematicSize(int size) {
        this.schematicSize = size;
    }

    protected int getSchematicSize() {
        return this.schematicSize;
    }

    protected void setSchematicStep(int size) {
        this.schematicStep = size;
    }

    protected int getSchematicStep() {
        return this.schematicStep;
    }

    public void setMobID(int idMob, boolean replaceBanners) {
        this.mobID = idMob;
        this.replaceBanner = replaceBanners;
    }

    public void addBuildingPlans(Schematic schematic, int posX, int posY, int posZ) {
        SchematicStorage storage = new SchematicStorage(posX, posY, posZ);
        storage.schematic = schematic;
        this.buildingPlans.add(storage);
        this.schematicSize += schematic.width * schematic.length * schematic.height * 2;
    }

    public void onUpdate(World worldObj) {
        if (worldObj.field_72995_K && this.getSchematicSize() > 0) {
            BuilderHelper.builderHelper.setStructureGenerationAmmount(this.getSchematicStep() * 100 / this.getSchematicSize());
        }
        int speed = 2000;
        if (this.cachedSchematic == null) {
            this.startBuilding();
            return;
        }
        int schematicSize = this.cachedSchematic.width * this.cachedSchematic.length * this.cachedSchematic.height;
        for (int i = 0; i < speed; ++i) {
            int step;
            if ((step = this.buildingStep++) < schematicSize * 2) {
                boolean isFirsPass;
                boolean bl = isFirsPass = step < schematicSize;
                if (!isFirsPass) {
                    step -= schematicSize;
                }
                if (BuilderHelper.builderHelper.buildStep(this.rand, worldObj, this.cachedSchematic, step, isFirsPass, this.mobID, true, this.replaceBanner)) {
                    // empty if block
                }
                ++this.buildingStep;
                this.setSchematicStep(this.getSchematicStep() + 1);
                continue;
            }
            int entityIndex = step - schematicSize * 2;
            if (BuilderHelper.builderHelper.putEntities(worldObj, this.cachedSchematic, entityIndex)) continue;
            this.nextSchematic();
            return;
        }
    }

    protected void nextSchematic() {
        this.buildingStep = 0;
        this.buildingPlans.remove(0);
        this.cachedSchematic = null;
    }

    protected void startBuilding() {
        if (this.buildingPlans.size() > 0) {
            SchematicStorage currentPlans = this.buildingPlans.get(0);
            this.cachedSchematic = currentPlans.schematic;
            this.cachedSchematic.setPosition(currentPlans.posX, currentPlans.posY, currentPlans.posZ);
        } else {
            this.reset();
        }
    }

    public void reset() {
    }

    protected void readFromNBT(NBTTagCompound tag) {
        this.buildingStep = tag.func_74762_e("step");
        this.mobID = tag.func_74762_e("mobID");
        this.replaceBanner = tag.func_74767_n("banner");
        NBTTagList list = tag.func_150295_c("plans", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            SchematicStorage storage = new SchematicStorage(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z"));
            storage.schematic = new Schematic(t.func_74775_l("schematic"));
            this.buildingPlans.add(storage);
        }
    }

    protected void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("step", this.buildingStep);
        tag.func_74768_a("mobID", this.mobID);
        tag.func_74757_a("banner", this.replaceBanner);
        NBTTagList list = new NBTTagList();
        for (SchematicStorage buildingPlan : this.buildingPlans) {
            NBTTagCompound buildingPlanTag = new NBTTagCompound();
            NBTTagCompound schematicTag = new NBTTagCompound();
            buildingPlan.schematic.saveToNBT(schematicTag);
            buildingPlanTag.func_74782_a("schematic", (NBTBase)schematicTag);
            buildingPlanTag.func_74768_a("x", buildingPlan.posX);
            buildingPlanTag.func_74768_a("y", buildingPlan.posY);
            buildingPlanTag.func_74768_a("z", buildingPlan.posZ);
            list.func_74742_a((NBTBase)buildingPlanTag);
        }
        tag.func_74782_a("plans", (NBTBase)list);
    }
}

