/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.packets;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.block.BlockEditorTileEntity;
import com.chocolate.chocolateQuest.block.BlockMobSpawnerTileEntity;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.items.mobControl.ItemMobToSpawner;
import com.chocolate.chocolateQuest.packets.Coords;
import com.chocolate.chocolateQuest.packets.PacketBase;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PacketEditorGUIClose
implements IMessage,
IMessageHandler<PacketEditorGUIClose, IMessage> {
    int x;
    int y;
    int z;
    int width;
    int height;
    int length;
    String text;
    byte action;
    List<Coords> coords;

    public PacketEditorGUIClose() {
    }

    public PacketEditorGUIClose(int posX, int posY, int posZ, int width, int length, int height, String name, byte action) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.width = width;
        this.length = length;
        this.height = height;
        this.text = name;
        this.action = action;
    }

    public void fromBytes(ByteBuf inputStream) {
        this.x = inputStream.readInt();
        this.y = inputStream.readInt();
        this.z = inputStream.readInt();
        this.width = inputStream.readInt();
        this.length = inputStream.readInt();
        this.height = inputStream.readInt();
        this.text = PacketBase.readString(inputStream);
        this.action = inputStream.readByte();
    }

    public void toBytes(ByteBuf outputStream) {
        outputStream.writeInt(this.x);
        outputStream.writeInt(this.y);
        outputStream.writeInt(this.z);
        outputStream.writeInt(this.width);
        outputStream.writeInt(this.length);
        outputStream.writeInt(this.height);
        PacketBase.writeString(outputStream, this.text);
        outputStream.writeByte((int)this.action);
    }

    public IMessage onMessage(PacketEditorGUIClose message, MessageContext ctx) {
        EntityPlayerMP entityPlayer = ctx.getServerHandler().field_147369_b;
        message.execute((EntityPlayer)entityPlayer);
        return null;
    }

    public void execute(EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.func_147439_a(this.x, this.y, this.z) == ChocolateQuest.exporter) {
            BlockEditorTileEntity eb = (BlockEditorTileEntity)world.func_147438_o(this.x, this.y, this.z);
            eb.red = this.width;
            eb.yellow = this.length;
            eb.height = this.height;
            eb.name = this.text;
        }
        if (this.action == 1) {
            this.putEntitiesIntoSpawners(world, this.x, this.y, this.z, this.width, this.height, this.length);
            PacketEditorGUIClose.copy(world, this.x, this.y, this.z, this.width, this.height, this.length, this.text);
            this.spawnEntitiesFromSpawners(world);
        }
    }

    public void putEntitiesIntoSpawners(World world, int x, int y, int z, int sx, int sy, int sz) {
        List humans = world.func_72872_a(EntityHumanBase.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + sx), (double)(y + sy), (double)(z + sz)));
        this.coords = new ArrayList<Coords>();
        for (EntityHumanBase human : humans) {
            if (human.field_70128_L) continue;
            if (human.party != null) {
                if (human.party.getLeader() != human) continue;
                this.putEntityIntoSpawner(human);
                continue;
            }
            this.putEntityIntoSpawner(human);
        }
    }

    public void putEntityIntoSpawner(EntityHumanBase human) {
        int x = MathHelper.func_76128_c((double)human.field_70165_t);
        int y = MathHelper.func_76128_c((double)human.field_70163_u);
        int z = MathHelper.func_76128_c((double)human.field_70161_v);
        this.coords.add(new Coords(x, y, z));
        ItemMobToSpawner.saveToSpawner(x, y, z, human);
    }

    public void spawnEntitiesFromSpawners(World world) {
        for (Coords coord : this.coords) {
            TileEntity te = world.func_147438_o(coord.x, coord.y, coord.z);
            if (!(te instanceof BlockMobSpawnerTileEntity)) continue;
            BlockMobSpawnerTileEntity teSpawner = (BlockMobSpawnerTileEntity)te;
            teSpawner.spawnEntity();
            world.func_147468_f(coord.x, coord.y, coord.z);
        }
    }

    public static void copy(World world, int i, int j, int k, int sx, int sy, int sz, String name) {
        Schematic data = new Schematic(sx, sy, sz, ++i, j, ++k, name);
        boolean cont = false;
        for (int iX = 0; iX < sx; ++iX) {
            for (int iY = 0; iY < sy; ++iY) {
                for (int iZ = 0; iZ < sz; ++iZ) {
                    int x = iX + i;
                    int y = iY + j;
                    int z = iZ + k;
                    data.setBlock(x, y, z, world.func_147439_a(x, y, z));
                    data.setBlockMetadata(x, y, z, (byte)world.func_72805_g(x, y, z));
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (te == null) continue;
                    data.addTileEntity(te);
                }
            }
        }
        List li = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + sx), (double)(j + sy), (double)(k + sz)));
        for (int r = 0; r < li.size(); ++r) {
            Entity e = (Entity)li.get(r);
            if (e instanceof EntityPlayer || e instanceof EntityBat) continue;
            data.addEntity(e);
        }
        File file = new File(Minecraft.func_71410_x().field_71412_D, "config/Chocolate/DungeonConfig/Building/export/" + name + ".schematic");
        data.save(file);
    }
}

