/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.magic;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.magic.SpellBase;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class SpellMiner
extends SpellBase {
    private static Map<String, Integer> timers = new HashMap<String, Integer>(4, 0.75f);

    @Override
    public void onCastStart(EntityLivingBase shooter, Elements element, ItemStack is) {
        if (shooter instanceof EntityPlayer) {
            int dist = this.getRange(is);
            MovingObjectPosition mop = HelperPlayer.getBlockMovingObjectPositionFromPlayer(shooter.field_70170_p, shooter, dist, true);
            if (mop != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", mop.field_72311_b);
                tag.func_74768_a("y", mop.field_72312_c);
                tag.func_74768_a("z", mop.field_72309_d);
                tag.func_74768_a("s", mop.field_72310_e);
                if (shooter.field_70170_p.field_72995_K) {
                    timers.put(shooter.func_70005_c_(), 0);
                }
                is.field_77990_d.func_74782_a("miningBlock", (NBTBase)tag);
            } else {
                is.field_77990_d.func_82580_o("miningBlock");
            }
        }
    }

    @Override
    public void onUpdate(EntityLivingBase shooter, Elements element, ItemStack is, int angle) {
        if (is.field_77990_d.func_74764_b("miningBlock")) {
            EntityPlayer player = (EntityPlayer)shooter;
            World world = player.field_70170_p;
            NBTTagCompound tag = is.field_77990_d.func_74775_l("miningBlock");
            int x = tag.func_74762_e("x");
            int y = tag.func_74762_e("y");
            int z = tag.func_74762_e("z");
            int s = tag.func_74762_e("s");
            int time = timers.get(shooter.func_70005_c_());
            if (!world.field_72995_K) {
                timers.put(shooter.func_70005_c_(), ++time);
            }
            float mineSpeed = this.getDamage(is) * 5.0f;
            this.blockInteraction(world, player, x, y, z, time, mineSpeed);
            if (this.isAreaMiner()) {
                int dz1;
                int dy1;
                int dx1;
                int dz0;
                int dy0;
                int dx0;
                int expansion = this.getExpansion(is);
                if (expansion > 0) {
                    dx0 = 0;
                    dy0 = 0;
                    dz0 = 0;
                    dx1 = 0;
                    dy1 = 0;
                    dz1 = 0;
                    switch (s) {
                        case 0: 
                        case 1: {
                            dz0 = 1;
                            dz1 = -1;
                            break;
                        }
                        case 2: 
                        case 3: {
                            dy0 = 1;
                            dy1 = -1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            dy0 = 1;
                            dy1 = -1;
                        }
                    }
                    this.blockInteraction(world, player, x + dx0, y + dy0, z + dz0, time, mineSpeed);
                    this.blockInteraction(world, player, x + dx1, y + dy1, z + dz1, time, mineSpeed);
                }
                if (expansion > 2) {
                    dx0 = 0;
                    dy0 = 0;
                    dz0 = 0;
                    dx1 = 0;
                    dy1 = 0;
                    dz1 = 0;
                    switch (s) {
                        case 0: 
                        case 1: {
                            dx0 = 1;
                            dx1 = -1;
                            break;
                        }
                        case 2: 
                        case 3: {
                            dx0 = 1;
                            dx1 = -1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            dz0 = 1;
                            dz1 = -1;
                        }
                    }
                    this.blockInteraction(world, player, x + dx0, y + dy0, z + dz0, time, mineSpeed);
                    if (expansion > 2) {
                        this.blockInteraction(world, player, x + dx1, y + dy1, z + dz1, time, mineSpeed);
                    }
                }
                if (expansion > 3) {
                    dx0 = 0;
                    dy0 = 0;
                    dz0 = 0;
                    dx1 = 0;
                    dy1 = 0;
                    dz1 = 0;
                    switch (s) {
                        case 0: {
                            dx0 = 1;
                            dx1 = 1;
                            dz0 = 1;
                            dz1 = -1;
                            break;
                        }
                        case 1: {
                            dx0 = 1;
                            dx1 = -1;
                            dz0 = 1;
                            dz1 = 1;
                            break;
                        }
                        case 2: 
                        case 3: {
                            dx0 = 1;
                            dx1 = -1;
                            dy0 = -1;
                            dy1 = -1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            dz0 = 1;
                            dz1 = -1;
                            dy0 = -1;
                            dy1 = -1;
                        }
                    }
                    this.blockInteraction(world, player, x + dx0, y + dy0, z + dz0, time, mineSpeed);
                    this.blockInteraction(world, player, x + dx1, y + dy1, z + dz1, time, mineSpeed);
                }
                if (expansion > 4) {
                    dx0 = 0;
                    dy0 = 0;
                    dz0 = 0;
                    dx1 = 0;
                    dy1 = 0;
                    dz1 = 0;
                    switch (s) {
                        case 0: {
                            dx0 = 1;
                            dx1 = 1;
                            dz0 = -1;
                            dz1 = 1;
                            break;
                        }
                        case 1: {
                            dx0 = 1;
                            dx1 = -1;
                            dz0 = -1;
                            dz1 = -1;
                            break;
                        }
                        case 2: 
                        case 3: {
                            dx0 = 1;
                            dx1 = -1;
                            dy0 = 1;
                            dy1 = 1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            dz0 = 1;
                            dz1 = -1;
                            dy0 = 1;
                            dy1 = 1;
                        }
                    }
                    this.blockInteraction(world, player, x + dx0, y + dy0, z + dz0, time, mineSpeed);
                    this.blockInteraction(world, player, x + dx1, y + dy1, z + dz1, time, mineSpeed);
                }
            }
        }
    }

    public void blockInteraction(World world, EntityPlayer player, int x, int y, int z, int useTime, float mineSpeed) {
        Block block = world.func_147439_a(x, y, z);
        if (block != Blocks.field_150350_a) {
            if (world.field_72995_K) {
                int blockID = Block.func_149682_b((Block)block);
                world.func_72869_a("blockcrack_" + blockID + "_" + world.func_72805_g(x, y, z), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
                for (int i = 0; i < 5; ++i) {
                    double dist = player.func_70681_au().nextFloat();
                    world.func_72869_a("blockcrack_" + blockID + "_" + world.func_72805_g(x, y, z), (double)x + 0.5 - ((double)x - player.field_70165_t) * dist, (double)y + 0.5 - ((double)y - player.field_70163_u) * dist, (double)z + 0.5 - ((double)z - player.field_70161_v) * dist, 0.0, 0.0, 0.0);
                }
            } else if (world.func_72962_a(player, x, z, y) && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_150417_aV && block != ChocolateQuest.dungeonBrick && (float)useTime > block.func_149712_f(world, x, y, z) * mineSpeed) {
                world.func_147468_f(x, y, z);
            }
        }
    }

    @Override
    public void onShoot(EntityLivingBase shooter, Elements element, ItemStack is, int chargeTime) {
        timers.remove(shooter.func_70005_c_());
    }

    @Override
    public boolean isProjectile() {
        return super.isProjectile();
    }

    @Override
    public boolean shouldStartCasting(ItemStack is, EntityLivingBase shooter, Entity target) {
        return false;
    }

    @Override
    public boolean shouldUpdate() {
        return true;
    }

    @Override
    public int getCoolDown() {
        return 20;
    }

    @Override
    public float getCost(ItemStack itemstack) {
        return 0.5f;
    }

    public boolean isAreaMiner() {
        return false;
    }

    @Override
    public int getRange(ItemStack itemstack) {
        return 10 + this.getExpansion(itemstack) * 4;
    }
}

