/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items;

import com.chocolate.chocolateQuest.API.ICooldownTracker;
import com.chocolate.chocolateQuest.API.IRangedWeapon;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.gui.InventoryBag;
import com.chocolate.chocolateQuest.items.CoolDownTracker;
import com.chocolate.chocolateQuest.items.ItemArmorMage;
import com.chocolate.chocolateQuest.items.gun.ILoadableGun;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.magic.SpellBase;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import com.chocolate.chocolateQuest.utils.PlayerManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class ItemStaffBase
extends Item
implements ILoadableGun,
IRangedWeapon,
ICooldownTracker {
    int cooldown = 10;
    Elements element;
    public static final String TAG_NO_RENDER = "noRender";
    public static final String TAG_SPELL_AMMOUNT = "spells";
    public static final String TAG_WAND = "wand";
    public static final String TAG_COOLDOWN = "cooldown";
    public static final String TAG_MANA_COST = "cost";
    public static final String TAG_ROSARY = "rosary";
    public static final String TAG_DAMAGE = "damage";
    public static final String TAG_LOCKED = "locked";
    public static final String TAG_MELEE = "melee";
    @SideOnly(value=Side.CLIENT)
    public IIcon rosaryIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon wandIcon;
    CoolDownTracker cachedTracker;

    public ItemStaffBase() {
        this.func_77625_d(1);
    }

    public ItemStaffBase(Elements element) {
        this();
        this.element = element;
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        ItemStack is = new ItemStack(item);
        list.add(is);
        is = new ItemStack(item);
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74776_a(TAG_DAMAGE, 3.0f);
        is.field_77990_d.func_74768_a(TAG_MANA_COST, 10);
        is.field_77990_d.func_74757_a(TAG_WAND, true);
        list.add(is);
        is = new ItemStack(item);
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74776_a(TAG_DAMAGE, 3.0f);
        is.field_77990_d.func_74776_a(TAG_COOLDOWN, 10.0f);
        is.field_77990_d.func_74757_a(TAG_ROSARY, true);
        list.add(is);
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rnd, WeightedRandomChestContent original) {
        ItemStack is = original.field_76297_b;
        is.field_77990_d = new NBTTagCompound();
        float damageBase = 2.0f;
        int damageValue = 4;
        int cooldownValue = 25;
        int manaValue = 25;
        int type = rnd.nextInt(3);
        if (type == 0) {
            damageValue = 8;
            damageBase = 3.0f;
        }
        if (type == 1) {
            cooldownValue = 50;
            is.field_77990_d.func_74757_a(TAG_ROSARY, true);
        }
        if (type == 2) {
            manaValue = 50;
            is.field_77990_d.func_74757_a(TAG_WAND, true);
        }
        is.field_77990_d.func_74776_a(TAG_DAMAGE, damageBase + (float)BDHelper.getRandomValue(rnd) * (float)damageValue);
        if (type == 1 || rnd.nextBoolean()) {
            is.field_77990_d.func_74768_a(TAG_COOLDOWN, (int)(BDHelper.getRandomValue(rnd) * (double)cooldownValue));
        }
        if (type == 2 || rnd.nextBoolean()) {
            is.field_77990_d.func_74768_a(TAG_MANA_COST, (int)(BDHelper.getRandomValue(rnd) * (double)manaValue));
        }
        is.field_77990_d.func_74768_a(TAG_SPELL_AMMOUNT, 1 + (int)(BDHelper.getRandomValue(rnd) * 7.0));
        return original;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("chocolatequest:" + this.func_77658_a().replace("item.", ""));
        this.rosaryIcon = iconRegister.func_94245_a("chocolatequest:" + this.func_77658_a().replace("item.staff", TAG_ROSARY));
        this.wandIcon = iconRegister.func_94245_a("chocolatequest:" + this.func_77658_a().replace("item.staff", TAG_WAND));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b(TAG_ROSARY)) {
            return this.rosaryIcon;
        }
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b(TAG_WAND)) {
            return this.wandIcon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 1;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(is, player, list, par4);
        if (is.field_77990_d != null) {
            ItemStack[] cargo;
            if (is.field_77990_d.func_74764_b(TAG_NO_RENDER)) {
                list.add("noRender:true");
            }
            if (is.field_77990_d.func_74764_b(TAG_LOCKED)) {
                list.add(EnumChatFormatting.OBFUSCATED + "Locked");
            }
            if (is.field_77990_d.func_74764_b(TAG_SPELL_AMMOUNT)) {
                list.add(StatCollector.func_74838_a((String)"strings.spells").trim() + ": " + this.getAmmoLoaderAmmount(is));
            }
            for (ItemStack itemStack : cargo = InventoryBag.getCargo(is)) {
                if (itemStack == null) continue;
                list.add(" " + EnumChatFormatting.DARK_GRAY + itemStack.func_77973_b().func_77653_i(itemStack));
            }
            for (Awakements awakements : Awakements.awekements) {
                if (!Awakements.hasEnchant(is, awakements)) continue;
                list.add(awakements.getDescription(is));
            }
            if (is.field_77990_d.func_74764_b(TAG_COOLDOWN)) {
                int n = is.field_77990_d.func_74762_e(TAG_COOLDOWN);
                list.add(BDHelper.formatNumberToDisplay(-n, true) + "% " + StatCollector.func_74838_a((String)"armorbonus.cast_speed.name").trim());
            }
            if (is.field_77990_d.func_74764_b(TAG_MANA_COST)) {
                int n = is.field_77990_d.func_74762_e(TAG_MANA_COST);
                list.add(BDHelper.formatNumberToDisplay(-n, true) + "% " + StatCollector.func_74838_a((String)"armorbonus.spell_cost.name").trim());
            }
        }
        float ammount = ItemStaffBase.getMagicDamage(is);
        list.add(BDHelper.formatNumberToDisplay(ammount) + " " + StatCollector.func_74838_a((String)"weaponbonus.spell_damage.name").trim() + " " + BDHelper.StringColor(this.element.stringColor) + "(" + this.element.getTranslatedName() + ")");
    }

    public String func_77653_i(ItemStack itemstack) {
        String name = this.func_77657_g(itemstack);
        if (itemstack.field_77990_d != null) {
            if (itemstack.field_77990_d.func_74764_b(TAG_ROSARY)) {
                name = name.replace("staff", TAG_ROSARY);
            }
            if (itemstack.field_77990_d.func_74764_b(TAG_WAND)) {
                name = name.replace("staff", TAG_WAND);
            }
        }
        name = ("" + StatCollector.func_74838_a((String)(name + ".name"))).trim();
        return name;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            entityPlayer.openGui((Object)ChocolateQuest.instance, 3, entityPlayer.field_70170_p, 0, 0, 0);
            return itemstack;
        }
        ItemStack[] cargo = InventoryBag.getCargo(itemstack);
        if (cargo[0] != null && cargo[0].field_77990_d == null) {
            SpellBase spell = this.getSpell(itemstack);
            spell.onCastStart((EntityLivingBase)entityPlayer, this.element, itemstack);
            entityPlayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return super.func_77659_a(itemstack, world, entityPlayer);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityPlayer, int useTime) {
        useTime = this.func_77626_a(itemstack) - useTime;
        useTime = Math.min(useTime + 1, 60);
        SpellBase spell = this.getSpell(itemstack);
        if (spell != null && spell.isProjectile()) {
            spell.onShoot((EntityLivingBase)entityPlayer, this.getElement(itemstack), itemstack, useTime);
            ItemStack[] spellsStack = InventoryBag.getCargo(itemstack);
            if (spellsStack[0].field_77990_d == null) {
                spellsStack[0].field_77990_d = new NBTTagCompound();
            }
            float castSpeed = ItemStaffBase.getEntityCoolDownReduction((EntityLivingBase)entityPlayer);
            spellsStack[0].field_77990_d.func_74768_a("cd", (int)((float)spell.getCoolDown() * castSpeed));
            InventoryBag.saveCargo(itemstack, spellsStack);
            float manaCost = ItemStaffBase.getEntityManaCost((EntityLivingBase)entityPlayer);
            PlayerManager.useStamina(entityPlayer, spell.getCost(itemstack) * manaCost, true);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player;
            if (Awakements.hasEnchant(itemStack, Awakements.property)) {
                Awakements.property.onUpdate(entity, itemStack);
            }
            if (Awakements.hasEnchant(itemStack, Awakements.autoRepair)) {
                Awakements.autoRepair.onUpdate(entity, itemStack);
            }
            if ((player = (EntityPlayer)entity).func_71039_bw() && player.func_71124_b(0) == itemStack) {
                SpellBase spell = this.getSpell(itemStack);
                if (spell != null && spell.shouldUpdate()) {
                    spell.onUpdate((EntityLivingBase)entity, this.getElement(itemStack), itemStack, 30);
                    if (entity instanceof EntityPlayer) {
                        float manaCost = ItemStaffBase.getEntityManaCost((EntityLivingBase)entity);
                        PlayerManager.useStamina((EntityPlayer)entity, spell.getCost(itemStack) * manaCost, true);
                    }
                }
            } else {
                NBTTagCompound tag = itemStack.field_77990_d;
                if (tag != null) {
                    ItemStack[] cargo = InventoryBag.getCargo(itemStack);
                    for (int i = 0; i < cargo.length; ++i) {
                        if (cargo[i] == null || cargo[i].field_77990_d == null) continue;
                        int cd = cargo[i].field_77990_d.func_74762_e("cd");
                        if (cd > 0) {
                            cargo[i].field_77990_d.func_74768_a("cd", cd - 1);
                            continue;
                        }
                        cargo[i].field_77990_d = null;
                    }
                    InventoryBag.saveCargo(itemStack, cargo);
                    if (cargo[0] != null) {
                        if (cargo[0].field_77990_d != null) {
                            int cd = cargo[0].field_77990_d.func_74762_e("cd");
                            if (cd > 0) {
                                itemStack.func_77964_b(cd);
                            } else {
                                itemStack.func_77964_b(-1);
                            }
                        } else {
                            itemStack.func_77964_b(-1);
                        }
                    }
                }
            }
        } else {
            this.onUpdateEntity(itemStack, world, entity, par4, par5);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        Awakements.property.onEntityItemUpdate(entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    public static float getEntityManaCost(EntityLivingBase entity) {
        float manaCost = 1.0f;
        for (int i = 1; i < 5; ++i) {
            ItemStack equipement = entity.func_71124_b(i);
            if (equipement == null || !(equipement.func_77973_b() instanceof ItemArmorMage)) continue;
            manaCost = (float)((double)manaCost - 0.01 * (double)((ItemArmorMage)equipement.func_77973_b()).getCostReduction(equipement));
        }
        ItemStack equipement = entity.func_71124_b(0);
        if (equipement != null) {
            manaCost *= ItemStaffBase.getStaffCastCost(equipement);
        }
        return manaCost;
    }

    public static float getEntityCoolDownReduction(EntityLivingBase entity) {
        float castSpeed = 1.0f;
        for (int i = 1; i < 5; ++i) {
            ItemStack equipement = entity.func_71124_b(i);
            if (equipement == null || !(equipement.func_77973_b() instanceof ItemArmorMage)) continue;
            castSpeed = (float)((double)castSpeed - 0.01 * (double)((ItemArmorMage)equipement.func_77973_b()).getCooldownReduction(equipement));
        }
        ItemStack equipement = entity.func_71124_b(0);
        if (equipement != null) {
            castSpeed *= ItemStaffBase.getStaffCastSpeed(equipement);
        }
        return castSpeed;
    }

    public static float getStaffCastSpeed(ItemStack is) {
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b(TAG_COOLDOWN)) {
            int ammount = is.field_77990_d.func_74762_e(TAG_COOLDOWN);
            return (float)Math.max(0, 100 - ammount) / 100.0f;
        }
        return 1.0f;
    }

    public static float getStaffCastCost(ItemStack is) {
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b(TAG_MANA_COST)) {
            int ammount = is.field_77990_d.func_74762_e(TAG_MANA_COST);
            return (float)(100 - ammount) / 100.0f;
        }
        return 1.0f;
    }

    public static float getMagicDamage(ItemStack is) {
        float ammount = ((ItemStaffBase)is.func_77973_b()).getBaseMagicDamage();
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b(TAG_DAMAGE)) {
            ammount = is.field_77990_d.func_74760_g(TAG_DAMAGE);
        }
        return ammount + (float)Awakements.getEnchantLevel(is, Awakements.spellPower);
    }

    public float getBaseMagicDamage() {
        return 4.0f;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int func_77612_l() {
        return 100;
    }

    public int getDisplayDamage(ItemStack stack) {
        ItemStack[] cargo = InventoryBag.getCargo(stack);
        if (cargo[0] != null) {
            if (cargo[0].field_77990_d != null) {
                SpellBase spell = this.getSpell(stack);
                int damage = cargo[0].field_77990_d.func_74762_e("cd");
                int maxCD = spell.getCoolDown();
                return damage * 100 / maxCD;
            }
            return 100;
        }
        return 0;
    }

    public Entity getTarget(EntityPlayer ep, World world) {
        return HelperPlayer.getTarget((EntityLivingBase)ep, world, 30.0);
    }

    public boolean func_77662_d() {
        return true;
    }

    public CreativeTabs func_77640_w() {
        return ChocolateQuest.tabItems;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public SpellBase getSpell(ItemStack is) {
        ItemStack[] ammo = InventoryBag.getCargo(is);
        if (ammo[0] == null) {
            return null;
        }
        return SpellBase.getSpellByID(ammo[0].func_77960_j());
    }

    public Elements getElement(ItemStack is) {
        if (this.element != null) {
            return this.element;
        }
        return Elements.light;
    }

    @Override
    public int getAmmoLoaderStackSize(ItemStack is) {
        return 1;
    }

    @Override
    public int getAmmoLoaderAmmount(ItemStack is) {
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b(TAG_SPELL_AMMOUNT)) {
            return Math.max(1, is.field_77990_d.func_74762_e(TAG_SPELL_AMMOUNT));
        }
        return 4;
    }

    @Override
    public boolean isValidAmmo(ItemStack is) {
        return is.func_77973_b() == ChocolateQuest.spell;
    }

    @Override
    public int getStackIcon(ItemStack is) {
        return 70;
    }

    @Override
    public float getRange(EntityLivingBase shooter, ItemStack is) {
        int maxRange = 0;
        if (this.cachedTracker != null && this.cachedTracker.castingSpell != null) {
            maxRange = this.cachedTracker.castingSpell.getRange(is);
        } else {
            ItemStack[] spells = InventoryBag.getCargo(is);
            for (int i = 0; i < spells.length; ++i) {
                if (spells[i] == null) continue;
                maxRange = Math.max(maxRange, SpellBase.getSpellByID(spells[i].func_77960_j()).getRange(is));
            }
        }
        return maxRange * maxRange;
    }

    @Override
    public int getCooldown(EntityLivingBase shooter, ItemStack is) {
        return 10;
    }

    @Override
    public void shootFromEntity(EntityLivingBase shooter, ItemStack is, int angle, Entity target) {
        if (this.cachedTracker.castingSpell != null) {
            shooter.field_70177_z = shooter.field_70759_as;
            this.cachedTracker.castingSpell.onShoot(shooter, this.getElement(is), is, 5);
        }
        this.cachedTracker.castingSpell = null;
    }

    @Override
    public boolean canBeUsedByEntity(Entity entity) {
        return true;
    }

    @Override
    public boolean isMeleeWeapon(EntityLivingBase shooter, ItemStack is) {
        return is.field_77990_d == null ? false : is.field_77990_d.func_74767_n(TAG_MELEE);
    }

    @Override
    public boolean shouldUpdate(EntityLivingBase shooter) {
        return true;
    }

    @Override
    public int startAiming(ItemStack is, EntityLivingBase shooter, Entity target) {
        for (int i = 0; i < this.cachedTracker.spells.length; ++i) {
            double dist;
            SpellBase spell;
            if (this.cachedTracker.cooldowns[i] != 0 || (spell = this.cachedTracker.spells[i]) == null || !spell.shouldStartCasting(is, shooter, target) || !(target != null ? (dist = shooter.func_70068_e(target)) < (double)(spell.getRange(is) * spell.getRange(is)) : spell.isSupportSpell())) continue;
            return this.mobCastSpell(spell, i, shooter, is);
        }
        return -1;
    }

    private void onUpdateEntity(ItemStack itemStack, World world, Entity entity, int par4, boolean isAiming) {
        SpellBase spell;
        if (this.cachedTracker != null && (spell = this.cachedTracker.castingSpell) != null && spell.shouldUpdate()) {
            spell.onUpdate((EntityLivingBase)entity, this.getElement(itemStack), itemStack, par4);
        }
    }

    @Override
    public Object getCooldownTracker(ItemStack is, Entity entity) {
        return new CoolDownTracker(is);
    }

    @Override
    public boolean shouldStartCasting(ItemStack is, EntityLivingBase entity, boolean isAiming) {
        this.cachedTracker.onUpdate();
        if (this.cachedTracker.castingSpell == null) {
            for (int i = 0; i < this.cachedTracker.spells.length; ++i) {
                SpellBase spell;
                if (this.cachedTracker.cooldowns[i] != 0 || (spell = this.cachedTracker.spells[i]) == null || !spell.isSupportSpell() || !spell.shouldStartCasting(is, entity, null)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void startTick(Object tracker) {
        this.cachedTracker = (CoolDownTracker)tracker;
    }

    public int mobCastSpell(SpellBase spell, int i, EntityLivingBase entity, ItemStack is) {
        this.cachedTracker.castingSpell = spell;
        int n = i;
        this.cachedTracker.cooldowns[n] = (int)((float)this.cachedTracker.cooldowns[n] + ((float)spell.getCoolDown() * ItemStaffBase.getEntityCoolDownReduction(entity) * 2.0f + 10.0f));
        spell.onCastStart(entity, this.getElement(is), is);
        int castTime = spell.getCastingTime();
        if (!spell.shouldUpdate()) {
            castTime = 5 + (int)((float)castTime * ItemStaffBase.getEntityCoolDownReduction(entity));
        }
        return castTime;
    }
}

