/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.ProjectileBase;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileDummy;
import com.chocolate.chocolateQuest.magic.Elements;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBaseBall
extends EntityThrowable
implements IThrowableEntity {
    private ProjectileBase ballData;
    public ItemStack item = null;
    int field_70195_i = 0;
    EntityLivingBase shootingEntity;
    float damageMultiplier = 1.0f;
    final int TYPE = 10;
    final int LEVEL = 11;
    final int ELEMENT = 12;

    public EntityBaseBall(World par1World) {
        super(par1World);
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving) {
        this(world, entityliving, 0);
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving, int type) {
        this(world, entityliving, type, 0);
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving, int type, int lvl, Elements element) {
        super(world, entityliving);
        this.setlvl(lvl);
        this.setElement(element);
        this.shootingEntity = entityliving;
        this.setType(type);
        float s = this.getBallData().getSizeBB();
        this.func_70105_a(s, s);
        this.playShootSound();
        this.getBallData().onSpawn();
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving, int type, int lvl) {
        this(world, entityliving, type, lvl, Elements.physic);
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving, int type, ItemStack item, int lvl) {
        this(world, entityliving, type, lvl);
        this.item = item;
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving, double x, double y, double z, int type, int lvl) {
        this(world, entityliving, x, y, z, type, lvl, 0.0f);
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving, double x, double y, double z, int type, int lvl, float accuracy) {
        this(world, entityliving, x, y, z, type, lvl, accuracy, 1.0f);
    }

    public EntityBaseBall(World world, EntityLivingBase entityliving, double x, double y, double z, int type, int lvl, float accuracy, float speed) {
        this(world, entityliving, type, lvl);
        this.func_70186_c(x, y, z, speed, accuracy);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)0);
        this.field_70180_af.func_75682_a(11, (Object)0);
        this.field_70180_af.func_75682_a(12, (Object)0);
    }

    public void playShootSound() {
        if (!this.field_70170_p.field_72995_K) {
            this.getBallData().onSpawn();
        }
    }

    public void setType(int par) {
        this.field_70180_af.func_75692_b(10, (Object)((byte)par));
    }

    public byte getType() {
        return this.field_70180_af.func_75683_a(10);
    }

    public void setlvl(int par) {
        this.field_70180_af.func_75692_b(11, (Object)((byte)par));
    }

    public byte getlvl() {
        return this.field_70180_af.func_75683_a(11);
    }

    public void setElement(Elements par) {
        this.field_70180_af.func_75692_b(12, (Object)((byte)par.ordinal()));
    }

    public Elements getElement() {
        return Elements.values()[this.field_70180_af.func_75683_a(12)];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public void func_70071_h_() {
        if (this.getBallData().longRange()) {
            this.field_70159_w *= 1.01;
            this.field_70181_x *= 1.01;
            this.field_70179_y *= 1.01;
        }
        if (this.func_85052_h() != null && this.func_85052_h().field_70128_L) {
            this.func_70106_y();
        } else {
            if (this.field_70195_i++ > this.getBallData().getMaxLifeTime()) {
                this.func_70106_y();
            }
            super.func_70071_h_();
            this.getBallData().onUpdateInAir();
        }
    }

    protected float func_70185_h() {
        return this.getBallData().getGravityVelocity();
    }

    protected void func_70184_a(MovingObjectPosition par1MovingObjectPosition) {
        this.getBallData().onImpact(par1MovingObjectPosition);
    }

    public double func_70042_X() {
        return -0.40000001192092893;
    }

    public double func_70033_W() {
        return this.ballData.getYOffset();
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74774_a("Type", this.getType());
        par1NBTTagCompound.func_74774_a("lvl", this.getlvl());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.setType(par1NBTTagCompound.func_74771_c("Type"));
        this.setlvl(par1NBTTagCompound.func_74771_c("lvl"));
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        this.getBallData().attackFrom(source, damage);
        this.func_70018_K();
        if (source.func_76346_g() != null && this.getBallData().canBounce()) {
            Vec3 var3 = source.func_76346_g().func_70040_Z();
            if (var3 != null) {
                this.field_70159_w = var3.field_72450_a;
                this.field_70181_x = var3.field_72448_b;
                this.field_70179_y = var3.field_72449_c;
            }
            return true;
        }
        return false;
    }

    public Random getRNG() {
        return this.field_70146_Z;
    }

    public void func_70106_y() {
        this.getBallData().onDead();
        super.func_70106_y();
    }

    public void setDamageMultiplier(float damage) {
        this.damageMultiplier = damage;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public int getTextureIndex() {
        return this.getBallData().getTextureIndex();
    }

    public float getBallSize() {
        return this.getBallData().getSize();
    }

    public boolean renderAsArrow() {
        return this.getBallData().renderAsArrow();
    }

    public ProjectileBase getBallData() {
        if (this.ballData == null || this.ballData instanceof ProjectileDummy) {
            this.ballData = ProjectileBase.getBallData(this);
            this.func_70105_a(this.ballData.getSizeBB(), this.ballData.getSizeBB());
        }
        return this.ballData;
    }

    public void setBallData(ProjectileBase data) {
        this.ballData = data;
    }

    public void setInmuneToFire(boolean fire) {
        this.field_70178_ae = fire;
    }

    public EntityLivingBase func_85052_h() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.shootingEntity = (EntityLivingBase)entity;
        }
    }
}

