/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.ai.AIBossAttack;
import com.chocolate.chocolateQuest.entity.ai.AILavaSwim;
import com.chocolate.chocolateQuest.entity.boss.AttackKick;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import com.chocolate.chocolateQuest.entity.boss.EntitySlimePart;
import com.chocolate.chocolateQuest.packets.PacketEntityAnimation;
import com.chocolate.chocolateQuest.particles.EffectManager;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySlimeBoss
extends EntityBaseBoss {
    public AttackKick kickHelper = new AttackKick(this);
    public int slimePoolAttackTime;
    public int slimePoolChargeTime = 30;
    public int slimePoolAttackTimeMax = 100;
    final byte SLIMEPOOL = (byte)5;

    public EntitySlimeBoss(World par1World) {
        super(par1World);
        this.kickHelper.setSpeed(16 + (int)(this.size * 4.0f));
        this.projectileDefense = 30;
        this.physicDefense = 0;
        this.fireDefense = 20;
        this.blastDefense = -50;
        this.limitRotation = true;
        this.xpRatio = 1.5f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(25.0);
    }

    @Override
    protected void scaleAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 + (double)this.lvl * 0.012);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 + (double)this.lvl * 0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0 + (double)this.lvl * 125.0);
    }

    @Override
    public void addAITasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AILavaSwim(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIBossAttack(this, 1.0f, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    public float getMinSize() {
        return 1.4f;
    }

    @Override
    public float getSizeVariation() {
        return 0.5f;
    }

    @Override
    public void animationBoss(byte animType) {
        switch (animType) {
            case 5: {
                this.startPoolAttack();
            }
        }
        this.kickHelper.kick(animType);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if (this.slimePoolAttackTime > 0) {
                double width = (double)this.field_70130_N * 0.75;
                if (this.slimePoolAttackTime < this.slimePoolAttackTimeMax - this.slimePoolChargeTime) {
                    for (int i = 0; i < 3; ++i) {
                        EffectManager.spawnParticle(0, this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * width, this.field_70163_u + 0.3, this.field_70161_v + this.field_70146_Z.nextGaussian() * width, 0.2 + (double)(this.field_70146_Z.nextFloat() / 8.0f), 0.6 + (double)(this.field_70146_Z.nextFloat() / 4.0f), 0.2 + (double)(this.field_70146_Z.nextFloat() / 8.0f));
                    }
                }
                float desp = this.size / 2.0f;
                EffectManager.spawnParticle(1, this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)desp, this.field_70163_u + 0.2, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)desp, 0.2 + (double)(this.field_70146_Z.nextFloat() / 8.0f), 0.6 + (double)(this.field_70146_Z.nextFloat() / 4.0f), 0.2 + (double)(this.field_70146_Z.nextFloat() / 8.0f));
            } else {
                float desp = this.size / 2.0f;
                EffectManager.spawnParticle(2, this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)desp, this.field_70163_u + 0.2, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)desp, 0.2 + (double)(this.field_70146_Z.nextFloat() / 8.0f), 0.6 + (double)(this.field_70146_Z.nextFloat() / 4.0f), 0.2 + (double)(this.field_70146_Z.nextFloat() / 8.0f));
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() / 10.0f && this.field_70173_aa % 20 == 0) {
            List list = this.field_70170_p.func_72872_a(EntitySlimePart.class, this.field_70121_D.func_72314_b(16.0, 4.0, 16.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                this.func_70624_b((EntityLivingBase)entity1);
            }
        }
        if (!this.field_70128_L) {
            this.kickHelper.onUpdate();
            if (this.isAttacking()) {
                if (this.field_70122_E) {
                    this.setAttacking(false);
                } else {
                    this.damageNearby(1.0);
                }
            }
            if (this.slimePoolAttackTime > 0) {
                if (this.slimePoolAttackTime > 40 && this.slimePoolAttackTime % 30 == 0) {
                    this.field_70170_p.func_72908_a((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v), "chocolatequest:bubble_explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                }
                --this.slimePoolAttackTime;
                if (this.slimePoolAttackTime < this.slimePoolAttackTimeMax - this.slimePoolChargeTime) {
                    this.damagePool();
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean attackInProgress() {
        return this.kickHelper.isAttackInProgress() || this.slimePoolAttackTime > 0;
    }

    @Override
    public void func_70785_a(Entity entity, float f) {
        int angle;
        if (this.slimePoolAttackTime > 0) {
            return;
        }
        if (f > 64.0f * this.field_70130_N / 2.0f + this.field_70130_N * this.field_70130_N && this.field_70122_E && this.field_70146_Z.nextInt(10) == 0 && Math.abs(angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this, entity) - (double)this.field_70177_z))) < 2) {
            this.jumpToTarget(entity);
        }
        float width = this.field_70130_N + entity.field_70130_N;
        width *= width;
        if (entity.getClass() == EntitySlimePart.class) {
            if (f < width) {
                entity.func_70108_f((Entity)this);
                this.func_71038_i();
            }
            return;
        }
        if (this.field_70173_aa % 20 == 0 && !this.field_70170_p.field_72995_K) {
            boolean targetUp;
            boolean bl = targetUp = this.field_70163_u - entity.field_70163_u + (double)this.field_70131_O <= 0.0 && f < this.size * this.size * 2.0f;
            if ((this.field_70146_Z.nextInt(6) == 0 || targetUp) && f < width * 2.0f) {
                this.startPoolAttack();
                return;
            }
            if ((double)f < (double)width * 1.5) {
                this.kickHelper.attackTarget(entity);
            }
        }
        super.func_70785_a(entity, f);
    }

    public void startPoolAttack() {
        if (!this.field_70170_p.field_72995_K) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), 5);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet, 64);
        }
        if (this.slimePoolAttackTime == 0) {
            this.slimePoolAttackTime = this.slimePoolAttackTimeMax;
        }
    }

    public boolean jumpToTarget(Entity entity) {
        if (!this.isAttacking()) {
            float rotation = this.field_70177_z * 3.141592f / 180.0f;
            double vx = entity.field_70165_t - this.field_70165_t;
            double vy = entity.field_70163_u - this.field_70163_u;
            double vz = entity.field_70161_v - this.field_70161_v;
            this.field_70159_w = vx / 4.0;
            this.field_70181_x = vy / 5.0 + (double)(entity.field_70131_O / 6.0f);
            this.field_70179_y = vz / 4.0;
            this.setAttacking(true);
            return true;
        }
        return false;
    }

    public void damageNearby(double expand) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(expand, expand, expand));
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || this.func_70028_i(entity1) || entity1 == this.field_70153_n) continue;
            this.func_70652_k(entity1);
            this.setAttacking(false);
        }
    }

    public void damagePool() {
        double expand = (double)this.field_70130_N * 1.35;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(expand, expand, expand));
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!(entity1 instanceof EntityLivingBase) || !entity1.func_70067_L() || this.func_70028_i(entity1) || entity1 == this.field_70153_n) continue;
            this.attackEntityAsMob(entity1, 0.6f);
            this.setAttacking(false);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean flag = super.func_70097_a(par1DamageSource, par2);
        if (!this.field_70170_p.field_72995_K && flag && this.func_110143_aJ() > 0.0f && this.field_70737_aN != 0 && !par1DamageSource.field_76373_n.equals(DamageSource.field_76368_d)) {
            float damage = (float)((double)par2 * BDHelper.getDamageReductionForElement((EntityLivingBase)this, BDHelper.getElementFromDamageSource(par1DamageSource), false));
            EntitySlimePart part = new EntitySlimePart(this.field_70170_p, (EntityLivingBase)this, damage);
            part.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v);
            part.field_70159_w = this.field_70146_Z.nextGaussian() * 2.0;
            part.field_70179_y = this.field_70146_Z.nextGaussian() * 2.0;
            part.field_70181_x = 1.0;
            this.field_70170_p.func_72838_d((Entity)part);
        }
        return flag;
    }

    protected void func_70069_a(float par1) {
    }

    protected String func_70621_aR() {
        return "mob.slime.big";
    }

    protected String func_70673_aS() {
        return "mob.slime.big";
    }

    @Override
    protected int getDropMaterial() {
        return 3;
    }
}

