/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityPart
extends Entity
implements IEntityAdditionalSpawnData {
    EntityBaseBoss mainBody;
    int maxHealth = 100;
    public boolean staticPart = true;
    public float rotationYawOffset = 0.0f;
    public float distanceToMainBody = 0.0f;
    public float heightOffset = 0.0f;
    int partID = 0;
    int ownerID = 0;

    public EntityPart(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityPart(World world, EntityBaseBoss main, int partID, float rotationYawOffset, float distanceToMainBody) {
        this(world);
        this.rotationYawOffset = rotationYawOffset;
        this.distanceToMainBody = distanceToMainBody;
        this.partID = partID;
        this.mainBody = main;
        if (main != null) {
            this.func_70107_b(main.field_70165_t, main.field_70163_u, main.field_70161_v);
        }
    }

    public EntityPart(World world, EntityBaseBoss main, int partID, float rotationYawOffset, float distanceToMainBody, float heightOffset) {
        this(world, main, partID, rotationYawOffset, distanceToMainBody);
        this.heightOffset = heightOffset;
    }

    public void func_70105_a(float par1, float par2) {
        super.func_70105_a(par1, par2);
    }

    protected void func_70088_a() {
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70170_p.field_72995_K && this.mainBody != null) {
            ItemStack is;
            Entity e = par1DamageSource.func_76346_g();
            boolean ret = this.mainBody.attackFromPart(par1DamageSource, par2, this);
            if (ret && e instanceof EntityPlayer && (is = ((EntityPlayer)e).func_71045_bC()) != null) {
                is.func_77973_b().func_77644_a(is, (EntityLivingBase)this.mainBody, (EntityLivingBase)((EntityPlayer)e));
            }
            return ret;
        }
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.mainBody == null) {
                Entity e = this.field_70170_p.func_73045_a(this.ownerID);
                if (e instanceof EntityBaseBoss) {
                    this.setMainBody((EntityBaseBoss)e);
                } else {
                    this.func_70106_y();
                }
            } else if (this.mainBody.field_70128_L) {
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
        if (this.mainBody != null) {
            this.field_70159_w = this.mainBody.field_70159_w;
            this.field_70179_y = this.mainBody.field_70179_y;
            this.field_70181_x = this.mainBody.field_70181_x;
            if (this.staticPart) {
                double hx = -Math.sin(Math.toRadians(this.mainBody.field_70177_z + this.rotationYawOffset)) * (double)this.distanceToMainBody;
                double hz = Math.cos(Math.toRadians(this.mainBody.field_70177_z + this.rotationYawOffset)) * (double)this.distanceToMainBody;
                this.func_70080_a(this.mainBody.field_70165_t + hx + this.field_70159_w, this.mainBody.field_70163_u + (double)this.heightOffset + this.field_70181_x, this.mainBody.field_70161_v + hz + this.field_70179_y, this.mainBody.field_70177_z, this.mainBody.field_70125_A);
            }
            if (this.mainBody.field_70181_x > 0.0) {
                this.field_70163_u += 20.0;
            }
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void setMainBody(EntityBaseBoss body) {
        this.mainBody = body;
        this.mainBody.setPart(this, this.partID);
    }

    public EntityBaseBoss getMainBody() {
        return this.mainBody;
    }

    public boolean func_70028_i(Entity par1Entity) {
        return this == par1Entity || this.mainBody == par1Entity;
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound var1) {
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.readBoolean()) {
            return;
        }
        int id = additionalData.readInt();
        Entity e = this.field_70170_p.func_73045_a(id);
        this.distanceToMainBody = additionalData.readFloat();
        this.rotationYawOffset = additionalData.readFloat();
        this.heightOffset = additionalData.readFloat();
        this.staticPart = additionalData.readByte() == 1;
        this.partID = additionalData.readByte();
        if (e instanceof EntityBaseBoss) {
            this.setMainBody((EntityBaseBoss)e);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.mainBody == null);
        if (this.mainBody != null) {
            buffer.writeInt(this.mainBody.func_145782_y());
            buffer.writeFloat(this.distanceToMainBody);
            buffer.writeFloat(this.rotationYawOffset);
            buffer.writeFloat(this.heightOffset);
            buffer.writeByte(this.staticPart ? 1 : 0);
            buffer.writeByte(this.partID);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }
}

