/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import com.chocolate.chocolateQuest.packets.PacketEntityAnimation;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;

public class AttackKick {
    public int kickTime;
    public byte kickType;
    public int kickSpeed = 30;
    EntityBaseBoss owner;

    public AttackKick(EntityBaseBoss owner) {
        this.owner = owner;
    }

    public void setSpeed(int speed) {
        this.kickSpeed = speed;
    }

    public int getSpeed() {
        return this.kickSpeed;
    }

    public void onUpdate() {
        if (this.kickTime > 0) {
            --this.kickTime;
            if (this.kickTime == this.getSpeed() / 3) {
                this.doKickDamage(this.kickType);
            }
        }
    }

    public void attackTarget(Entity entity) {
        int angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this.owner, entity) - (double)this.owner.field_70177_z));
        byte type = 0;
        type = angle > 0 ? (angle < 90 ? (byte)3 : 4) : (angle > -90 ? (byte)1 : 2);
        this.kick(type);
    }

    public void kick(byte type) {
        if (!this.owner.field_70170_p.field_72995_K) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.owner.func_145782_y(), type);
            ChocolateQuest.channel.sendToAllAround((Entity)this.owner, packet, 64);
        }
        if (this.kickTime == 0) {
            this.kickTime = this.getSpeed();
            this.kickType = type;
        }
    }

    public void doKickDamage(byte kickType) {
        double d = Math.max(2.5, (double)this.owner.field_70130_N * 0.8);
        List list = this.owner.field_70170_p.func_72839_b((Entity)this.owner, this.owner.field_70121_D.func_72314_b(d, 0.0, d).func_72321_a(0.0, -2.0, 0.0));
        int min = -180;
        int max = 180;
        switch (kickType) {
            case 3: {
                min = -5;
                max = 70;
                break;
            }
            case 4: {
                min = 70;
                max = 180;
                break;
            }
            case 1: {
                min = -70;
                max = 5;
                break;
            }
            case 2: {
                min = -180;
                max = -70;
            }
        }
        for (int j = 0; j < list.size(); ++j) {
            int angle;
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || this.owner.func_70028_i(entity1) || entity1 == this.owner.field_70153_n || (angle = (int)MathHelper.func_76138_g((double)(this.getAngleBetweenEntities((Entity)this.owner, entity1, kickType) - (double)this.owner.field_70177_z))) < min || angle > max || !this.owner.func_70652_k(entity1)) continue;
            float rotation = this.owner.field_70177_z;
            if (kickType == 2 || kickType == 4) {
                rotation -= 180.0f;
            }
            rotation = rotation * 3.141592f / 180.0f;
            float dist = Math.max(1.5f, this.owner.field_70130_N / 3.0f);
            double dx = -Math.sin(rotation) * (double)dist;
            double dy = this.owner.size / 20.0f;
            double dz = Math.cos(rotation) * (double)dist;
            entity1.field_70159_w += dx;
            entity1.field_70181_x += dy;
            entity1.field_70179_y += dz;
        }
    }

    public double getAngleBetweenEntities(Entity entity, Entity target, byte kickType) {
        double d = entity.field_70165_t - target.field_70165_t;
        double d2 = entity.field_70161_v - target.field_70161_v;
        double angle = Math.atan2(d, d2);
        angle = angle * 180.0 / 3.141592;
        angle = -MathHelper.func_76138_g((double)(angle - 180.0));
        return angle;
    }

    public boolean isAttackInProgress() {
        return this.kickTime > 0;
    }
}

