/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder.support;

import com.chocolate.chocolateQuest.API.BuilderBlockData;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.builder.Perlin3D;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class PlateauBuilder {
    BuilderBlockData structureBlock = new BuilderBlockData(Blocks.field_150346_d);
    BuilderBlockData structureTopBlock = new BuilderBlockData((Block)Blocks.field_150349_c);
    public int wallSize = 8;

    public void load(Properties prop) {
        this.structureBlock = HelperReadConfig.getBlock(prop, "structureBlock", new BuilderBlockData(Blocks.field_150346_d));
        this.structureTopBlock = HelperReadConfig.getBlock(prop, "structureTopBlock", new BuilderBlockData((Block)Blocks.field_150349_c));
    }

    public void generate(Random random, World world, int i, int j, int k, int sizeX, int sizeZ) {
        Perlin3D p = new Perlin3D(world.func_72905_C(), 8, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int wallSize = 8;
        sizeX += wallSize * 2;
        sizeZ += wallSize * 2;
        int height = 32;
        i -= wallSize;
        k -= wallSize;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int maxHeight = j - 1 - world.func_72825_h(x + i, z + k);
                int posY = world.func_72825_h(x + i, z + k);
                for (int y = 0; y <= maxHeight; ++y) {
                    if (x > wallSize && z > wallSize && x < sizeX - wallSize && z < sizeZ - wallSize) {
                        this.structureBlock.placeBlock(world, i + x, posY + y, k + z, random);
                        continue;
                    }
                    float noiseVar = (float)(y - maxHeight) / ((float)Math.max(1, maxHeight) * 1.5f);
                    int tWallSize = wallSize;
                    noiseVar += Math.max(0.0f, (float)(tWallSize - x) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (sizeX - x)) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - z) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (sizeZ - z)) / 8.0f);
                    double value = (p.getNoiseAt(x + i, y, z + k) + p2.getNoiseAt(x + i, y, z + k) + (double)noiseVar) / 3.0;
                    if (!(value < 0.5)) continue;
                    this.structureBlock.placeBlock(world, i + x, posY + y, k + z, random);
                }
                maxHeight = world.func_72825_h(x + i, z + k);
                if (maxHeight > j) continue;
                this.structureTopBlock.placeBlock(world, i + x, maxHeight - 1, k + z, random);
            }
        }
    }

    public Schematic getSchematic(Random random, World world, int i, int j, int k, int sizeX, int sizeZ) {
        int wallSize = 8;
        sizeX += wallSize * 2;
        sizeZ += wallSize * 2;
        i -= wallSize;
        k -= wallSize;
        int schematicHeight = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int maxHeight = j - world.func_72825_h(x + i, z + k);
                if (maxHeight <= schematicHeight) continue;
                schematicHeight = maxHeight;
            }
        }
        schematicHeight = Math.max(1, schematicHeight);
        Schematic schematic = new Schematic(sizeX, schematicHeight, sizeZ, ChocolateQuest.emptyBlock);
        Perlin3D p = new Perlin3D(world.func_72905_C(), 8, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int maxHeight = j - world.func_72825_h(x + i, z + k);
                int maxY = 0;
                for (int y = schematicHeight - maxHeight; y < schematicHeight; ++y) {
                    if (x > wallSize && z > wallSize && x < sizeX - wallSize && z < sizeZ - wallSize) {
                        this.structureBlock.placeBlock(schematic, x, y, z, random);
                        maxY = y;
                        continue;
                    }
                    float noiseVar = (float)(y - maxHeight) / ((float)Math.max(1, maxHeight) * 1.5f);
                    int tWallSize = wallSize;
                    noiseVar += Math.max(0.0f, (float)(tWallSize - x) / (float)wallSize);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (sizeX - x)) / (float)wallSize);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - z) / (float)wallSize);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (sizeZ - z)) / (float)wallSize);
                    double value = (p.getNoiseAt(x + i, y, z + k) + p2.getNoiseAt(x + i, y, z + k) + (double)noiseVar) / 3.0 + (double)((float)y / (float)schematicHeight) * 0.25;
                    if (!(value < 0.5)) continue;
                    this.structureBlock.placeBlock(schematic, x, y, z, random);
                    maxY = y;
                }
                if (maxHeight > j) continue;
                this.structureTopBlock.placeBlock(schematic, x, maxY, z, random);
            }
        }
        schematic.setPosition(i, j - schematicHeight, k);
        return schematic;
    }
}

