/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder.decorator;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DecoratorDoor {
    public static final int WEST = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int NORTH = 3;
    public int width = 2;
    public int height = 3;
    int type = 0;
    final Block BLOCK_FRAME = Blocks.field_150336_V;

    public DecoratorDoor(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setRandomType(Random random) {
        this.type = random.nextInt(4);
    }

    public void generate(Random random, World world, int x, int y, int z, ForgeDirection side) {
        if (this.width == 1) {
            this.generateSquared(random, world, x, y, z, side);
            return;
        }
        switch (this.type) {
            case 0: {
                this.generateSquared(random, world, x, y, z, side);
                break;
            }
            case 1: {
                this.generateArch(random, world, x, y, z, side);
                break;
            }
            case 2: {
                this.generateTriangle(random, world, x, y, z, side);
                break;
            }
            case 3: {
                this.generateFramed(random, world, x, y, z, side);
                break;
            }
            default: {
                this.generateSquared(random, world, x, y, z, side);
            }
        }
    }

    public void generateArch(Random random, World world, int x, int y, int z, ForgeDirection side) {
        int width = this.width / 2;
        int uwidth = width - 1 + this.width % 2;
        int archHeight = Math.max(1, this.height - width);
        for (int k = -width; k <= uwidth; ++k) {
            for (int e = -1; e <= 1; ++e) {
                if (k < 0 && k % 2 != 0) {
                    ++archHeight;
                }
                for (int j = 0; j <= this.height; ++j) {
                    int xPos = 0;
                    int zPos = 0;
                    if (side == ForgeDirection.WEST || side == ForgeDirection.EAST) {
                        xPos = x + e;
                        zPos = z + k;
                    } else {
                        xPos = x + k;
                        zPos = z + e;
                    }
                    if (j > archHeight) continue;
                    this.setBlockToAir(world, xPos, y + j, zPos);
                }
                if (k <= 0 || k % 2 == 0) continue;
                --archHeight;
            }
        }
    }

    public void generateTriangle(Random random, World world, int x, int y, int z, ForgeDirection side) {
        int width = this.width / 2;
        int uwidth = width + this.width % 2;
        int archHeight = Math.max(1, this.height - width);
        for (int e = -1; e <= 1; ++e) {
            for (int k = -width; k <= uwidth; ++k) {
                for (int j = 0; j <= this.height; ++j) {
                    int xPos = 0;
                    int zPos = 0;
                    if (side == ForgeDirection.WEST || side == ForgeDirection.EAST) {
                        xPos = x + e;
                        zPos = z + k;
                    } else {
                        xPos = x + k;
                        zPos = z + e;
                    }
                    if (j > archHeight) continue;
                    this.setBlockToAir(world, xPos, y + j, zPos);
                }
                if (k < 0) {
                    ++archHeight;
                    continue;
                }
                --archHeight;
            }
        }
    }

    public void generateSquared(Random random, World world, int x, int y, int z, ForgeDirection side) {
        int width = this.width / 2;
        int uwidth = width - 1 + this.width % 2;
        for (int e = -1; e <= 1; ++e) {
            for (int k = -width; k <= uwidth; ++k) {
                for (int j = 0; j <= this.height; ++j) {
                    int xPos = 0;
                    int zPos = 0;
                    if (side == ForgeDirection.WEST || side == ForgeDirection.EAST) {
                        xPos = x + e;
                        zPos = z + k;
                    } else {
                        xPos = x + k;
                        zPos = z + e;
                    }
                    this.setBlockToAir(world, xPos, y + j, zPos);
                }
            }
        }
        if (this.width == 1) {
            int doorSide = 0;
            if (side == ForgeDirection.SOUTH) {
                doorSide = 1;
            } else if (side == ForgeDirection.EAST) {
                doorSide = 2;
            } else if (side == ForgeDirection.NORTH) {
                doorSide = 3;
            }
            int orientation = doorSide - 1;
            boolean open = false;
            if (open) {
                world.func_147465_d(x, y, z, Blocks.field_150466_ao, orientation, 2);
                world.func_147465_d(x, y + 1, z, Blocks.field_150466_ao, orientation ^ 8, 2);
            } else {
                world.func_147465_d(x, y, z, Blocks.field_150466_ao, orientation ^ 4, 2);
                world.func_147465_d(x, y + 1, z, Blocks.field_150466_ao, orientation ^ 4 ^ 8, 2);
            }
        }
    }

    public void generateFramed(Random random, World world, int x, int y, int z, ForgeDirection side) {
        int width = this.width / 2;
        int uwidth = width + this.width % 2;
        for (int e = -1; e <= 1; ++e) {
            for (int k = -width - 1; k <= uwidth + 1; ++k) {
                for (int j = 0; j <= this.height; ++j) {
                    int xPos = 0;
                    int zPos = 0;
                    if (side == ForgeDirection.WEST || side == ForgeDirection.EAST) {
                        xPos = x + e;
                        zPos = z + k;
                    } else {
                        xPos = x + k;
                        zPos = z + e;
                    }
                    if (j == this.height || k < -width || k > width) {
                        if (e != 0) continue;
                        world.func_147449_b(xPos, y + j, zPos, this.BLOCK_FRAME);
                        continue;
                    }
                    this.setBlockToAir(world, xPos, y + j, zPos);
                }
            }
        }
    }

    private void setBlockToAir(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }
}

