/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.npc.EntityGolemMechaHeavy;
import com.chocolate.chocolateQuest.gui.guiParty.PartyManager;
import com.chocolate.chocolateQuest.items.ItemArmorBase;
import com.chocolate.chocolateQuest.items.ItemMedal;
import com.chocolate.chocolateQuest.items.ItemStaffHeal;
import com.chocolate.chocolateQuest.items.gun.ItemMusket;
import com.chocolate.chocolateQuest.items.swords.ItemCQBlade;
import com.chocolate.chocolateQuest.items.swords.ItemSwordAndShieldBase;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.misc.PotionCQ;
import com.chocolate.chocolateQuest.packets.PacketShieldBlockFromServer;
import com.chocolate.chocolateQuest.packets.PacketSpawnParticlesAround;
import com.chocolate.chocolateQuest.quest.worldManager.ReputationManager;
import com.chocolate.chocolateQuest.quest.worldManager.TerrainManager;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.chocolate.chocolateQuest.utils.PlayerManager;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandlerCQ {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            PlayerManager.addStamina(player, 0.075f);
            if (player.field_70170_p.field_72995_K) {
                BuilderHelper.builderHelper.resetStructureGenerationAmmount();
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        ItemStack is = event.entityLiving.func_71124_b(1);
        if (is != null) {
            EntityLivingBase entity;
            if (is.func_77973_b() == ChocolateQuest.cloudBoots && !(entity = event.entityLiving).func_70093_af()) {
                entity.field_70181_x += 0.4;
            }
            if (is.func_77973_b() == ChocolateQuest.spiderBoots && !(entity = event.entityLiving).func_70093_af()) {
                entity.field_70181_x += 0.2;
            }
            if (is.func_77973_b() == ChocolateQuest.slimeBoots && !(entity = event.entityLiving).func_70093_af()) {
                entity.field_70181_x += 0.1;
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Entity hitEntity = event.entity;
        Entity sourceEntity = event.source.func_76346_g();
        if (hitEntity instanceof EntityLivingBase) {
            ItemStack is;
            EntityPlayer ep;
            ItemStack weapon;
            if (hitEntity.field_70154_o != null && hitEntity.field_70154_o instanceof EntityGolemMechaHeavy) {
                hitEntity.field_70154_o.func_70097_a(event.source, event.ammount);
                event.setCanceled(true);
                return;
            }
            if (sourceEntity instanceof EntityLivingBase && !event.source.func_76352_a() && (weapon = ((EntityLivingBase)sourceEntity).func_71124_b(0)) != null && (weapon.func_77973_b() instanceof ItemCQBlade || weapon.func_77973_b() instanceof ItemMusket)) {
                ItemStaffHeal.applyPotionEffects(weapon, (EntityLivingBase)hitEntity);
                if (Elements.hasElements(weapon)) {
                    for (Elements element : Elements.values()) {
                        float damage = Elements.getElementDamage(weapon, element);
                        if (!(damage > 0.0f)) continue;
                        damage = element.onHitEntity(sourceEntity, hitEntity, damage);
                        damage = (float)((double)damage * BDHelper.getDamageReductionForElement((EntityLivingBase)hitEntity, element, true));
                        event.ammount += damage;
                        byte particle = PacketSpawnParticlesAround.getParticleFromName(element.getParticle());
                        PacketSpawnParticlesAround packet = new PacketSpawnParticlesAround(particle, hitEntity.field_70165_t, hitEntity.field_70163_u + 1.0, hitEntity.field_70161_v);
                        ChocolateQuest.channel.sendToAllAround(hitEntity, packet, 64);
                    }
                }
            }
            if (hitEntity instanceof EntityPlayer && (ep = (EntityPlayer)hitEntity).func_70632_aY() && !event.source.func_76363_c() && (is = ep.func_71045_bC()) != null && is.func_77973_b() instanceof ItemSwordAndShieldBase) {
                int resistLevel = Awakements.getEnchantLevel(is, Awakements.blockStamina) + 1;
                float ammount = event.ammount / (float)resistLevel * 1.5f;
                if (sourceEntity != null) {
                    if (sourceEntity instanceof EntityLivingBase) {
                        ((ItemSwordAndShieldBase)is.func_77973_b()).onBlock((EntityLivingBase)ep, (EntityLivingBase)sourceEntity, event.source);
                    }
                    if (PlayerManager.useStamina(ep, ammount)) {
                        PacketShieldBlockFromServer packet = new PacketShieldBlockFromServer(ep.func_145782_y(), sourceEntity.func_145782_y(), ammount);
                        ChocolateQuest.channel.sendToPlayer(packet, (EntityPlayerMP)ep);
                        event.ammount = 0.0f;
                        event.setCanceled(true);
                    } else {
                        event.ammount /= (float)(2 + resistLevel);
                    }
                }
            }
            EntityLivingBase el = (EntityLivingBase)hitEntity;
            event.ammount = (float)((double)event.ammount * BDHelper.getDamageReductionForElement(el, BDHelper.getElementFromDamageSource(event.source), false));
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = el.func_71124_b(1 + i);
                if (armor == null || !(armor.func_77973_b() instanceof ItemArmorBase)) continue;
                ((ItemArmorBase)armor.func_77973_b()).onHit(event, armor, el);
            }
        }
        if (hitEntity instanceof EntityCreeper && sourceEntity instanceof EntityHumanBase) {
            hitEntity.func_70106_y();
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            EntityHumanBase human;
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                ReputationManager.instance.onEntityKilled(event.entityLiving, (EntityPlayer)event.source.func_76346_g());
            }
            if (event.source.func_76346_g() instanceof EntityHumanBase && (human = (EntityHumanBase)event.source.func_76346_g()).getOwner() instanceof EntityPlayer) {
                ReputationManager.instance.onEntityKilled(event.entityLiving, (EntityPlayer)human.getOwner());
            }
            if (event.entity.getEntityData().func_74764_b("items")) {
                ItemStack[] items = ItemMedal.getEntityInventory(event.entity);
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] == null) continue;
                    event.entity.func_70099_a(items[i], 0.5f);
                }
            }
        }
    }

    @SubscribeEvent
    public void PlayerInteractEvent(PlayerInteractEvent event) {
        PlayerInteractEvent.Action cfr_ignored_0 = event.action;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            ItemStack is;
            Block block = event.world.func_147439_a(event.x, event.y, event.z);
            if (block.func_149744_f() || block == Blocks.field_150466_ao) {
                if (!event.entity.field_70170_p.field_72995_K) {
                    this.alertNearbyEntities(event.world, event.x, event.y, event.z, 10, 200);
                }
            } else if (!event.entityPlayer.field_71075_bZ.field_75098_d && event.entityPlayer.func_70644_a(PotionCQ.minePrevention) && (is = event.entityPlayer.func_71045_bC()) != null && is.func_77973_b() instanceof ItemBlock && ((ItemBlock)is.func_77973_b()).field_150939_a != Blocks.field_150478_aa) {
                event.setCanceled(true);
            }
        } else {
            PlayerInteractEvent.Action cfr_ignored_1 = event.action;
            if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && !this.canBreakBlock(event.entityPlayer, event.x, event.y, event.z)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!this.canBreakBlock(event.getPlayer(), event.x, event.y, event.z)) {
            event.setCanceled(true);
            return;
        }
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            this.alertNearbyEntities(event.world, event.x, event.y, event.z, 15, 100);
        }
    }

    public boolean canBreakBlock(EntityPlayer player, int x, int y, int z) {
        Block block;
        return player.field_71075_bZ.field_75098_d || !player.func_70644_a(PotionCQ.minePrevention) || (block = player.field_70170_p.func_147439_a(x, y, z)) == Blocks.field_150478_aa || block == Blocks.field_150474_ac || block instanceof BlockFalling;
    }

    public void alertNearbyEntities(World world, int x, int y, int z, int expansion, int alarmTime) {
        List list = world.func_72872_a(EntityHumanBase.class, AxisAlignedBB.func_72330_a((double)(x - expansion), (double)(y - expansion), (double)(z - expansion), (double)(x + expansion), (double)(y + expansion), (double)(z + expansion)));
        for (EntityHumanBase e : list) {
            e.alert(alarmTime);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (event.left != null && event.right != null && (event.left.func_77973_b() instanceof ItemCQBlade || event.left.func_77973_b() instanceof ItemArmorBase || event.left.func_77973_b() instanceof ItemMusket && ChocolateQuest.musket.getBayonet(event.left) > 0) && event.right.func_77973_b() == ChocolateQuest.elementStone) {
            event.output = ItemStack.func_77944_b((ItemStack)event.left);
            Elements element = ChocolateQuest.elementStone.getElement(event.right);
            int actualValue = Elements.getElementValue(event.left, element);
            int cost = 50;
            int costPerLevel = 10;
            if (event.left.func_77973_b() instanceof ItemArmorBase) {
                cost = 25;
                costPerLevel = 5;
            }
            if (actualValue < ChocolateQuest.elementStone.getMaxLevel(event.right)) {
                Elements.setElementValue(event.output, element, actualValue + 1);
                event.cost = cost + actualValue * 10;
            }
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            ReputationManager.instance = new ReputationManager();
            ReputationManager.instance.read(event.world, "/data/chocolateQuest/chocolateQuest.dat");
            TerrainManager.instance = new TerrainManager(ChocolateQuest.config.dungeonSeparation);
            TerrainManager.instance.read(event.world, "/data/chocolateQuest/terrain.dat");
        } else {
            PartyManager.instance.restart();
        }
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K) {
            if (ReputationManager.instance != null) {
                ReputationManager.instance.save(event.world, "/data/chocolateQuest", "chocolateQuest.dat");
            }
            if (TerrainManager.instance != null) {
                TerrainManager.instance.save(event.world, "/data/chocolateQuest", "terrain.dat");
            }
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        PlayerManager.reset();
    }
}

