/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.QuestDatabase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class NetQuestAction {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:quest_action");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetQuestAction::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestClaim(@Nonnull int[] questIDs) {
        if (questIDs.length <= 0) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 0);
        payload.func_74783_a("questIDs", questIDs);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestDetect(@Nonnull int[] questIDs) {
        if (questIDs.length <= 0) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 1);
        payload.func_74783_a("questIDs", questIDs);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        int action = !message.func_76341_a().func_150297_b("action", 99) ? -1 : message.func_76341_a().func_74762_e("action");
        switch (action) {
            case 0: {
                NetQuestAction.claimQuest(message.func_76341_a().func_74759_k("questIDs"), message.func_76340_b());
                break;
            }
            case 1: {
                NetQuestAction.detectQuest(message.func_76341_a().func_74759_k("questIDs"), message.func_76340_b());
                break;
            }
            default: {
                BetterQuesting.logger.log(Level.ERROR, "Invalid quest user action '" + action + "'. Full payload:\n" + message.func_76341_a().toString());
            }
        }
    }

    public static void claimQuest(int[] questIDs, EntityPlayerMP player) {
        List qLists = QuestDatabase.INSTANCE.bulkLookup(questIDs);
        for (DBEntry entry : qLists) {
            if (!((IQuest)entry.getValue()).canClaim((EntityPlayer)player)) continue;
            ((IQuest)entry.getValue()).claimReward((EntityPlayer)player);
        }
    }

    public static void detectQuest(int[] questIDs, EntityPlayerMP player) {
        List qLists = QuestDatabase.INSTANCE.bulkLookup(questIDs);
        for (DBEntry entry : qLists) {
            ((IQuest)entry.getValue()).detect((EntityPlayer)player);
        }
    }
}

