/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.questing.QuestLineDatabase;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class NetChapterEdit {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:chapter_edit");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetChapterEdit::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetChapterEdit::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendEdit(NBTTagCompound payload) {
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        MinecraftServer server = sender.field_71133_b;
        if (server == null) {
            return;
        }
        boolean isOP = server.func_71203_ab().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit chapters without OP permissions!");
            sender.func_146105_b((IChatComponent)new ChatComponentText(ChatFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        NBTTagCompound tag = message.func_76341_a();
        int action = !message.func_76341_a().func_150297_b("action", 99) ? -1 : message.func_76341_a().func_74762_e("action");
        switch (action) {
            case 0: {
                NetChapterEdit.editChapters(tag.func_150295_c("data", 10));
                break;
            }
            case 1: {
                NetChapterEdit.deleteChapters(tag.func_74759_k("chapterIDs"));
                break;
            }
            case 2: {
                NetChapterEdit.reorderChapters(tag.func_74759_k("chapterIDs"));
                break;
            }
            case 3: {
                NetChapterEdit.createChapters(tag.func_150295_c("data", 10));
                break;
            }
            default: {
                BetterQuesting.logger.log(Level.ERROR, "Invalid chapter edit action '" + action + "'. Full payload:\n" + message.func_76341_a().toString());
            }
        }
    }

    private static void editChapters(NBTTagList data) {
        int[] ids = new int[data.func_74745_c()];
        for (int i = 0; i < data.func_74745_c(); ++i) {
            int chapterID;
            NBTTagCompound entry = data.func_150305_b(i);
            ids[i] = chapterID = entry.func_74762_e("chapterID");
            IQuestLine chapter = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(chapterID);
            if (chapter == null) continue;
            chapter.readFromNBT(entry.func_74775_l("config"), false);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetChapterSync.sendSync(null, ids);
    }

    private static void deleteChapters(int[] chapterIDs) {
        for (int id : chapterIDs) {
            QuestLineDatabase.INSTANCE.removeID(id);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74783_a("chapterIDs", chapterIDs);
        payload.func_74768_a("action", 1);
        PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
    }

    private static void reorderChapters(int[] chapterIDs) {
        for (int n = 0; n < chapterIDs.length; ++n) {
            QuestLineDatabase.INSTANCE.setOrderIndex(chapterIDs[n], n);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74783_a("chapterIDs", chapterIDs);
        payload.func_74768_a("action", 2);
        PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
    }

    private static void createChapters(NBTTagList data) {
        int[] ids = new int[data.func_74745_c()];
        for (int i = 0; i < data.func_74745_c(); ++i) {
            int chapterID;
            NBTTagCompound entry = data.func_150305_b(i);
            int n = chapterID = entry.func_150297_b("chapterID", 99) ? entry.func_74762_e("chapterID") : -1;
            if (chapterID < 0) {
                chapterID = QuestLineDatabase.INSTANCE.nextID();
            }
            ids[i] = chapterID;
            IQuestLine chapter = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(chapterID);
            if (chapter == null) {
                chapter = QuestLineDatabase.INSTANCE.createNew(chapterID);
            }
            if (!entry.func_150297_b("config", 10)) continue;
            chapter.readFromNBT(entry.func_74775_l("config"), false);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetChapterSync.sendSync(null, ids);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        int action = !message.func_150297_b("action", 99) ? -1 : message.func_74762_e("action");
        switch (action) {
            case 1: {
                for (int id : message.func_74759_k("chapterIDs")) {
                    QuestLineDatabase.INSTANCE.removeID(id);
                }
                MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
                break;
            }
            case 2: {
                int[] chapterIDs = message.func_74759_k("chapterIDs");
                for (int n = 0; n < chapterIDs.length; ++n) {
                    QuestLineDatabase.INSTANCE.setOrderIndex(chapterIDs[n], n);
                }
                MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
                break;
            }
        }
    }
}

