/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.nbt;

import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterNumber;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelFluidSlot;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasFluidDatabase;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector4f;

public class GuiFluidSelection
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen {
    private final ICallback<FluidStack> callback;
    private FluidStack itemStack;
    private PanelTextField<Integer> fieldSize;
    private PanelFluidSlot itemPreview;

    public GuiFluidSelection(GuiScreen parent, NBTTagCompound tag, ICallback<FluidStack> callback) {
        this(parent, JsonHelper.JsonToFluidStack(tag), callback);
    }

    public GuiFluidSelection(GuiScreen parent, FluidStack stack, ICallback<FluidStack> callback) {
        super(parent);
        this.callback = callback;
        this.itemStack = stack;
    }

    @Override
    public void initPanel() {
        int x;
        int i;
        super.initPanel();
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.done", new Object[0])));
        PanelTextBox txTitle = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.select_fluid", new Object[0])).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(txTitle);
        CanvasEmpty cvRight = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 32), 0));
        cvBackground.addPanel(cvRight);
        CanvasFluidDatabase cvDatabase = new CanvasFluidDatabase(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0), 1);
        cvRight.addPanel(cvDatabase);
        PanelTextField<String> searchBox = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 8, -16), 0), "", FieldFilterString.INSTANCE);
        searchBox.setCallback(cvDatabase::setSearchFilter).setWatermark("Search...");
        cvRight.addPanel(searchBox);
        PanelVScrollBar scEdit = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        cvDatabase.setScrollDriverY(scEdit);
        cvRight.addPanel(scEdit);
        CanvasEmpty cvTopLeft = new CanvasEmpty(new GuiTransform(new Vector4f(0.0f, 0.0f, 0.5f, 0.4f), new GuiPadding(16, 32, 8, 8), 0));
        cvBackground.addPanel(cvTopLeft);
        PanelTextBox txSelection = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.selection", new Object[0]));
        txSelection.setColor(PresetColor.TEXT_MAIN.getColor());
        cvTopLeft.addPanel(txSelection);
        this.itemPreview = new PanelFluidSlot((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 0, 16, 36, 36, 0), 99, this.itemStack);
        cvTopLeft.addPanel(this.itemPreview);
        PanelTextBox txMulti = new PanelTextBox(new GuiTransform(GuiAlign.TOP_LEFT, 36, 20, 16, 12, 0), "x").setAlignment(1);
        txMulti.setColor(PresetColor.TEXT_MAIN.getColor());
        cvTopLeft.addPanel(txMulti);
        this.fieldSize = new PanelTextField<Integer>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(52, 16, 0, -32), 0), this.itemStack == null ? "1" : "" + this.itemStack.amount, FieldFilterNumber.INT);
        cvTopLeft.addPanel(this.fieldSize);
        this.fieldSize.setCallback(value -> {
            if (this.itemStack != null) {
                this.itemStack.amount = value;
            }
        });
        CanvasEmpty cvBottomLeft = new CanvasEmpty(new GuiTransform(new Vector4f(0.0f, 0.4f, 0.5f, 1.0f), new GuiPadding(16, 8, 8, 32), 0));
        cvBackground.addPanel(cvBottomLeft);
        PanelTextBox txInvo = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate("container.inventory", new Object[0]));
        txInvo.setColor(PresetColor.TEXT_MAIN.getColor());
        cvBottomLeft.addPanel(txInvo);
        InventoryPlayer inventory = this.field_146297_k.field_71439_g.field_71071_by;
        float iScale = Math.min((float)cvBottomLeft.getTransform().getWidth() / 162.0f, (float)(cvBottomLeft.getTransform().getHeight() - 20) / 72.0f);
        int slotSize = (int)Math.floor(18.0f * iScale);
        for (i = 0; i < 27; ++i) {
            x = i % 9 * slotSize;
            int y = i / 9 * slotSize + 16;
            ItemStack tmp = inventory.func_70301_a(i + 9);
            BigItemStack invoStack = tmp == null ? null : new BigItemStack(tmp);
            cvBottomLeft.addPanel(new PanelItemSlot((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, x, y, slotSize, slotSize, 0), 2, invoStack, true));
        }
        for (i = 0; i < 9; ++i) {
            x = i % 9 * slotSize;
            ItemStack tmp = inventory.func_70301_a(i);
            BigItemStack invoStack = tmp == null ? null : new BigItemStack(tmp);
            cvBottomLeft.addPanel(new PanelItemSlot((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, x, 20 + 3 * slotSize, slotSize, slotSize, 0), 2, invoStack, true));
        }
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -32, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine0);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            if (this.callback != null) {
                this.callback.setValue(this.itemStack);
            }
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1 && btn instanceof PanelButtonStorage) {
            FluidStack fluid = (FluidStack)((PanelButtonStorage)btn).getStoredValue();
            if (fluid != null) {
                this.itemStack = fluid.copy();
                this.itemPreview.setStoredValue(this.itemStack);
                this.fieldSize.setText("" + this.itemStack.amount);
            }
        } else if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            FluidStack fluid;
            BigItemStack tmp = (BigItemStack)((PanelButtonStorage)btn).getStoredValue();
            FluidStack fluidStack = fluid = tmp == null ? null : FluidContainerRegistry.getFluidForFilledItem((ItemStack)tmp.getBaseStack());
            if (fluid != null) {
                this.itemStack = fluid.copy();
                this.itemPreview.setStoredValue(this.itemStack);
                this.fieldSize.setText("" + this.itemStack.amount);
            }
        }
    }
}

