/*
 * Decompiled with CFR 0.152.
 */
package squeek.asmhelper.me.superckl.biometweaker;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ObfHelper {
    private static Boolean obfuscated = null;

    public static void setObfuscated(boolean obfuscated) {
        ObfHelper.obfuscated = obfuscated;
    }

    public static boolean isObfuscated() {
        if (obfuscated == null) {
            try {
                byte[] bytes = ((LaunchClassLoader)ObfHelper.class.getClassLoader()).getClassBytes("net.minecraft.world.World");
                ObfHelper.setObfuscated(bytes == null);
            }
            catch (IOException e) {
                obfuscated = true;
            }
        }
        return obfuscated;
    }

    public static String toDeobfClassName(String obfClassName) {
        if (ObfHelper.isObfuscated()) {
            return ObfHelper.forceToDeobfClassName(obfClassName);
        }
        return obfClassName;
    }

    public static String forceToDeobfClassName(String obfClassName) {
        return FMLDeobfuscatingRemapper.INSTANCE.map(obfClassName.replace('.', '/')).replace('/', '.');
    }

    public static String toObfClassName(String deobfClassName) {
        if (ObfHelper.isObfuscated()) {
            return ObfHelper.forceToObfClassName(deobfClassName);
        }
        return deobfClassName;
    }

    public static String forceToObfClassName(String deobfClassName) {
        return FMLDeobfuscatingRemapper.INSTANCE.unmap(deobfClassName.replace('.', '/')).replace('/', '.');
    }

    public static String getInternalClassName(String className) {
        return ObfHelper.toObfClassName(className).replace('.', '/');
    }

    public static String getDescriptor(String className) {
        return "L" + ObfHelper.getInternalClassName(className) + ";";
    }

    public static String desc(String deobfDesc) {
        if (ObfHelper.isObfuscated()) {
            Matcher classNameMatcher = Pattern.compile("L([^;]+);").matcher(deobfDesc);
            StringBuffer obfDescBuffer = new StringBuffer(deobfDesc.length());
            while (classNameMatcher.find()) {
                classNameMatcher.appendReplacement(obfDescBuffer, ObfHelper.getDescriptor(classNameMatcher.group(1).replace('/', '.')));
            }
            classNameMatcher.appendTail(obfDescBuffer);
            return obfDescBuffer.toString();
        }
        return deobfDesc;
    }
}

