/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.util;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class VersionChecker {
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final AtomicBoolean needsUpdates = new AtomicBoolean(false);
    private final AtomicReference<String> newVersion = new AtomicReference<String>("");
    private final AtomicReference<String> updateURL = new AtomicReference<String>("");
    private final Set<UUID> notified = Sets.newHashSet();

    private VersionChecker() {
    }

    public static VersionChecker start(final String modID, final String modVersion, final String mcVersion) {
        final VersionChecker checker = new VersionChecker();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String[] split = modVersion.split("[.]");
                    int major = Integer.parseInt(split[0]);
                    int minor = Integer.parseInt(split[1]);
                    int build = Integer.parseInt(split[2]);
                    URL url = new URL(String.format("http://bot.notenoughmods.com/%s.json", mcVersion));
                    URLConnection conn = url.openConnection();
                    conn.addRequestProperty("User-Agent", modID.concat(" version check"));
                    conn.setDoOutput(true);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    try {
                        JsonArray array = (JsonArray)new JsonParser().parse(reader.readLine());
                        boolean found = false;
                        for (JsonElement element : array) {
                            JsonObject obj = (JsonObject)element;
                            if (!obj.get("modid").getAsString().equals(modID)) continue;
                            String nVersion = obj.get("version").getAsString();
                            String[] split2 = nVersion.split("[.]");
                            int major2 = Integer.parseInt(split2[0]);
                            int minor2 = Integer.parseInt(split2[1]);
                            int build2 = Integer.parseInt(split2[2]);
                            if (major2 < major || major2 == major && minor2 < minor || major2 == major && minor2 == minor && build2 <= build) break;
                            checker.needsUpdates.set(true);
                            checker.newVersion.set(nVersion);
                            checker.updateURL.set(obj.get("longurl").getAsString());
                            LogHelper.info(I18n.func_135052_a((String)"biometweaker.msg.update.text", (Object[])new Object[]{nVersion}));
                            found = true;
                            break;
                        }
                        if (!found) {
                            LogHelper.info("No update found.");
                        }
                        checker.done.set(true);
                    }
                    finally {
                        if (Collections.singletonList(reader).get(0) != null) {
                            reader.close();
                        }
                    }
                }
                catch (Exception e) {
                    checker.done.set(true);
                    checker.needsUpdates.set(false);
                    LogHelper.error("Failed to perform a version check!");
                    e.printStackTrace();
                }
            }
        }).start();
        return checker;
    }

    @SubscribeEvent(receiveCanceled=false)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player.field_70170_p.field_72995_K || !this.done.get() || !this.needsUpdates.get() || this.notified.contains(e.player.func_146103_bH().getId())) {
            return;
        }
        ChatComponentTranslation chat = new ChatComponentTranslation("biometweaker.msg.update.text", new Object[]{this.newVersion.get()});
        chat.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentTranslation("biometweaker.msg.linkopen.text", new Object[0]))).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.updateURL.get())));
        e.player.func_145747_a((IChatComponent)chat);
        this.notified.add(e.player.func_146103_bH().getId());
    }

    public AtomicBoolean getDone() {
        return this.done;
    }

    public AtomicBoolean getNeedsUpdates() {
        return this.needsUpdates;
    }

    public AtomicReference<String> getNewVersion() {
        return this.newVersion;
    }

    public AtomicReference<String> getUpdateURL() {
        return this.updateURL;
    }

    public Set<UUID> getNotified() {
        return this.notified;
    }
}

