/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.handler;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class EntityEventHandler {
    private static int globalPackSize = -1;
    private static TIntObjectMap<TObjectIntMap<String>> packSizes = new TIntObjectHashMap();
    private static TIntObjectMap<List<Block>> noBonemeals = new TIntObjectHashMap();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGetMaxPackSize(LivingPackSizeEvent e) {
        int size;
        TObjectIntMap sizes;
        if (globalPackSize > -1) {
            e.setResult(Event.Result.ALLOW);
            e.maxPackSize = globalPackSize;
            return;
        }
        if (packSizes.isEmpty()) {
            return;
        }
        BiomeGenBase biome = e.entityLiving.field_70170_p.func_72807_a((int)e.entityLiving.field_70165_t, (int)e.entityLiving.field_70161_v);
        String clazz = e.entityLiving.getClass().getName();
        if (packSizes.containsKey(biome.field_76756_M) && (sizes = (TObjectIntMap)packSizes.get(biome.field_76756_M)).containsKey((Object)clazz) && (size = sizes.get((Object)clazz)) > -1) {
            e.setResult(Event.Result.ALLOW);
            e.maxPackSize = size;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBonemealUse(BonemealEvent e) {
        if (noBonemeals.isEmpty()) {
            return;
        }
        BiomeGenBase biome = e.world.func_72807_a(e.x, e.z);
        if (noBonemeals.containsKey(biome.field_76756_M)) {
            List list = (List)noBonemeals.get(biome.field_76756_M);
            if (list == null) {
                e.setCanceled(true);
                return;
            }
            for (Block block : list) {
                if (block != e.block) continue;
                e.setCanceled(true);
                break;
            }
        }
    }

    public static int getGlobalPackSize() {
        return globalPackSize;
    }

    public static void setGlobalPackSize(int globalPackSize) {
        EntityEventHandler.globalPackSize = globalPackSize;
    }

    public static TIntObjectMap<TObjectIntMap<String>> getPackSizes() {
        return packSizes;
    }

    public static TIntObjectMap<List<Block>> getNoBonemeals() {
        return noBonemeals;
    }
}

