/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.task;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.WorldBorder;
import com.wimbli.WorldBorder.WorldFileData;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldFillTask {
    private static WorldFillTask INSTANCE = null;
    private final WorldServer world;
    private final WorldFileData worldData;
    private final ChunkProviderServer provider;
    private final BorderData border;
    private final ICommandSender requester;
    private final List<CoordXZ> storedChunks = new LinkedList<CoordXZ>();
    private final Set<CoordXZ> originalChunks = new HashSet<CoordXZ>();
    private final CoordXZ lastChunk = new CoordXZ(0, 0);
    private int chunksPerRun = 1;
    private boolean readyToGo = false;
    private boolean paused = false;
    private boolean memoryPause = false;
    private boolean continueNotice = false;
    private boolean forceLoad = false;
    private int x = 0;
    private int z = 0;
    private boolean isZLeg = false;
    private boolean isNeg = false;
    private boolean inside = true;
    private int length = -1;
    private int current = 0;
    private long lastReport = Util.now();
    private long lastAutosave = Util.now();
    private int reportTarget = 0;
    private int reportTotal = 0;
    private int reportNum = 0;
    private int fillDistance = 208;
    private int tickFrequency = 1;
    private int refLength = -1;
    private int refX = 0;
    private int lastLegX = 0;
    private int refZ = 0;
    private int lastLegZ = 0;
    private int refTotal = 0;
    private int lastLegTotal = 0;

    public static WorldFillTask getInstance() {
        return INSTANCE;
    }

    public static WorldFillTask create(ICommandSender requester, String worldName, boolean forceLoad, int fillDistance, int chunksPerRun, int tickFrequency) {
        if (INSTANCE != null) {
            throw new IllegalStateException("There can only be one WorldFillTask");
        }
        try {
            INSTANCE = new WorldFillTask(requester, worldName, forceLoad, fillDistance, chunksPerRun, tickFrequency);
            return INSTANCE;
        }
        catch (Exception e) {
            INSTANCE = null;
            throw e;
        }
    }

    public int getRefX() {
        return this.refX;
    }

    public int getRefZ() {
        return this.refZ;
    }

    public int getRefLength() {
        return this.refLength;
    }

    public int getRefTotal() {
        return this.refTotal;
    }

    public int getFillDistance() {
        return this.fillDistance;
    }

    public int getTickFrequency() {
        return this.tickFrequency;
    }

    public int getChunksPerRun() {
        return this.chunksPerRun;
    }

    public String getWorld() {
        return Worlds.getWorldName((World)this.world);
    }

    public boolean getForceLoad() {
        return this.forceLoad;
    }

    public void start() {
        if (INSTANCE != this) {
            throw new IllegalStateException("Cannot start a stopped task");
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void startFrom(int x, int z, int length, int totalDone) {
        this.x = x;
        this.z = z;
        this.length = length;
        this.reportTotal = totalDone;
        this.continueNotice = true;
        this.start();
    }

    public void stop() {
        if (INSTANCE != this) {
            throw new IllegalStateException("Task has already been stopped");
        }
        FMLCommonHandler.instance().bus().unregister((Object)this);
        while (!this.storedChunks.isEmpty()) {
            CoordXZ coord = this.storedChunks.remove(0);
            if (this.originalChunks.contains(coord)) continue;
            this.provider.func_73241_b(coord.x, coord.z);
        }
        this.originalChunks.clear();
        INSTANCE = null;
    }

    public void pause() {
        if (this.memoryPause) {
            this.pause(false);
        } else {
            this.pause(!this.paused);
        }
    }

    public void pause(boolean pause) {
        if (this.memoryPause && !pause) {
            this.memoryPause = false;
        } else {
            this.paused = pause;
        }
        if (this.paused) {
            Config.storeFillTask();
            this.reportProgress();
        } else {
            Config.deleteFillTask();
        }
    }

    public boolean isPaused() {
        return this.paused || this.memoryPause;
    }

    private WorldFillTask(ICommandSender requester, String worldName, boolean forceLoad, int fillDistance, int chunksPerRun, int tickFrequency) {
        this.requester = requester;
        this.fillDistance = fillDistance;
        this.tickFrequency = tickFrequency;
        this.chunksPerRun = chunksPerRun;
        this.forceLoad = forceLoad;
        this.world = Worlds.getWorld(worldName);
        if (this.world == null) {
            throw new IllegalArgumentException("World \"" + worldName + "\" not found!");
        }
        BorderData borderData = this.border = Config.Border(worldName) == null ? null : Config.Border(worldName).copy();
        if (this.border == null) {
            throw new IllegalStateException("No border found for world \"" + worldName + "\"!");
        }
        this.worldData = new WorldFileData((World)this.world, requester);
        this.border.setRadiusX(this.border.getRadiusX() + fillDistance);
        this.border.setRadiusZ(this.border.getRadiusZ() + fillDistance);
        this.x = CoordXZ.blockToChunk((int)this.border.getX());
        this.z = CoordXZ.blockToChunk((int)this.border.getZ());
        int chunkWidthX = (int)Math.ceil((double)((this.border.getRadiusX() + 16) * 2) / 16.0);
        int chunkWidthZ = (int)Math.ceil((double)((this.border.getRadiusZ() + 16) * 2) / 16.0);
        int biggerWidth = chunkWidthX > chunkWidthZ ? chunkWidthX : chunkWidthZ;
        this.reportTarget = biggerWidth * biggerWidth + biggerWidth + 1;
        this.provider = this.world.field_73059_b;
        List originals = this.provider.field_73245_g;
        for (Chunk original : originals) {
            this.originalChunks.add(new CoordXZ(original.field_76635_g, original.field_76647_h));
        }
        this.readyToGo = true;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (WorldBorder.SERVER.func_71259_af() % this.tickFrequency != 0) {
            return;
        }
        if (this.continueNotice) {
            this.continueNotice = false;
            this.sendMessage("World map generation task automatically continuing.");
            this.sendMessage("Reminder: you can cancel at any time with \"wb fill cancel\", or pause/unpause with \"wb fill pause\".");
        }
        if (this.memoryPause) {
            if (Config.isAvailableMemoryTooLow()) {
                return;
            }
            this.memoryPause = false;
            this.readyToGo = true;
            this.sendMessage("Available memory is sufficient, automatically continuing.");
        }
        if (!this.readyToGo || this.paused) {
            return;
        }
        this.readyToGo = false;
        long loopStartTime = Util.now();
        for (int loop = 0; loop < this.chunksPerRun; ++loop) {
            int popX;
            if (this.paused || this.memoryPause) {
                return;
            }
            long now = Util.now();
            if (now > this.lastReport + 5000L) {
                this.reportProgress();
            }
            if (now > loopStartTime + 45L) {
                this.readyToGo = true;
                return;
            }
            while (!this.border.insideBorder(CoordXZ.chunkToBlock(this.x) + 8, CoordXZ.chunkToBlock(this.z) + 8)) {
                if (this.moveToNext()) continue;
                return;
            }
            this.inside = true;
            if (!this.forceLoad) {
                while (this.worldData.isChunkFullyGenerated(this.x, this.z)) {
                    this.inside = true;
                    if (this.moveToNext()) continue;
                    return;
                }
            }
            this.provider.func_73158_c(this.x, this.z);
            this.worldData.chunkExistsNow(this.x, this.z);
            int n = !this.isZLeg ? this.x : (popX = this.x + (this.isNeg ? -1 : 1));
            int popZ = this.isZLeg ? this.z : this.z + (!this.isNeg ? -1 : 1);
            this.provider.func_73158_c(popX, popZ);
            if (!this.storedChunks.contains(this.lastChunk) && !this.originalChunks.contains(this.lastChunk)) {
                this.provider.func_73158_c(this.lastChunk.x, this.lastChunk.z);
                this.storedChunks.add(new CoordXZ(this.lastChunk.x, this.lastChunk.z));
            }
            this.storedChunks.add(new CoordXZ(popX, popZ));
            this.storedChunks.add(new CoordXZ(this.x, this.z));
            while (this.storedChunks.size() > 8) {
                CoordXZ coord = this.storedChunks.remove(0);
                if (this.originalChunks.contains(coord)) continue;
                this.provider.func_73241_b(coord.x, coord.z);
            }
            if (this.moveToNext()) continue;
            return;
        }
        this.readyToGo = true;
    }

    public boolean moveToNext() {
        if (this.paused || this.memoryPause) {
            return false;
        }
        ++this.reportNum;
        if (!this.isNeg && this.current == 0 && this.length > 3) {
            if (!this.isZLeg) {
                this.lastLegX = this.x;
                this.lastLegZ = this.z;
                this.lastLegTotal = this.reportTotal + this.reportNum;
            } else {
                this.refX = this.lastLegX;
                this.refZ = this.lastLegZ;
                this.refTotal = this.lastLegTotal;
                this.refLength = this.length - 1;
            }
        }
        if (this.current < this.length) {
            ++this.current;
        } else {
            this.current = 0;
            this.isZLeg ^= true;
            if (this.isZLeg) {
                this.isNeg ^= true;
                ++this.length;
            }
        }
        this.lastChunk.x = this.x;
        this.lastChunk.z = this.z;
        if (this.isZLeg) {
            this.z += this.isNeg ? -1 : 1;
        } else {
            this.x += this.isNeg ? -1 : 1;
        }
        if (this.isZLeg && this.isNeg && this.current == 0) {
            if (!this.inside) {
                this.finish();
                return false;
            }
            this.inside = false;
        }
        return true;
    }

    private void finish() {
        this.paused = true;
        this.reportProgress();
        Worlds.saveWorld(this.world);
        this.sendMessage("Task successfully completed for world \"" + this.getWorld() + "\"!");
        this.stop();
    }

    private void reportProgress() {
        this.lastReport = Util.now();
        double perc = (double)(this.reportTotal + this.reportNum) / (double)this.reportTarget * 100.0;
        if (perc > 100.0) {
            perc = 100.0;
        }
        this.sendMessage(this.reportNum + " more chunks processed (" + (this.reportTotal + this.reportNum) + " total, ~" + Config.COORD_FORMAT.format(perc) + "%%" + ")");
        this.reportTotal += this.reportNum;
        this.reportNum = 0;
        if (Config.getFillAutosaveFrequency() > 0 && this.lastAutosave + (long)(Config.getFillAutosaveFrequency() * 1000) < this.lastReport) {
            this.lastAutosave = this.lastReport;
            this.sendMessage("Saving the world to disk, just to be on the safe side.");
            Worlds.saveWorld(this.world);
        }
    }

    private void sendMessage(String text) {
        long availMem = Config.getAvailableMemory();
        Log.info("[Fill] " + text + " (free mem: " + availMem + " MB)", new Object[0]);
        if (this.requester instanceof EntityPlayerMP) {
            Util.chat(this.requester, "[Fill] " + text + " (free mem: " + availMem + " MB)", new Object[0]);
        }
        if (Config.isAvailableMemoryTooLow()) {
            this.memoryPause = true;
            Config.storeFillTask();
            text = "Available memory is very low, task is pausing. A cleanup will be attempted now, and the task will automatically continue if/when sufficient memory is freed up.\n Alternatively, if you restart the server, this task will automatically continue once the server is back up.";
            Log.info("[Fill] " + text, new Object[0]);
            if (this.requester instanceof EntityPlayerMP) {
                Util.chat(this.requester, "[Fill] " + text, new Object[0]);
            }
            System.gc();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Log.debug("WorldFillTask cleaned up for %s", this.getWorld());
    }
}

