/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import com.wimbli.WorldBorder.task.WorldFillTask;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdFill
extends WBCmd {
    private final int defaultPadding = CoordXZ.chunkToBlock(13);
    private String fillWorld = "";
    private int fillFrequency = 20;
    private int fillPadding = this.defaultPadding;
    private boolean fillForceLoad = false;

    public CmdFill() {
        this.permission = "fill";
        this.name = "fill";
        this.hasWorldNameInput = true;
        this.consoleRequiresWorldName = false;
        this.minParams = 0;
        this.maxParams = 3;
        this.addCmdExample(this.nameEmphasizedW() + "[freq] [pad] [force] - fill world to border.");
        this.helpText = "This command will generate missing world chunks inside your border. [freq] is the frequency of chunks per second that will be checked (default 20). [pad] is the number of blocks padding added beyond the border itself (default 208, to cover player visual range). [force] can be specified as true to force all chunks to be loaded even if they seem to be fully generated (default false).";
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        boolean confirm = false;
        if (params.size() >= 1) {
            String check = params.get(0).toLowerCase();
            if (check.equals("cancel") || check.equals("stop")) {
                if (!this.makeSureFillIsRunning(sender)) {
                    return;
                }
                Util.chat(sender, C_HEAD + "Cancelling the world map generation task.", new Object[0]);
                this.fillDefaults();
                WorldFillTask.getInstance().stop();
                return;
            }
            if (check.equals("pause")) {
                if (!this.makeSureFillIsRunning(sender)) {
                    return;
                }
                WorldFillTask.getInstance().pause();
                Util.chat(sender, C_HEAD + "The world map generation task is now " + (WorldFillTask.getInstance().isPaused() ? "" : "un") + "paused.", new Object[0]);
                return;
            }
            confirm = check.equals("confirm");
        }
        if (worldName == null && !confirm) {
            if (player != null) {
                worldName = Worlds.getWorldName(player.field_70170_p);
            } else {
                this.sendErrorAndHelp(sender, "You must specify a world!");
                return;
            }
        }
        String cmd = this.cmd(sender) + this.nameEmphasized() + C_CMD;
        if (WorldFillTask.getInstance() != null) {
            Util.chat(sender, C_ERR + "The world map generation task is already running.", new Object[0]);
            Util.chat(sender, C_DESC + "You can cancel at any time with " + cmd + "cancel" + C_DESC + ", or pause/unpause with " + cmd + "pause" + C_DESC + ".", new Object[0]);
            return;
        }
        try {
            if (params.size() >= 1 && !confirm) {
                this.fillFrequency = Math.abs(Integer.parseInt(params.get(0)));
            }
            if (params.size() >= 2 && !confirm) {
                this.fillPadding = Math.abs(Integer.parseInt(params.get(1)));
            }
        }
        catch (NumberFormatException ex) {
            this.sendErrorAndHelp(sender, "The frequency and padding values must be integers.");
            this.fillDefaults();
            return;
        }
        if (this.fillFrequency <= 0) {
            this.sendErrorAndHelp(sender, "The frequency value must be greater than zero.");
            this.fillDefaults();
            return;
        }
        if (params.size() == 3) {
            this.fillForceLoad = this.strAsBool(params.get(2));
        }
        if (worldName != null) {
            this.fillWorld = worldName;
        }
        if (confirm) {
            if (this.fillWorld.isEmpty()) {
                this.sendErrorAndHelp(sender, "You must first use this command successfully without confirming.");
                return;
            }
            if (player != null) {
                Log.info("Filling out world to border at the command of player \"" + player.getDisplayName() + "\".", new Object[0]);
            }
            int ticks = 1;
            int repeats = 1;
            if (this.fillFrequency > 20) {
                repeats = this.fillFrequency / 20;
            } else {
                ticks = 20 / this.fillFrequency;
            }
            Log.info("world: " + this.fillWorld + "  padding: " + this.fillPadding + "  repeats: " + repeats + "  ticks: " + ticks, new Object[0]);
            try {
                WorldFillTask task = WorldFillTask.create((ICommandSender)player, this.fillWorld, this.fillForceLoad, this.fillPadding, repeats, ticks);
                task.start();
                Util.chat(sender, "WorldBorder map generation task for world \"" + this.fillWorld + "\" started.", new Object[0]);
            }
            catch (Exception e) {
                Util.chat(sender, C_ERR + "The world map generation task failed to start:", new Object[0]);
                Util.chat(sender, C_ERR + e.getMessage(), new Object[0]);
            }
            this.fillDefaults();
        } else {
            if (this.fillWorld.isEmpty() || Worlds.getWorld(this.fillWorld) == null) {
                this.sendErrorAndHelp(sender, "You must first specify a valid world.");
                return;
            }
            if (Config.Border(this.fillWorld) == null) {
                this.sendErrorAndHelp(sender, "That world does not have a border.");
                return;
            }
            Util.chat(sender, C_HEAD + "World generation task is ready for world \"" + this.fillWorld + "\", attempting to process up to " + this.fillFrequency + " chunks per second (default 20). The map will be padded out " + this.fillPadding + " blocks beyond the border (default " + this.defaultPadding + "). Parts of the world which are already fully generated will be " + (this.fillForceLoad ? "loaded anyway." : "skipped."), new Object[0]);
            Util.chat(sender, C_HEAD + "This process can take a very long time depending on the world's border size. Also, depending on the chunk processing rate, players will likely experience severe lag for the duration.", new Object[0]);
            Util.chat(sender, C_DESC + "You should now use " + cmd + "confirm" + C_DESC + " to start the process.", new Object[0]);
            Util.chat(sender, C_DESC + "You can cancel at any time with " + cmd + "cancel" + C_DESC + ", or pause/unpause with " + cmd + "pause" + C_DESC + ".", new Object[0]);
        }
    }

    private void fillDefaults() {
        this.fillWorld = "";
        this.fillFrequency = 20;
        this.fillPadding = this.defaultPadding;
        this.fillForceLoad = false;
    }

    private boolean makeSureFillIsRunning(ICommandSender sender) {
        if (WorldFillTask.getInstance() != null) {
            return true;
        }
        this.sendErrorAndHelp(sender, "The world map generation task is not currently running.");
        return false;
    }
}

