/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.stats;

import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties._MobPropertiesMod;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobStatsInfo;

public class EntryStatsName
extends EntryAbstract {
    private final String name;
    public static final String[] ITEM_PREFIXES = new String[]{"Mighty", "Supreme", "Superior", "Ultimate", "Shoddy", "Flimsy", "Curious", "Secret", "Pathetic", "Crying", "Eagle's", "Errant", "Unholy", "Questionable", "Mean", "Hungry", "Thirsty", "Feeble", "Wise", "Sage's", "Magical", "Mythical", "Legendary", "Not Very Nice", "Jerk's", "Doctor's", "Misunderstood", "Angry", "Knight's", "Bishop's", "Godly", "Special", "Toasty", "Shiny", "Shimmering", "Light", "Dark", "Odd-Smelling", "Funky", "Slightly Overdone", "Half-Baked", "Cracked", "Sticky", "\u00a7kAlien", "Baby", "Manly", "Rough", "Scary", "Undoubtable", "Honest", "Non-Suspicious", "Boring", "Odd", "Lazy", "Super", "Nifty", "Ogre-Slaying"};
    public static final String[] ITEM_POSTFIXES = new String[]{"Mightiness", "Supremity", "Superiority", "Flimsiness", "Curiousity", "Secrets", "Patheticness", "Crying", "The Eagles", "Unholiness", "Questionable Integrity", "Meanness", "Hunger", "Thirst", "Wisdom", "The Sages", "Magic", "Myths", "Legends", "The Jerks", "The Doctor", "Misunderstanding", "Anger", "The Gods", "Toast", "Shininess", "Shimmering", "The Light", "Darkness", "Strange Odors", "Funk", "Slight Abnormality", "Baking", "Breaking", "Stickiness", "Babies", "Manliness", "Roughness", "Scary Stuff", "Doubt", "Honesty", "Nothing", "Boringness", "Oddness", "Laziness", "Super Something", "Nifty Things", "Ogre-Slaying"};
    public static final String[] NAMES = new String[]{"Albert", "Andrew", "Anderson", "Andy", "Allan", "Arthur", "Aaron", "Allison", "Arielle", "Amanda", "Anne", "Annie", "Amy", "Alana", "Brandon", "Brady", "Bernard", "Ben", "Benjamin", "Bob", "Bobette", "Brooke", "Brandy", "Beatrice", "Bea", "Bella", "Becky", "Carlton", "Carl", "Calvin", "Cameron", "Carson", "Chase", "Cassandra", "Cassie", "Cas", "Carol", "Carly", "Cherise", "Charlotte", "Cheryl", "Chasity", "Danny", "Drake", "Daniel", "Derrel", "David", "Dave", "Donovan", "Don", "Donald", "Drew", "Derrick", "Darla", "Donna", "Dora", "Danielle", "Edward", "Elliot", "Ed", "Edson", "Elton", "Eddison", "Earl", "Eric", "Ericson", "Eddie", "Ediovany", "Emma", "Elizabeth", "Eliza", "Esperanza", "Esper", "Esmeralda", "Emi", "Emily", "Elaine", "Fernando", "Ferdinand", "Fred", "Feddie", "Fredward", "Frank", "Franklin", "Felix", "Felicia", "Fran", "Greg", "Gregory", "George", "Gerald", "Gina", "Geraldine", "Gabby", "Hendrix", "Henry", "Hobbes", "Herbert", "Heath", "Henderson", "Helga", "Hera", "Helen", "Helena", "Hannah", "Ike", "Issac", "Israel", "Ismael", "Irlanda", "Isabelle", "Irene", "Irenia", "Jimmy", "Jim", "Justin", "Jacob", "Jake", "Jon", "Johnson", "Jonny", "Jonathan", "Josh", "Joshua", "Julian", "Jesus", "Jericho", "Jeb", "Jess", "Joan", "Jill", "Jillian", "Jessica", "Jennifer", "Jenny", "Jen", "Judy", "Kenneth", "Kenny", "Ken", "Keith", "Kevin", "Karen", "Kassandra", "Kassie", "Leonard", "Leo", "Leroy", "Lee", "Lenny", "Luke", "Lucas", "Liam", "Lorraine", "Latasha", "Lauren", "Laquisha", "Livia", "Lydia", "Lila", "Lilly", "Lillian", "Lilith", "Lana", "Mason", "Mike", "Mickey", "Mario", "Manny", "Mark", "Marcus", "Martin", "Marty", "Matthew", "Matt", "Max", "Maximillian", "Marth", "Mia", "Marriah", "Maddison", "Maddie", "Marissa", "Miranda", "Mary", "Martha", "Melonie", "Melody", "Mel", "Minnie", "Nathan", "Nathaniel", "Nate", "Ned", "Nick", "Norman", "Nicholas", "Natasha", "Nicki", "Nora", "Nelly", "Nina", "Orville", "Oliver", "Orlando", "Owen", "Olsen", "Odin", "Olaf", "Ortega", "Olivia", "Patrick", "Pat", "Paul", "Perry", "Pinnochio", "Patrice", "Patricia", "Pennie", "Petunia", "Patti", "Pernelle", "Quade", "Quincy", "Quentin", "Quinn", "Roberto", "Robbie", "Rob", "Robert", "Roy", "Roland", "Ronald", "Richard", "Rick", "Ricky", "Rose", "Rosa", "Rhonda", "Rebecca", "Roberta", "Sparky", "Shiloh", "Stephen", "Steve", "Saul", "Sheen", "Shane", "Sean", "Sampson", "Samuel", "Sammy", "Stefan", "Sasha", "Sam", "Susan", "Suzy", "Shelby", "Samantha", "Sheila", "Sharon", "Sally", "Stephanie", "Sandra", "Sandy", "Sage", "Tim", "Thomas", "Thompson", "Tyson", "Tyler", "Tom", "Tyrone", "Timmothy", "Tamara", "Tabby", "Tabitha", "Tessa", "Tiara", "Tyra", "Uriel", "Ursala", "Uma", "Victor", "Vincent", "Vince", "Vance", "Vinny", "Velma", "Victoria", "Veronica", "Wilson", "Wally", "Wallace", "Will", "Wilard", "William", "Wilhelm", "Xavier", "Xandra", "Young", "Yvonne", "Yolanda", "Zach", "Zachary"};
    public static final String[] NAME_PARTS = new String[]{"Grab", "Thar", "Ger", "Ald", "Mas", "On", "O", "Din", "Thor", "Jon", "Ath", "Burb", "En", "A", "E", "I", "U", "Hab", "Bloo", "Ena", "Dit", "Aph", "Ern", "Bor", "Dav", "Id", "Toast", "Son", "Dottir", "For", "Wen", "Lob", "Ed", "Die", "Van", "Y", "Zap", "Ear", "Ben", "Don", "Bran", "Gro", "Jen", "Bob", "Ette", "Ere", "Man", "Qua", "Bro", "Cree", "Per", "Skel", "Ton", "Zom", "Bie", "Wolf", "End", "Er", "Pig", "Sil", "Ver", "Fish", "Cow", "Chic", "Ken", "Sheep", "Squid", "Hell"};
    public static final String[] SALUTATIONS = new String[]{"Mr.", "Mister", "Sir", "Mrs.", "Miss", "Madam", "Dr.", "Doctor", "Lord", "Father", "Grandfather", "Mother", "Grandmother"};
    public static final String[] DESCRIPTORS = new String[]{"Mighty", "Supreme", "Superior", "Ultimate", "Lame", "Wimpy", "Curious", "Sneaky", "Pathetic", "Crying", "Eagle", "Errant", "Unholy", "Questionable", "Mean", "Hungry", "Thirsty", "Feeble", "Wise", "Sage", "Magical", "Mythical", "Legendary", "Not Very Nice", "Jerk", "Doctor", "Misunderstood", "Angry", "Knight", "Bishop", "Godly", "Special", "Toasty", "Shiny", "Shimmering", "Light", "Dark", "Odd-Smelling", "Funky", "Rock Smasher", "Son of Herobrine", "Cracked", "Sticky", "\u00a7kAlien", "Baby", "Manly", "Rough", "Scary", "Undoubtable", "Honest", "Non-Suspicious", "Boring", "Odd", "Lazy", "Super", "Nifty", "Ogre Slayer", "Pig Thief", "Dirt Digger", "Really Cool", "Doominator", "... Something"};

    public EntryStatsName(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.name = FileHelper.readText(node, path, "value", "");
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"value"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[0];
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        if (mobStats.theEntity instanceof EntityLiving) {
            String[] nameParts = this.name.split(Character.toString('~'), -1);
            if (nameParts.length == 1) {
                ((EntityLiving)mobStats.theEntity).func_94058_c(this.name);
            } else {
                String mobName = nameParts[0];
                for (int i = 1; i < nameParts.length; ++i) {
                    if (nameParts[i].length() > 0) {
                        char nextLetter = nameParts[i].charAt(0);
                        mobName = nextLetter == 'c' ? mobName + EntryStatsName.getEntityName(mobStats.random) : (nextLetter == 'C' ? mobName + EntryStatsName.getEntityName(mobStats.random) : (nextLetter == 't' ? mobName + SALUTATIONS[mobStats.random.nextInt(SALUTATIONS.length)] : (nextLetter == 'p' ? mobName + EntryStatsName.getPrename(mobStats.random) : (nextLetter == 's' ? mobName + EntryStatsName.getSurname(mobStats.random) : (nextLetter == 'S' ? mobName + EntryStatsName.getSurname(mobStats.random) : (nextLetter == 'd' ? mobName + DESCRIPTORS[mobStats.random.nextInt(DESCRIPTORS.length)] : (nextLetter == 'D' ? mobName + DESCRIPTORS[mobStats.random.nextInt(DESCRIPTORS.length)] : (nextLetter == 'm' ? mobName + EntryStatsName.buildName(mobStats.random) : (nextLetter == 'n' ? mobName + NAMES[mobStats.random.nextInt(NAMES.length)] : mobName + EntryStatsName.getEntityName(mobStats.random))))))))));
                        mobName = mobName + nameParts[i].substring(1);
                        continue;
                    }
                    mobName = mobName + EntryStatsName.getEntityName(mobStats.random);
                }
                ((EntityLiving)mobStats.theEntity).func_94058_c(mobName);
            }
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        String[] nameParts = this.name.split(Character.toString('~'), -1);
        if (nameParts.length == 1) {
            itemStats.theItem.func_151001_c(this.name);
        } else {
            String itemName = nameParts[0];
            for (int i = 1; i < nameParts.length; ++i) {
                if (nameParts[i].length() > 0) {
                    char nextLetter = nameParts[i].charAt(0);
                    itemName = nextLetter == 'c' ? itemName + EntryStatsName.getItemName(itemStats.theItem, itemStats.random) : (nextLetter == 'C' ? itemName + EntryStatsName.getItemName(itemStats.theItem, itemStats.random) : (nextLetter == 'i' ? itemName + EntryStatsName.getItemInfo(itemStats.theItem, itemStats.random) : (nextLetter == 'p' ? itemName + ITEM_PREFIXES[itemStats.random.nextInt(ITEM_PREFIXES.length)] : (nextLetter == 'P' ? itemName + ITEM_PREFIXES[itemStats.random.nextInt(ITEM_PREFIXES.length)] : (nextLetter == 's' ? itemName + ITEM_POSTFIXES[itemStats.random.nextInt(ITEM_POSTFIXES.length)] : (nextLetter == 'S' ? itemName + ITEM_POSTFIXES[itemStats.random.nextInt(ITEM_POSTFIXES.length)] : (nextLetter == 'm' ? itemName + EntryStatsName.buildName(itemStats.random) : (nextLetter == 'n' ? itemName + NAMES[itemStats.random.nextInt(NAMES.length)] : itemName + EntryStatsName.getItemName(itemStats.theItem, itemStats.random)))))))));
                    itemName = itemName + nameParts[i].substring(1);
                    continue;
                }
                itemName = itemName + EntryStatsName.getItemName(itemStats.theItem, itemStats.random);
            }
            itemStats.theItem.func_151001_c(itemName);
        }
    }

    public static String buildName(Random random) {
        String name = NAME_PARTS[random.nextInt(NAME_PARTS.length)] + NAME_PARTS[random.nextInt(NAME_PARTS.length)].toLowerCase();
        if (random.nextInt(2) == 0) {
            name = name + NAME_PARTS[random.nextInt(NAME_PARTS.length)].toLowerCase();
        }
        return name;
    }

    public static String getEntityName(Random random) {
        String name = "";
        if (random.nextInt(4) != 0) {
            name = EntryStatsName.getPrename(random);
            if (random.nextInt(4) != 0) {
                name = EntryStatsName.getSurname(random);
            }
        } else {
            name = random.nextInt(4) != 0 ? EntryStatsName.getSurnameNoDescriptors(random) : (random.nextInt(200) != 0 ? EntryStatsName.getPrename(random) : "\u0000a7lThe Almighty Lord of the Chickens");
        }
        if (random.nextInt(5) == 0) {
            name = SALUTATIONS[random.nextInt(SALUTATIONS.length)] + " " + name;
        }
        return name;
    }

    public static String getPrename(Random random) {
        return random.nextInt(2) == 0 ? NAMES[random.nextInt(NAMES.length)] : EntryStatsName.buildName(random);
    }

    public static String getSurname(Random random) {
        return random.nextInt(2) == 0 ? EntryStatsName.getSurnameNoDescriptors(random) : "the " + DESCRIPTORS[random.nextInt(DESCRIPTORS.length)];
    }

    public static String getSurnameNoDescriptors(Random random) {
        String name = "";
        if (random.nextInt(10) == 0) {
            name = random.nextInt(2) == 0 ? name + "Mac" : name + "Mc";
        }
        return name + EntryStatsName.buildName(random);
    }

    public static String getItemName(ItemStack itemStack, Random random) {
        String name = "";
        boolean prefixed = false;
        if (random.nextInt(2) == 0) {
            prefixed = true;
            name = name + ITEM_PREFIXES[random.nextInt(ITEM_PREFIXES.length)] + " ";
        }
        name = name + EntryStatsName.getItemInfo(itemStack, random);
        if (!prefixed) {
            name = name + " of " + ITEM_POSTFIXES[random.nextInt(ITEM_POSTFIXES.length)];
        }
        return name;
    }

    public static String getItemInfo(ItemStack itemStack, Random random) {
        String name = "";
        String material = null;
        if (itemStack.func_77973_b() instanceof ItemSword) {
            material = ((ItemSword)itemStack.func_77973_b()).func_150932_j();
        } else if (itemStack.func_77973_b() instanceof ItemTool) {
            material = ((ItemTool)itemStack.func_77973_b()).func_77861_e();
        }
        if (material != null) {
            String[][] materials = new String[][]{{"Wooden", "Wood", "Hardwood", "Balsa Wood", "Mahogany", "Plywood"}, {"Stone", "Rock", "Marble", "Cobblestone"}, {"Iron", "Steel", "Ferrous", "Rusty", "Wrought Iron"}, {"Diamond", "Zircon", "Gemstone", "Jewel", "Crystal"}, {"Golden", "Gold", "Gilt", "Auric", "Ornate"}};
            int index = -1;
            if (material.equals(Item.ToolMaterial.WOOD.toString())) {
                index = 0;
            } else if (material.equals(Item.ToolMaterial.STONE.toString())) {
                index = 1;
            } else if (material.equals(Item.ToolMaterial.IRON.toString())) {
                index = 2;
            } else if (material.equals(Item.ToolMaterial.EMERALD.toString())) {
                index = 3;
            } else if (material.equals(Item.ToolMaterial.GOLD.toString())) {
                index = 4;
            }
            name = index < 0 ? name + _MobPropertiesMod.cap(material.toLowerCase()) + " " : name + materials[index][random.nextInt(materials[index].length)] + " ";
            String[] type = new String[]{"Tool"};
            if (itemStack.func_77973_b() instanceof ItemSword) {
                type = new String[]{"Sword", "Cutter", "Slicer", "Dicer", "Knife", "Blade", "Machete", "Brand", "Claymore", "Cutlass", "Foil", "Dagger", "Glaive", "Rapier", "Saber", "Scimitar", "Shortsword", "Longsword", "Broadsword", "Calibur"};
            } else if (itemStack.func_77973_b() instanceof ItemAxe) {
                type = new String[]{"Axe", "Chopper", "Hatchet", "Tomahawk", "Cleaver", "Hacker", "Tree-Cutter", "Truncator"};
            } else if (itemStack.func_77973_b() instanceof ItemPickaxe) {
                type = new String[]{"Pickaxe", "Pick", "Mattock", "Rock-Smasher", "Miner"};
            } else if (itemStack.func_77973_b() instanceof ItemSpade) {
                type = new String[]{"Shovel", "Spade", "Digger", "Excavator", "Trowel", "Scoop"};
            }
            name = name + type[random.nextInt(type.length)];
        } else if (itemStack.func_77973_b() instanceof ItemBow) {
            String[] type = new String[]{"Bow", "Shortbow", "Longbow", "Flatbow", "Recurve Bow", "Reflex Bow", "Self Bow", "Composite Bow", "Arrow-Flinger"};
            name = name + type[random.nextInt(type.length)];
        } else if (itemStack.func_77973_b() instanceof ItemArmor) {
            String[][] materials = new String[][]{{"Leather", "Rawhide", "Lamellar", "Cow Skin"}, {"Chainmail", "Chain", "Chain Link", "Scale"}, {"Iron", "Steel", "Ferrous", "Rusty", "Wrought Iron"}, {"Diamond", "Zircon", "Gemstone", "Jewel", "Crystal"}, {"Golden", "Gold", "Gilt", "Auric", "Ornate"}};
            material = ((ItemArmor)itemStack.func_77973_b()).func_82812_d().toString();
            int index = -1;
            if (material.equals(ItemArmor.ArmorMaterial.CLOTH.toString())) {
                index = 0;
            } else if (material.equals(ItemArmor.ArmorMaterial.CHAIN.toString())) {
                index = 1;
            } else if (material.equals(ItemArmor.ArmorMaterial.IRON.toString())) {
                index = 2;
            } else if (material.equals(ItemArmor.ArmorMaterial.DIAMOND.toString())) {
                index = 3;
            } else if (material.equals(ItemArmor.ArmorMaterial.GOLD.toString())) {
                index = 4;
            }
            name = index < 0 ? name + _MobPropertiesMod.cap(material.toLowerCase()) + " " : name + materials[index][random.nextInt(materials[index].length)] + " ";
            String[] type = new String[]{"Armor"};
            switch (((ItemArmor)itemStack.func_77973_b()).field_77881_a) {
                case 0: {
                    type = new String[]{"Helmet", "Cap", "Crown", "Great Helm", "Bassinet", "Sallet", "Close Helm", "Barbute"};
                    break;
                }
                case 1: {
                    type = new String[]{"Chestplate", "Tunic", "Brigandine", "Hauberk", "Cuirass"};
                    break;
                }
                case 2: {
                    type = new String[]{"Leggings", "Pants", "Tassets", "Cuisses", "Schynbalds"};
                    break;
                }
                case 3: {
                    type = new String[]{"Boots", "Shoes", "Greaves", "Sabatons", "Sollerets"};
                }
            }
            name = name + type[random.nextInt(type.length)];
        } else {
            name = name + itemStack.func_77973_b().func_77653_i(itemStack);
        }
        return name;
    }
}

