/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IProperty;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.DropsHelper;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;
import toast.mobProperties.entry.NBTStatsInfo;

public class PropertyGroup
extends EntryAbstract
implements IPropertyDrops {
    private final double[] counts;
    private final IProperty[] entries;

    public PropertyGroup(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        JsonArray nodes = node.getAsJsonArray("functions");
        if (nodes == null) {
            throw new MobPropertyException("Missing or invalid functions!", path);
        }
        path = path + "\\functions";
        int length = nodes.size();
        this.entries = new IProperty[length];
        for (int i = 0; i < length; ++i) {
            this.entries[i] = loader.readLine(path, root, i, nodes.get(i));
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"functions"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"count"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        int count = FileHelper.getCount(this.counts);
        while (count-- > 0) {
            for (IProperty entry : this.entries) {
                if (entry == null) continue;
                entry.init(mobStats);
            }
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        int count = FileHelper.getCount(this.counts);
        while (count-- > 0) {
            for (IProperty entry : this.entries) {
                if (entry == null) continue;
                entry.modifyItem(itemStats);
            }
        }
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        int count = FileHelper.getCount(this.counts);
        while (count-- > 0) {
            for (IProperty entry : this.entries) {
                if (entry == null) continue;
                entry.addTags(nbtStats);
            }
        }
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        int count = FileHelper.getCount(this.counts);
        while (count-- > 0) {
            for (IProperty entry : this.entries) {
                if (entry == null) continue;
                entry.modifyDrops(mobDrops);
            }
        }
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        if ((chance = DropsHelper.adjustAttemptsAndChance(this.counts, attempts, chance)) > 0.0) {
            for (IProperty entry : this.entries) {
                if (!(entry instanceof IPropertyDrops)) continue;
                ((IPropertyDrops)((Object)entry)).addDrops(dropsList, DropsHelper.copy(attempts), chance, DropsHelper.copy(conditions));
            }
        }
    }
}

