/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.ItemStats;
import toast.mobProperties.MobDrops;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.MobStats;
import toast.mobProperties.NBTStats;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.DropsHelper;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;
import toast.mobProperties.entry.NBTStatsInfo;

public class PropertyExternal
extends EntryAbstract
implements IPropertyDrops {
    private static final HashMap<String, MobDrops> DROPS_MAP = new HashMap();
    private static final HashMap<String, MobStats> STATS_MAP = new HashMap();
    private static final HashMap<String, ItemStats> ITEMS_MAP = new HashMap();
    private static final HashMap<String, NBTStats> NBT_MAP = new HashMap();
    private final double[] counts;
    private final String externalFunction;

    public static void unload() {
        DROPS_MAP.clear();
        STATS_MAP.clear();
        ITEMS_MAP.clear();
        NBT_MAP.clear();
    }

    public static void load(String type, String path, String fileName, JsonObject node) {
        String name = fileName.substring(0, fileName.length() - ".json".length());
        if (type.equals("drops")) {
            PropertyExternal.loadDrop(path, name, node);
        } else if (type.equals("stats")) {
            PropertyExternal.loadStat(path, name, node);
        } else if (type.equals("items")) {
            PropertyExternal.loadItem(path, name, node);
        } else if (type.equals("nbt")) {
            PropertyExternal.loadNbt(path, name, node);
        }
    }

    private static void loadDrop(String path, String name, JsonObject node) {
        if (DROPS_MAP.containsKey(name)) {
            throw new MobPropertyException("Duplicate external drops property! (name: " + name + ")", path);
        }
        JsonObject dummyRoot = new JsonObject();
        JsonArray dummyArray = new JsonArray();
        dummyArray.add((JsonElement)node);
        dummyRoot.add("drops", (JsonElement)dummyArray);
        DROPS_MAP.put(name, new MobDrops(path, dummyRoot, dummyArray));
    }

    private static void loadStat(String path, String name, JsonObject node) {
        if (STATS_MAP.containsKey(name)) {
            throw new MobPropertyException("Duplicate external stats property! (name: " + name + ")", path);
        }
        JsonObject dummyRoot = new JsonObject();
        JsonArray dummyArray = new JsonArray();
        dummyArray.add((JsonElement)node);
        dummyRoot.add("stats", (JsonElement)dummyArray);
        STATS_MAP.put(name, new MobStats(path, dummyRoot, dummyArray));
    }

    private static void loadItem(String path, String name, JsonObject node) {
        if (ITEMS_MAP.containsKey(name)) {
            throw new MobPropertyException("Duplicate external item stats property! (name: " + name + ")", path);
        }
        JsonObject dummyRoot = new JsonObject();
        JsonArray dummyArray = new JsonArray();
        dummyArray.add((JsonElement)node);
        dummyRoot.add("item_stats", (JsonElement)dummyArray);
        ITEMS_MAP.put(name, new ItemStats(path, dummyRoot, 0, dummyRoot, null));
    }

    private static void loadNbt(String path, String name, JsonObject node) {
        if (NBT_MAP.containsKey(name)) {
            throw new MobPropertyException("Duplicate external nbt stats property! (name: " + name + ")", path);
        }
        JsonObject dummyRoot = new JsonObject();
        JsonArray dummyArray = new JsonArray();
        dummyArray.add((JsonElement)node);
        dummyRoot.add("tags", (JsonElement)dummyArray);
        NBT_MAP.put(name, new NBTStats(path, dummyRoot, 0, dummyRoot, null));
    }

    public PropertyExternal(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        this.externalFunction = FileHelper.readText(node, path, "file", "");
        if (this.externalFunction == "") {
            throw new MobPropertyException("Missing or invalid external file name!", path);
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"file"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"count"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        MobStats stats = STATS_MAP.get(this.externalFunction);
        if (stats != null) {
            int count = FileHelper.getCount(this.counts);
            while (count-- > 0) {
                stats.init(mobStats);
            }
        } else {
            throw new RuntimeException("[ERROR] External stats function \"" + this.externalFunction + ".json\" not found!");
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        ItemStats stats = ITEMS_MAP.get(this.externalFunction);
        if (stats != null) {
            int count = FileHelper.getCount(this.counts);
            while (count-- > 0) {
                stats.generate(itemStats);
            }
        } else {
            throw new RuntimeException("[ERROR] External item stats function \"" + this.externalFunction + ".json\" not found!");
        }
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        NBTStats stats = NBT_MAP.get(this.externalFunction);
        if (stats != null) {
            int count = FileHelper.getCount(this.counts);
            while (count-- > 0) {
                stats.generate(nbtStats);
            }
        } else {
            throw new RuntimeException("[ERROR] External nbt function \"" + this.externalFunction + ".json\" not found!");
        }
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        MobDrops drops = DROPS_MAP.get(this.externalFunction);
        if (drops != null) {
            int count = FileHelper.getCount(this.counts);
            while (count-- > 0) {
                drops.modifyDrops(mobDrops);
            }
        } else {
            throw new RuntimeException("[ERROR] External drops function \"" + this.externalFunction + ".json\" not found!");
        }
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        MobDrops drops;
        if ((chance = DropsHelper.adjustAttemptsAndChance(this.counts, attempts, chance)) > 0.0 && (drops = DROPS_MAP.get(this.externalFunction)) != null) {
            drops.addDrops(dropsList, DropsHelper.copy(attempts), chance, DropsHelper.copy(conditions));
        }
    }
}

