/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import com.google.gson.JsonObject;
import net.minecraft.command.CommandBase;
import net.minecraft.command.IAdminCommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobCommandSender;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;

public class EntryCommand
extends EntryAbstract {
    private final double[] counts;
    private final String command;
    private final boolean noOutput;

    public EntryCommand(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        this.command = FileHelper.readText(node, path, "value", "");
        if (this.command == "") {
            throw new MobPropertyException("Missing or invalid command!", path);
        }
        this.noOutput = FileHelper.readBoolean(node, path, "suppress_output", true);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"value"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"count", "suppress_output"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null) {
            ICommandManager commandManager = server.func_71187_D();
            ServerCommandManager admin = null;
            if (this.noOutput && commandManager instanceof ServerCommandManager) {
                admin = (ServerCommandManager)commandManager;
                CommandBase.func_71529_a(null);
            }
            MobCommandSender commandSender = new MobCommandSender(mobStats.theEntity);
            int count = FileHelper.getCount(this.counts);
            while (count-- > 0) {
                commandManager.func_71556_a((ICommandSender)commandSender, this.command);
            }
            if (admin != null) {
                CommandBase.func_71529_a((IAdminCommand)admin);
            }
        }
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null) {
            ICommandManager commandManager = server.func_71187_D();
            ServerCommandManager admin = null;
            if (this.noOutput && commandManager instanceof ServerCommandManager) {
                admin = (ServerCommandManager)commandManager;
                CommandBase.func_71529_a(null);
            }
            MobCommandSender commandSender = new MobCommandSender(mobDrops.theEntity);
            int count = FileHelper.getCount(this.counts);
            while (count-- > 0) {
                commandManager.func_71556_a((ICommandSender)commandSender, this.command);
            }
            if (admin != null) {
                CommandBase.func_71529_a((IAdminCommand)admin);
            }
        }
    }
}

