/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IProperty;
import toast.mobProperties.MobDrops;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.MobStats;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;
import toast.mobProperties.entry.NBTStatsInfo;

public class MobProperties
implements IProperty {
    private static final HashMap<String, MobProperties> PROPERTIES_MAP = new HashMap();
    private final String entityId;
    private final IProperty preStats;
    private final IProperty stats;
    private final IProperty drops;

    public static MobProperties getProperties(EntityLivingBase entity) {
        return MobProperties.getProperties(EntityList.func_75621_b((Entity)entity));
    }

    public static MobProperties getProperties(String entityId) {
        return PROPERTIES_MAP.get(entityId);
    }

    public static void unload() {
        PROPERTIES_MAP.clear();
    }

    public static void load(String path, JsonObject node) {
        String id = null;
        try {
            id = node.get("_name").getAsString();
        }
        catch (Exception ex) {
            throw new MobPropertyException("Missing or invalid mob id!", path, ex);
        }
        if (id == null || id == "") {
            throw new MobPropertyException("Mob id cannot be null or empty!", path);
        }
        if (PROPERTIES_MAP.containsKey(id)) {
            throw new MobPropertyException("Duplicate mob file! (id: " + id + ")", path);
        }
        JsonArray preStatNodes = node.getAsJsonArray("pre_stats");
        JsonArray statNodes = node.getAsJsonArray("stats");
        JsonArray dropNodes = node.getAsJsonArray("drops");
        PROPERTIES_MAP.put(id, new MobProperties(path, node, id, preStatNodes, statNodes, dropNodes));
    }

    private MobProperties(String path, JsonObject root, String id, JsonArray preStatNodes, JsonArray statNodes, JsonArray dropNodes) {
        FileHelper.verify(root, path, this);
        this.entityId = id;
        this.preStats = preStatNodes == null ? null : new MobStats(path + "\\pre_stats", root, preStatNodes);
        this.stats = statNodes == null ? null : new MobStats(path + "\\stats", root, statNodes);
        this.drops = dropNodes == null ? null : new MobDrops(path + "\\drops", root, dropNodes);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"_name"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"drops", "stats", "pre_stats"};
    }

    @Override
    public String getJsonString() {
        throw new UnsupportedOperationException("Non-functions are not used as Json strings!");
    }

    public void preInit(MobStatsInfo mobStats) {
        if (this.preStats != null) {
            this.preStats.init(mobStats);
        }
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        if (this.stats != null) {
            this.stats.init(mobStats);
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        throw new UnsupportedOperationException("Non-item properties can not modify items!");
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        throw new UnsupportedOperationException("Non-nbt properties can not modify nbt!");
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        if (this.drops != null) {
            this.drops.modifyDrops(mobDrops);
        }
    }

    public void addDrops(List<DropEntry> dropsList) {
        if (this.drops instanceof IPropertyDrops) {
            ((IPropertyDrops)((Object)this.drops)).addDrops(dropsList, new double[]{1.0, 1.0}, 1.0, new ArrayList<String>());
        }
    }

    public String getEntityId() {
        return this.entityId;
    }
}

