/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.network;

import com.github.abrarsyed.secretroomsmod.common.BlockLocation;
import com.github.abrarsyed.secretroomsmod.common.OwnershipManager;
import com.github.abrarsyed.secretroomsmod.network.PacketBase;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class PacketSyncOwnership
extends PacketBase {
    int dimension;
    boolean clear = false;
    Collection<BlockLocation> locations;

    public PacketSyncOwnership() {
    }

    public PacketSyncOwnership(int dimension, Collection<BlockLocation> locations) {
        this.dimension = dimension;
        this.locations = locations;
    }

    public PacketSyncOwnership(int dimension) {
        this.dimension = dimension;
        this.locations = null;
        this.clear = true;
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        output.writeInt(this.dimension);
        if (this.clear) {
            output.writeInt(-1);
        }
        output.writeInt(this.locations.size());
        for (BlockLocation loc : this.locations) {
            loc.writeToData((DataOutput)output, false);
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.dimension = input.readInt();
        int size = input.readInt();
        if (size == -1) {
            this.clear = true;
            return;
        }
        this.locations = new ArrayList<BlockLocation>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(BlockLocation.readFromData((DataInput)input, false, this.dimension));
        }
    }

    @Override
    public void actionClient(World world, EntityPlayer player) {
        if (this.clear) {
            OwnershipManager.clearDimension(this.dimension);
            return;
        }
        Map<BlockLocation, UUID> map = OwnershipManager.getOwnershipMap(this.dimension);
        for (BlockLocation loc : this.locations) {
            map.put(loc, player.func_110124_au());
        }
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
    }
}

