/*
 * Decompiled with CFR 0.152.
 */
package foxz.utils;

import java.io.File;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.util.NBTJsonUtil;

public class Market {
    public static void save(RoleTrader r, String name) {
        if (name.isEmpty()) {
            return;
        }
        File file = Market.getFile(name + "_new");
        File file1 = Market.getFile(name);
        try {
            NBTJsonUtil.SaveFile(file, r.writeNBT(new NBTTagCompound()));
            if (file1.exists()) {
                file1.delete();
            }
            file.renameTo(file1);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void load(RoleTrader role, String name) {
        if (role.npc.field_70170_p.field_72995_K) {
            return;
        }
        File file = Market.getFile(name);
        if (!file.exists()) {
            return;
        }
        try {
            role.readNBT(NBTJsonUtil.LoadFile(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static File getFile(String name) {
        File dir = new File(CustomNpcs.getWorldSaveDirectory(), "markets");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return new File(dir, name.toLowerCase() + ".json");
    }

    public static void setMarket(EntityNPCInterface npc, String marketName) {
        if (marketName.isEmpty()) {
            return;
        }
        if (!Market.getFile(marketName).exists()) {
            Market.save((RoleTrader)npc.roleInterface, marketName);
        }
        Market.load((RoleTrader)npc.roleInterface, marketName);
    }
}

