/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.registry;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import me.otho.customItems.configuration.jsonReaders.tweakers.Cfg_change_block;
import me.otho.customItems.configuration.jsonReaders.tweakers.Cfg_change_food;
import me.otho.customItems.configuration.jsonReaders.tweakers.Cfg_change_item;
import me.otho.customItems.utility.LogHelper;
import me.otho.customItems.utility.Util;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;

public class TweakerRegistry {
    public static boolean changeBlock(Cfg_change_block data) {
        String[] nameParsing = data.name.split(":");
        String modId = nameParsing[0];
        String name = nameParsing[1];
        data.toolClass = Util.validateToolClass(data.toolClass);
        if (modId != null && name != null) {
            Block block = GameRegistry.findBlock((String)modId, (String)name);
            if (data.isOpaque != null) {
                if (data.isOpaque.booleanValue()) {
                    block.func_149713_g(255);
                } else {
                    block.func_149713_g(0);
                }
            }
            if (data.hardness != null) {
                block.func_149711_c(data.hardness.floatValue());
            }
            if (data.resistance != null) {
                block.func_149752_b(data.resistance.floatValue());
            }
            if (data.lightLevel != null) {
                block.func_149715_a(data.lightLevel.floatValue());
            }
            if (data.harvestLevel != null) {
                block.setHarvestLevel(data.toolClass, data.harvestLevel.intValue());
            }
            if (data.slipperiness != null) {
                block.field_149765_K = data.slipperiness.floatValue();
            }
            if (data.stepSound != null) {
                block.func_149672_a(Util.parseSoundType(data.stepSound));
            }
            if (data.maxStackSize != null) {
                Item itemBlock = Item.func_150898_a((Block)block);
                int size = Util.range(data.maxStackSize, 1, 64);
                itemBlock.func_77625_d(size);
            }
        }
        return true;
    }

    public static boolean changeBlock(Cfg_change_block[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean tweaked = TweakerRegistry.changeBlock(data[i]);
            if (tweaked) continue;
            LogHelper.error("Failed to tweak: Block " + i);
            return false;
        }
        return true;
    }

    public static boolean changeItem(Cfg_change_item data) {
        String[] nameParsing = data.name.split(":");
        String modId = nameParsing[0];
        String name = nameParsing[1];
        if (modId != null && name != null) {
            Item item = GameRegistry.findItem((String)modId, (String)name);
            if (data.maxStackSize != null) {
                int size = Util.range(data.maxStackSize, 1, 64);
                item.func_77625_d(size);
            }
        }
        return true;
    }

    public static boolean changeItem(Cfg_change_item[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean tweaked = TweakerRegistry.changeItem(data[i]);
            if (tweaked) continue;
            LogHelper.error("Failed to tweak: Item " + i);
            return false;
        }
        return true;
    }

    private static boolean changeFood(Cfg_change_food data) {
        String[] nameParsing = data.name.split(":");
        String modId = nameParsing[0];
        String name = nameParsing[1];
        ItemFood food = (ItemFood)GameRegistry.findItem((String)modId, (String)name);
        ObfuscationReflectionHelper.setPrivateValue(ItemFood.class, (Object)food, (Object)data.healAmount, (String[])new String[]{"field_77853_b"});
        ObfuscationReflectionHelper.setPrivateValue(ItemFood.class, (Object)food, (Object)Float.valueOf(data.saturationModifier), (String[])new String[]{"field_77854_c"});
        ObfuscationReflectionHelper.setPrivateValue(ItemFood.class, (Object)food, (Object)data.isWolfFood, (String[])new String[]{"field_77856_bY"});
        if (data.alwaysEdible) {
            food.func_77848_i();
        }
        if (data.potionEffect != null) {
            food.func_77844_a(Util.potionEffectId(data.potionEffect.effect), data.potionEffect.potionDuration, data.potionEffect.potionAmplifier, data.potionEffect.potionEffectProbability);
        }
        if (data.maxStackSize != null) {
            int size = Util.range(data.maxStackSize, 1, 64);
            food.func_77625_d(size);
        }
        return true;
    }

    public static boolean changeFood(Cfg_change_food[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean tweaked = TweakerRegistry.changeFood(data[i]);
            if (tweaked) continue;
            LogHelper.error("Failed to tweak: food " + i);
            return false;
        }
        return true;
    }
}

