/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.registry;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import me.otho.customItems.configuration.jsonReaders.items.Cfg_item;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_boots;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_chestplate;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_helmet;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_leggings;
import me.otho.customItems.configuration.jsonReaders.items.food.Cfg_food;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_axe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_hoe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_pickaxe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_shovel;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_sword;
import me.otho.customItems.mod.items.CustomItem;
import me.otho.customItems.mod.items.armor.CustomArmor;
import me.otho.customItems.mod.items.food.CustomFood;
import me.otho.customItems.mod.items.tools.CustomAxe;
import me.otho.customItems.mod.items.tools.CustomHoe;
import me.otho.customItems.mod.items.tools.CustomPickaxe;
import me.otho.customItems.mod.items.tools.CustomShovel;
import me.otho.customItems.mod.items.tools.CustomSword;
import me.otho.customItems.registry.Registry;
import me.otho.customItems.utility.LogHelper;
import me.otho.customItems.utility.Util;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.Level;

public class ItemRegistry {
    public static boolean registerAxe(Cfg_axe data) {
        LogHelper.info(data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        Item.ToolMaterial material = EnumHelper.addToolMaterial((String)data.textureName, (int)data.harvestLevel, (int)data.maxUses, (float)data.efficiencyOnProperMaterial, (float)data.damageVsEntity, (int)data.enchantability);
        CustomAxe axe = new CustomAxe(material);
        Registry.itemsList.add((Object)axe);
        Registry.itemsList.add(data.creativeTab);
        axe.func_111206_d(data.textureName);
        GameRegistry.registerItem((Item)axe, (String)registerName);
        axe.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(axe.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return true;
    }

    public static boolean registerAxe(Cfg_axe[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerAxe(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Axe " + i);
            return false;
        }
        return true;
    }

    public static boolean registerBoots(Cfg_boots data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        int[] reduction = new int[]{0, 0, 0, 0};
        reduction[3] = data.reduction;
        ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)data.textureName, (int)data.durability, (int[])reduction, (int)data.enchantability);
        CustomArmor armor = new CustomArmor(material, 0, 3, data.textureName, data.durability);
        Registry.itemsList.add((Object)armor);
        Registry.itemsList.add(data.creativeTab);
        armor.func_111206_d(data.textureName);
        GameRegistry.registerItem((Item)armor, (String)registerName);
        armor.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(armor.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return false;
    }

    public static boolean registerBoots(Cfg_boots[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerBoots(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Boots " + i);
            return false;
        }
        return true;
    }

    public static boolean registerChestplate(Cfg_chestplate data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        int[] reduction = new int[]{0, 0, 0, 0};
        reduction[1] = data.reduction;
        ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)data.textureName, (int)data.durability, (int[])reduction, (int)data.enchantability);
        CustomArmor armor = new CustomArmor(material, 0, 1, data.textureName, data.durability);
        Registry.itemsList.add((Object)armor);
        Registry.itemsList.add(data.creativeTab);
        armor.func_111206_d(data.textureName);
        GameRegistry.registerItem((Item)armor, (String)registerName);
        armor.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(armor.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return false;
    }

    public static boolean registerChestplate(Cfg_chestplate[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerChestplate(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Chestplate " + i);
            return false;
        }
        return true;
    }

    public static boolean registerFood(Cfg_food data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        CustomFood food = new CustomFood(data.healAmount, data.saturationModifier, data.isWolfFood);
        if (data.alwaysEdible) {
            food.func_77848_i();
        }
        if (data.potionEffects != null && data.potionEffects.length > 0) {
            food.setFoodEffectsArray(data.potionEffects);
        }
        if (data.dropItemName != null) {
            String[] parser = data.dropItemName.split(":");
            String modId = parser[0];
            String name = parser[1];
            int damage = 0;
            if (parser.length > 2) {
                damage = Integer.parseInt(parser[2]);
            }
            food.setDropStack(new ItemStack(GameRegistry.findItem((String)modId, (String)name), 1, damage));
        }
        food.setUseAction(data.useAction);
        Registry.itemsList.add((Object)food);
        Registry.itemsList.add(data.creativeTab);
        GameRegistry.registerItem((Item)food, (String)registerName);
        food.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        food.func_111206_d(data.textureName);
        LanguageRegistry.instance().addStringLocalization(food.func_77658_a() + ".name", "en_US", data.name);
        return false;
    }

    public static boolean registerFood(Cfg_food[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerFood(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Food " + i);
            return false;
        }
        return true;
    }

    public static boolean registerHelmet(Cfg_helmet data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        int[] reduction = new int[]{0, 0, 0, 0};
        reduction[0] = data.reduction;
        ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)data.textureName, (int)data.durability, (int[])reduction, (int)data.enchantability);
        CustomArmor armor = new CustomArmor(material, 0, 0, data.textureName, data.durability);
        Registry.itemsList.add((Object)armor);
        Registry.itemsList.add(data.creativeTab);
        armor.func_111206_d(data.textureName);
        GameRegistry.registerItem((Item)armor, (String)registerName);
        armor.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(armor.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return false;
    }

    public static boolean registerHelmet(Cfg_helmet[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerHelmet(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Helmet " + i);
            return false;
        }
        return true;
    }

    public static boolean registerHoe(Cfg_hoe data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        Item.ToolMaterial material = EnumHelper.addToolMaterial((String)data.textureName, (int)data.harvestLevel, (int)data.maxUses, (float)data.efficiencyOnProperMaterial, (float)data.damageVsEntity, (int)data.enchantability);
        CustomHoe hoe = new CustomHoe(material);
        Registry.itemsList.add((Object)hoe);
        Registry.itemsList.add(data.creativeTab);
        hoe.func_111206_d(data.textureName);
        GameRegistry.registerItem((Item)hoe, (String)registerName);
        hoe.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(hoe.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return true;
    }

    public static boolean registerHoe(Cfg_hoe[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerHoe(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Hoe " + i);
            return false;
        }
        return true;
    }

    public static boolean registerItem(Cfg_item data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        CustomItem item = new CustomItem(data.maxStackSize);
        item.setGlows(data.glows);
        Registry.itemsList.add((Object)item);
        Registry.itemsList.add(data.creativeTab);
        GameRegistry.registerItem((Item)item, (String)registerName);
        item.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        item.func_111206_d(data.textureName);
        LanguageRegistry.instance().addStringLocalization(item.func_77658_a() + ".name", "en_US", data.name);
        return false;
    }

    public static boolean registerItem(Cfg_item[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerItem(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Item " + i);
            return false;
        }
        return true;
    }

    public static boolean registerLeggings(Cfg_leggings data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        int[] reduction = new int[]{0, 0, 0, 0};
        reduction[2] = data.reduction;
        ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)data.textureName, (int)data.durability, (int[])reduction, (int)data.enchantability);
        CustomArmor armor = new CustomArmor(material, 0, 2, data.textureName, data.durability);
        Registry.itemsList.add((Object)armor);
        Registry.itemsList.add(data.creativeTab);
        armor.func_111206_d(data.textureName);
        GameRegistry.registerItem((Item)armor, (String)registerName);
        armor.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(armor.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return true;
    }

    public static boolean registerLeggings(Cfg_leggings[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerLeggings(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Leggings " + i);
            return false;
        }
        return true;
    }

    public static boolean registerPickaxe(Cfg_pickaxe data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        Item.ToolMaterial material = EnumHelper.addToolMaterial((String)data.textureName, (int)data.harvestLevel, (int)data.maxUses, (float)data.efficiencyOnProperMaterial, (float)data.damageVsEntity, (int)data.enchantability);
        CustomPickaxe pickaxe = new CustomPickaxe(material);
        pickaxe.func_111206_d(data.textureName);
        Registry.itemsList.add((Object)pickaxe);
        Registry.itemsList.add(data.creativeTab);
        GameRegistry.registerItem((Item)pickaxe, (String)registerName);
        pickaxe.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(pickaxe.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return true;
    }

    public static boolean registerPickaxe(Cfg_pickaxe[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerPickaxe(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Pickaxe " + i);
            return false;
        }
        return true;
    }

    public static boolean registerShovel(Cfg_shovel data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        Item.ToolMaterial material = EnumHelper.addToolMaterial((String)data.textureName, (int)data.harvestLevel, (int)data.maxUses, (float)data.efficiencyOnProperMaterial, (float)data.damageVsEntity, (int)data.enchantability);
        CustomShovel shovel = new CustomShovel(material);
        shovel.func_111206_d(data.textureName);
        Registry.itemsList.add((Object)shovel);
        Registry.itemsList.add(data.creativeTab);
        GameRegistry.registerItem((Item)shovel, (String)registerName);
        shovel.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(shovel.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return true;
    }

    public static boolean registerShovel(Cfg_shovel[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerShovel(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Shovel " + i);
            return false;
        }
        return true;
    }

    public static boolean registerSword(Cfg_sword data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        Item.ToolMaterial material = EnumHelper.addToolMaterial((String)data.textureName, (int)data.harvestLevel, (int)data.maxUses, (float)data.efficiencyOnProperMaterial, (float)data.damageVsEntity, (int)data.enchantability);
        CustomSword sword = new CustomSword(material);
        sword.func_111206_d(data.textureName);
        Registry.itemsList.add((Object)sword);
        Registry.itemsList.add(data.creativeTab);
        GameRegistry.registerItem((Item)sword, (String)registerName);
        sword.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(sword.func_77658_a() + ".name", "en_US", data.name.substring(0, 1).toUpperCase() + data.name.substring(1));
        return true;
    }

    public static boolean registerSword(Cfg_sword[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = ItemRegistry.registerSword(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Sword " + i);
            return false;
        }
        return true;
    }
}

