/*
 * Decompiled with CFR 0.152.
 */
package com.Otho.customItems.handler;

import com.Otho.customItems.handler.ConfigurationHandler;
import com.Otho.customItems.mod.blocks.CustomBlock;
import com.Otho.customItems.mod.materials.CI_Material;
import com.Otho.customItems.util.StringUtil;
import com.Otho.customItems.util.logHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.block.Block;

public class BlockHandler {
    /*
     * WARNING - void declaration
     */
    public static void init() {
        JsonArray blocksData = ConfigurationHandler.blocks;
        if (blocksData != null) {
            logHelper.log((String)"customItems", (String)logHelper.debug, (String)"Registering custom Blocks");
            int i = 0;
            while (i < blocksData.size()) {
                void var1_1;
                JsonObject blockData = (JsonObject)blocksData.get((int)var1_1);
                logHelper.log((String)"customItems", (String)logHelper.info, (String)blockData.toString());
                String name = blockData.get("name").getAsString();
                String textureName = blockData.get("textureName").getAsString();
                textureName = StringUtil.parseTextureName((String)textureName);
                String material = blockData.get("material").getAsString();
                String toolClass = blockData.get("toolClass").getAsString();
                String TC = BlockHandler.validateToolClass(toolClass);
                float hardness = blockData.get("hardness").getAsFloat();
                float resistance = blockData.get("resistance").getAsFloat();
                float lightLevel = blockData.get("lightLevel").getAsFloat();
                JsonElement HL = blockData.get("harvestLevel");
                int harvestLevel = HL == null || !TC.equals("pickaxe") ? 0 : blockData.get("harvestLevel").getAsInt();
                CustomBlock block = new CustomBlock(CI_Material.getMaterial(material));
                block.setHardness(hardness);
                block.setResistance(resistance);
                block.setLightLevel(lightLevel);
                block.setHarvestLevel(TC, harvestLevel);
                GameRegistry.registerBlock((Block)block, (String)textureName);
                block.setBlockName("customItems".toLowerCase() + ":" + textureName);
                LanguageRegistry.instance().addStringLocalization(block.getUnlocalizedName() + ".name", "en_US", name);
                ++var1_1;
            }
        }
    }

    private static String validateToolClass(String toolClass) {
        if (toolClass.equals("pickaxe")) {
            return toolClass;
        }
        if (toolClass.equals("axe")) {
            return toolClass;
        }
        if (toolClass.equals("shovel")) {
            return toolClass;
        }
        return "pickaxe";
    }
}

