/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.api.rendering;

import com.cricketcraft.chisel.api.carving.CarvableHelper;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import team.chisel.ctmlib.CTM;
import team.chisel.ctmlib.ISubmapManager;
import team.chisel.ctmlib.RenderBlocksCTM;
import team.chisel.ctmlib.RenderBlocksColumn;
import team.chisel.ctmlib.TextureSubmap;

public enum TextureType {
    TOPBOTSIDE(new String[]{"top", "bottom", "side"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return new IIcon[]{register.func_94245_a(modName + ":" + texturePath + "-side"), register.func_94245_a(modName + ":" + texturePath + "-bottom"), register.func_94245_a(modName + ":" + texturePath + "-top")};
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            IIcon[] icons = (IIcon[])cachedObject;
            return side > 1 ? icons[0] : icons[side + 1];
        }
    }
    ,
    TOPSIDE(new String[]{"top", "side"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return new IIcon[]{register.func_94245_a(modName + ":" + texturePath + "-side"), register.func_94245_a(modName + ":" + texturePath + "-top")};
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            IIcon[] icons = (IIcon[])cachedObject;
            return side > 1 ? icons[0] : icons[1];
        }
    }
    ,
    CTMV(new String[]{"ctmv", "top"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return Pair.of((Object)new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-ctmv"), 2, 2), (Object)register.func_94245_a(modName + ":" + texturePath + "-top"));
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            Pair data = (Pair)cachedObject;
            return side < 2 ? (IIcon)data.getRight() : ((TextureSubmap)data.getLeft()).getSubIcon(0, 0);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
            Pair data = (Pair)cachedObject;
            if (side < 2) {
                return (IIcon)data.getRight();
            }
            Block block = world.func_147439_a(x, y, z);
            boolean topConnected = ctm.isConnected(world, x, y + 1, z, side, block, meta);
            boolean botConnected = ctm.isConnected(world, x, y - 1, z, side, block, meta);
            TextureSubmap map = (TextureSubmap)data.getLeft();
            if (topConnected && botConnected) {
                return map.getSubIcon(0, 1);
            }
            if (topConnected && !botConnected) {
                return map.getSubIcon(1, 1);
            }
            if (!topConnected && botConnected) {
                return map.getSubIcon(1, 0);
            }
            return map.getSubIcon(0, 0);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected RenderBlocks createRenderContext(RenderBlocks rendererOld, IBlockAccess world, Object cachedObject) {
            RenderBlocksColumn ret = theRenderBlocksColumn;
            Pair data = (Pair)cachedObject;
            ret.field_147845_a = world;
            ret.field_147861_i = 1.0;
            ret.field_147857_k = 1.0;
            ret.field_147853_m = 1.0;
            ret.submap = (TextureSubmap)data.getLeft();
            ret.iconTop = (IIcon)data.getRight();
            return ret;
        }
    }
    ,
    CTMH(new String[]{"ctmh", "top"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return Pair.of((Object)new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-ctmh"), 2, 2), (Object)register.func_94245_a(modName + ":" + texturePath + "-top"));
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            return CTMV.getIcon(variation, cachedObject, side, meta);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
            boolean n;
            boolean p;
            boolean reverse;
            Pair data = (Pair)cachedObject;
            if (side < 2) {
                return (IIcon)data.getRight();
            }
            Block block = ctm.getBlockOrFacade(world, x, y, z, side);
            boolean bl = reverse = side == 3 || side == 4;
            if (side < 4) {
                p = ctm.isConnected(world, x - 1, y, z, side, block, meta);
                n = ctm.isConnected(world, x + 1, y, z, side, block, meta);
            } else {
                p = ctm.isConnected(world, x, y, z - 1, side, block, meta);
                n = ctm.isConnected(world, x, y, z + 1, side, block, meta);
            }
            TextureSubmap map = (TextureSubmap)data.getLeft();
            if (p && n) {
                return map.getSubIcon(1, 0);
            }
            if (p) {
                return map.getSubIcon(reverse ? 1 : 0, 1);
            }
            if (n) {
                return map.getSubIcon(reverse ? 0 : 1, 1);
            }
            return map.getSubIcon(0, 0);
        }
    }
    ,
    V9(new String[]{"v9"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-v9"), 3, 3);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            return ((TextureSubmap)cachedObject).getSubIcon(1, 1);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
            return 5.getVIcon(this, (TextureSubmap)cachedObject, x, y, z, side);
        }
    }
    ,
    V4(new String[]{"v4"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-v4"), 2, 2);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            return ((TextureSubmap)cachedObject).getSubIcon(0, 0);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
            return 6.getVIcon(this, (TextureSubmap)cachedObject, x, y, z, side);
        }
    }
    ,
    CTMX(new String[]{"", "ctm"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            IIcon baseIcon = register.func_94245_a(modName + ":" + texturePath);
            return Triple.of((Object)baseIcon, (Object)new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-ctm"), 4, 4), (Object)new TextureSubmap(baseIcon, 2, 2));
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            return (IIcon)((Triple)cachedObject).getLeft();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected RenderBlocks createRenderContext(RenderBlocks rendererOld, IBlockAccess world, Object cachedObject) {
            RenderBlocksCTM ret = theRenderBlocksCTM;
            Triple data = (Triple)cachedObject;
            ret.field_147845_a = world;
            ret.submap = (TextureSubmap)data.getMiddle();
            ret.submapSmall = (TextureSubmap)data.getRight();
            ret.rendererOld = rendererOld;
            return ret;
        }
    }
    ,
    R16(new String[]{"r16"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-r16"), 4, 4);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            return V9.getIcon(variation, cachedObject, side, meta);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
            return 8.getRIcon(this, (TextureSubmap)cachedObject, x, y, z, side);
        }
    }
    ,
    R9(new String[]{"r9"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-r9"), 3, 3);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            return V9.getIcon(variation, cachedObject, side, meta);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
            return 9.getRIcon(this, (TextureSubmap)cachedObject, x, y, z, side);
        }
    }
    ,
    R4(new String[]{"r4"}){

        @Override
        protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
            return new TextureSubmap(register.func_94245_a(modName + ":" + texturePath + "-r4"), 2, 2);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
            return V4.getIcon(variation, cachedObject, side, meta);
        }

        @Override
        protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
            return 10.getRIcon(this, (TextureSubmap)cachedObject, x, y, z, side);
        }
    }
    ,
    NORMAL(new String[0]),
    CUSTOM(new String[0]);

    private static final TextureType[] VALUES;
    private static final CTM ctm;
    private static final Random rand;
    @SideOnly(value=Side.CLIENT)
    private static RenderBlocksCTM theRenderBlocksCTM;
    @SideOnly(value=Side.CLIENT)
    private static RenderBlocksColumn theRenderBlocksColumn;
    private String[] suffixes;

    public static IIcon getVIcon(TextureType type, TextureSubmap map, int x, int y, int z, int side) {
        int variationSize = type == V9 ? 3 : 2;
        int xModulus = x % variationSize;
        int zModulus = z % variationSize;
        int textureX = xModulus < 0 ? xModulus + variationSize : xModulus;
        int textureZ = zModulus < 0 ? zModulus + variationSize : zModulus;
        int textureY = variationSize - y % variationSize - 1;
        if (side == 2 || side == 5) {
            textureX = variationSize - textureX - 1;
            textureZ = variationSize - textureZ - 1;
        }
        int index = side == 0 || side == 1 ? textureX + textureZ * variationSize : (side == 2 || side == 3 ? textureX + textureY * variationSize : textureZ + textureY * variationSize);
        return map.getSubIcon(index % variationSize, index / variationSize);
    }

    public static IIcon getRIcon(TextureType type, TextureSubmap map, int x, int y, int z, int side) {
        rand.setSeed(TextureType.getCoordinateRandom(x, y, z));
        rand.nextBoolean();
        int size = type == R4 ? 2 : (type == R9 ? 3 : 4);
        return map.getSubIcon(rand.nextInt(size), rand.nextInt(size));
    }

    private static long getCoordinateRandom(int x, int y, int z) {
        long l = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        l = l * l * 42317861L + l * 11L;
        return l;
    }

    private TextureType(String ... suffixes) {
        String[] stringArray;
        if (suffixes.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = suffixes;
        }
        this.suffixes = stringArray;
    }

    private static void initStatics() {
        if (theRenderBlocksCTM == null) {
            theRenderBlocksCTM = new RenderBlocksCTM();
            theRenderBlocksColumn = new RenderBlocksColumn();
        }
    }

    public ISubmapManager createManagerFor(ICarvingVariation variation, String texturePath) {
        return new SubmapManagerDefault(this, variation, texturePath);
    }

    public ISubmapManager createManagerFor(ICarvingVariation variation, Block block, int meta) {
        return new SubmapManagerExistingIcon(this, variation, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    protected Object registerIcons(ICarvingVariation variation, String modName, String texturePath, IIconRegister register) {
        return register.func_94245_a(modName + ":" + texturePath);
    }

    protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, int side, int meta) {
        return (IIcon)cachedObject;
    }

    protected IIcon getIcon(ICarvingVariation variation, Object cachedObject, IBlockAccess world, int x, int y, int z, int side, int meta) {
        return this.getIcon(variation, cachedObject, side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlocks createRenderContext(RenderBlocks rendererOld, IBlockAccess world, Object cachedObject) {
        return rendererOld;
    }

    public static TextureType getTypeFor(CarvableHelper inst, String modid, String path) {
        if (path == null) {
            return CUSTOM;
        }
        for (TextureType t : VALUES) {
            boolean matches = true;
            for (String s : t.suffixes) {
                if (TextureType.exists(modid, path, s.isEmpty() ? s : "-" + s)) continue;
                matches = false;
            }
            if (!matches) continue;
            return t;
        }
        return CUSTOM;
    }

    private static boolean exists(String modid, String path, String postfix) {
        ResourceLocation rl = new ResourceLocation(modid, "textures/blocks/" + path + postfix + ".png");
        try {
            Minecraft.func_71410_x().func_110442_L().func_135056_b(rl);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        ctm = CTM.getInstance();
        rand = new Random();
        VALUES = (TextureType[])ArrayUtils.subarray((Object[])TextureType.values(), (int)0, (int)(TextureType.values().length - 1));
    }

    @SideOnly(value=Side.CLIENT)
    private static class SubmapManagerExistingIcon
    extends AbstractSubmapManager {
        private Block block;
        private int meta;

        private SubmapManagerExistingIcon(TextureType type, ICarvingVariation variation, Block block, int meta) {
            super(type, variation);
            this.block = block;
            this.meta = meta;
        }

        @Override
        public IIcon getIcon(int side, int meta) {
            return this.block.func_149691_a(side, this.meta);
        }

        @Override
        public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
            return this.getIcon(side, world.func_72805_g(x, y, z));
        }

        @Override
        public void registerIcons(String modName, Block block, IIconRegister register) {
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class SubmapManagerDefault
    extends AbstractSubmapManager {
        private String texturePath;

        private SubmapManagerDefault(TextureType type, ICarvingVariation variation, String texturePath) {
            super(type, variation);
            this.texturePath = texturePath;
        }

        @Override
        public void registerIcons(String modName, Block block, IIconRegister register) {
            this.cachedObject = this.type.registerIcons(this.variation, modName, this.texturePath, register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class AbstractSubmapManager
    implements ISubmapManager {
        protected final TextureType type;
        protected ICarvingVariation variation;
        protected Object cachedObject;

        private AbstractSubmapManager(TextureType type, ICarvingVariation variation) {
            this.type = type;
            this.variation = variation;
        }

        @Override
        public IIcon getIcon(int side, int meta) {
            return this.type.getIcon(this.variation, this.cachedObject, side, meta);
        }

        @Override
        public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
            return this.type.getIcon(this.variation, this.cachedObject, world, x, y, z, side, world.func_72805_g(x, y, z));
        }

        @Override
        public RenderBlocks createRenderContext(RenderBlocks rendererOld, Block block, IBlockAccess world) {
            TextureType.initStatics();
            RenderBlocks rb = this.type.createRenderContext(rendererOld, world, this.cachedObject);
            rb.func_147775_a(block);
            return rb;
        }

        @Override
        public void preRenderSide(RenderBlocks renderer, IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        }

        @Override
        public void postRenderSide(RenderBlocks renderer, IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        }

        public Object getCachedObject() {
            return this.cachedObject;
        }
    }
}

