/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util.helpers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.library.util.helpers.SlimevoidHelper;

public class BlockHelper {
    public static void notifyBlock(World world, int x, int y, int z, Block source) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            block.func_149695_a(world, x, y, z, source);
        }
    }

    public static void updateIndirectNeighbors(World world, int x, int y, int z, Block block) {
        if (world.field_72995_K || FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return;
        }
        for (int inDirX = -3; inDirX <= 3; ++inDirX) {
            for (int inDirY = -3; inDirY <= 3; ++inDirY) {
                for (int inDirZ = -3; inDirZ <= 3; ++inDirZ) {
                    int updateDirection = inDirX >= 0 ? inDirX : -inDirX;
                    updateDirection += inDirY >= 0 ? inDirY : -inDirY;
                    if ((updateDirection += inDirZ >= 0 ? inDirZ : -inDirZ) > 3) continue;
                    BlockHelper.notifyBlock(world, x + inDirX, y + inDirY, z + inDirZ, block);
                }
            }
        }
    }

    public static void markBlockDirty(World world, int x, int y, int z) {
        if (world.func_72899_e(x, y, z)) {
            world.func_72938_d(x, z).func_76630_e();
        }
    }

    public static Object getTileEntity(IBlockAccess world, int x, int y, int z, Class tileEntityClass) {
        if (tileEntityClass == null) {
            return null;
        }
        TileEntity tileentity = SlimevoidHelper.getBlockTileEntity(world, x, y, z);
        if (!tileEntityClass.isInstance(tileentity)) {
            return null;
        }
        return tileentity;
    }

    public static TileEntity getTileEntityAtBase(Entity entity) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M));
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        return SlimevoidHelper.getBlockTileEntity((IBlockAccess)entity.field_70170_p, x, y, z);
    }

    public static void playBlockPlaceNoise(World world, int x, int y, int z, Block block) {
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "step.stone", (block.field_149762_H.func_150494_d() + 1.0f) / 2.0f, block.field_149762_H.func_150497_c() * 0.8f);
    }
}

