/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.render;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.Tessellator;
import net.slimevoid.library.render.TexturedTriangle;

public class ModelSlimevoidObject {
    private List<TexturedQuad> faceList = new ArrayList<TexturedQuad>();
    private List<PositionTextureVertex> vertexList = new ArrayList<PositionTextureVertex>();
    private List<Point2D.Float> vertexTexList = new ArrayList<Point2D.Float>();
    private ModelRenderer modelRenderer;
    private ModelSlimevoidObjectBounds boundsCache;
    private int polyCount = 0;

    public ModelSlimevoidObject(ModelRenderer modelRenderer) {
        this.modelRenderer = modelRenderer;
    }

    public ModelRenderer getModelRenderer() {
        return this.modelRenderer;
    }

    public int addVertex(float x, float y, float z, float u, float v) {
        int id = this.vertexList.size();
        this.vertexList.add(new PositionTextureVertex(x, y, z, u, v));
        return id;
    }

    public int addVertexTexture(float x, float y) {
        int id = this.vertexTexList.size();
        this.vertexTexList.add(new Point2D.Float(x, 1.0f - y));
        return id;
    }

    public void addQuad(int a, int b, int c, int d, int at, int bt, int ct, int dt, boolean flip) {
        PositionTextureVertex ap = new PositionTextureVertex(this.vertexList.get((int)a).field_78243_a, this.vertexTexList.get((int)at).x, this.vertexTexList.get((int)at).y);
        PositionTextureVertex bp = new PositionTextureVertex(this.vertexList.get((int)b).field_78243_a, this.vertexTexList.get((int)bt).x, this.vertexTexList.get((int)bt).y);
        PositionTextureVertex cp = new PositionTextureVertex(this.vertexList.get((int)c).field_78243_a, this.vertexTexList.get((int)ct).x, this.vertexTexList.get((int)ct).y);
        PositionTextureVertex dp = new PositionTextureVertex(this.vertexList.get((int)d).field_78243_a, this.vertexTexList.get((int)dt).x, this.vertexTexList.get((int)dt).y);
        TexturedQuad quad = new TexturedQuad(new PositionTextureVertex[]{ap, bp, cp, dp});
        if (flip) {
            quad.func_78235_a();
        }
        this.faceList.add(quad);
        this.polyCount += 2;
    }

    public void addTriangle(int a, int b, int c, int at, int bt, int ct, boolean flip) {
        PositionTextureVertex ap = new PositionTextureVertex(this.vertexList.get((int)a).field_78243_a, this.vertexTexList.get((int)at).x, this.vertexTexList.get((int)at).y);
        PositionTextureVertex bp = new PositionTextureVertex(this.vertexList.get((int)b).field_78243_a, this.vertexTexList.get((int)bt).x, this.vertexTexList.get((int)bt).y);
        PositionTextureVertex cp = new PositionTextureVertex(this.vertexList.get((int)c).field_78243_a, this.vertexTexList.get((int)ct).x, this.vertexTexList.get((int)ct).y);
        TexturedTriangle triangle = new TexturedTriangle(new PositionTextureVertex[]{ap, bp, cp});
        if (flip) {
            triangle.func_78235_a();
        }
        this.faceList.add(triangle);
        ++this.polyCount;
    }

    public ModelSlimevoidObjectBounds getBounds() {
        if (this.boundsCache != null) {
            return this.boundsCache;
        }
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (PositionTextureVertex v : this.vertexList) {
            if (v.field_78243_a.field_72450_a < (double)minX || minX == 0 && v.field_78243_a.field_72450_a != 0.0) {
                minX = (int)v.field_78243_a.field_72450_a;
            }
            if (v.field_78243_a.field_72448_b < (double)minY) {
                minY = (int)v.field_78243_a.field_72448_b;
            }
            if (v.field_78243_a.field_72449_c < (double)minZ || minZ == 0 && v.field_78243_a.field_72449_c != 0.0) {
                minZ = (int)v.field_78243_a.field_72449_c;
            }
            if (v.field_78243_a.field_72450_a > (double)maxX) {
                maxX = (int)v.field_78243_a.field_72450_a;
            }
            if (v.field_78243_a.field_72448_b > (double)maxY) {
                maxY = (int)v.field_78243_a.field_72448_b;
            }
            if (!(v.field_78243_a.field_72449_c > (double)maxZ)) continue;
            maxZ = (int)v.field_78243_a.field_72449_c;
        }
        this.boundsCache = new ModelSlimevoidObjectBounds(minX, minY, minZ, maxX, maxY, maxZ);
        return this.boundsCache;
    }

    public void render(float par2) {
        for (int i = 0; i < this.faceList.size(); ++i) {
            this.faceList.get(i).func_78236_a(Tessellator.field_78398_a, par2);
        }
    }

    public int vertexCount() {
        return this.vertexList.size();
    }

    public int faceCount() {
        return this.faceList.size();
    }

    public int polyCount() {
        return this.polyCount;
    }

    public class ModelSlimevoidObjectBounds {
        public int minX = 0;
        public int minY = 0;
        public int minZ = 0;
        public int maxX = 0;
        public int maxY = 0;
        public int maxZ = 0;

        public ModelSlimevoidObjectBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }
    }
}

