/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.slimevoid.library.items.ItemBlockBase;
import net.slimevoid.library.sounds.SlimevoidStepSound;
import net.slimevoid.library.tileentity.TileEntityBase;
import net.slimevoid.library.util.helpers.BlockHelper;

public abstract class BlockBase
extends BlockContainer {
    protected IIcon[] bottom;
    protected IIcon[] top;
    protected IIcon[] front;
    protected IIcon[] side;
    protected Class[] tileEntityMap;

    protected BlockBase(Material material, int maxTiles) {
        super(material);
        this.tileEntityMap = new Class[maxTiles];
        this.func_149647_a(this.getCreativeTab());
        this.func_149672_a(new SlimevoidStepSound("blockbase", 1.0f, 1.0f));
        this.func_149711_c(1.0f);
    }

    public void func_149651_a(IIconRegister iconregister) {
        this.registerIcons(iconregister);
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.bottom = this.registerBottomIcons(iconRegister);
        this.top = this.registerTopIcons(iconRegister);
        this.front = this.registerFrontIcons(iconRegister);
        this.side = this.registerSideIcons(iconRegister);
    }

    public abstract IIcon[] registerBottomIcons(IIconRegister var1);

    public abstract IIcon[] registerTopIcons(IIconRegister var1);

    public abstract IIcon[] registerFrontIcons(IIconRegister var1);

    public abstract IIcon[] registerSideIcons(IIconRegister var1);

    public IIcon func_149691_a(int side, int metadata) {
        switch (side) {
            case 0: {
                return this.bottom != null && metadata < this.tileEntityMap.length ? this.bottom[metadata] : this.field_149761_L;
            }
            case 1: {
                return this.top != null && metadata < this.tileEntityMap.length ? this.top[metadata] : this.field_149761_L;
            }
            case 3: {
                return this.front != null && metadata < this.tileEntityMap.length ? this.front[metadata] : this.field_149761_L;
            }
        }
        return this.side != null && metadata < this.tileEntityMap.length ? this.side[metadata] : this.field_149761_L;
    }

    public abstract CreativeTabs getCreativeTab();

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isCube() {
        return false;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int x, int y, int z, int metadata) {
        super.func_149636_a(world, entityplayer, x, y, z, metadata);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.removeBlockByPlayer(player, this);
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public boolean superRemoveBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.getPickBlock(target, this);
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public final ItemStack superGetPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return super.getPickBlock(target, world, x, y, z);
    }

    public void func_149719_a(IBlockAccess iblockaccess, int x, int y, int z) {
        int metadata = iblockaccess.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity(iblockaccess, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            tileentitybase.setBlockBoundsBasedOnState(this);
        } else {
            super.func_149719_a(iblockaccess, x, y, z);
        }
    }

    public void setBlockBoundsForItemRender(int metadata) {
        TileEntityBase tileentitybase = (TileEntityBase)this.createTileEntity(null, metadata);
        if (tileentitybase != null) {
            tileentitybase.setBlockBoundsForItemRender(this);
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.collisionRayTrace(this, startVec, endVec);
        }
        return super.func_149731_a(world, x, y, z, startVec, endVec);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List aList, Entity anEntity) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            tileentitybase.addCollisionBoxesToList(this, axisAlignedBB, aList, anEntity);
        } else {
            super.func_149743_a(world, x, y, z, axisAlignedBB, aList, anEntity);
        }
    }

    public final void superSetBlockBoundsBasedOnState(World worldObj, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public final MovingObjectPosition superCollisionRayTrace(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        return super.func_149731_a(world, x, y, z, startVec, endVec);
    }

    public final void superAddCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List aList, Entity anEntity) {
        super.func_149743_a(world, x, y, z, axisAlignedBB, aList, anEntity);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity(world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.isSideSolid(this, side);
        }
        return super.isSideSolid(world, x, y, z, side);
    }

    public boolean superSideSolid(World world, int x, int y, int z, ForgeDirection side) {
        return super.isSideSolid((IBlockAccess)world, x, y, z, side);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.getExplosionResistance(entity, explosionX, explosionY, explosionZ, this);
        }
        return super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public final float superGetExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.getBlockHardness(this);
        }
        return super.func_149712_f(world, x, y, z);
    }

    public float superBlockHardness(World world, int x, int y, int z) {
        return super.func_149712_f(world, x, y, z);
    }

    public float func_149737_a(EntityPlayer entityplayer, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.getPlayerRelativeBlockHardness(entityplayer, this);
        }
        return super.func_149737_a(entityplayer, world, x, y, z);
    }

    public int func_149720_d(IBlockAccess iblockaccess, int x, int y, int z) {
        int metadata = iblockaccess.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity(iblockaccess, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            return tileentitybase.colorMultiplier(this);
        }
        return super.func_149720_d(iblockaccess, x, y, z);
    }

    public int superColorMultiplier(World world, int x, int y, int z) {
        return super.func_149720_d((IBlockAccess)world, x, y, z);
    }

    public ArrayList getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> harvestList = new ArrayList<ItemStack>();
        harvestList.add(new ItemStack((Block)this, 1, metadata));
        return harvestList;
    }

    public int func_149679_a(int i, Random random) {
        return 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            tileentitybase.onBlockNeighborChange(block);
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityplayer, ItemStack itemstack) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentitybase = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentitybase != null) {
            tileentitybase.onBlockPlacedBy(itemstack, entityplayer);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntityBase tileentity = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentity != null) {
            tileentity.breakBlock(block, metadata);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float xHit, float yHit, float zHit) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentity = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentity != null) {
            return tileentity.onBlockActivated(entityplayer);
        }
        return false;
    }

    public IIcon func_149673_e(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        int metadata = iblockaccess.func_72805_g(x, y, z);
        TileEntityBase tileentity = (TileEntityBase)((Object)BlockHelper.getTileEntity(iblockaccess, x, y, z, this.getTileMapData(metadata)));
        if (tileentity != null) {
            return tileentity.getBlockTexture(x, y, z, metadata, side);
        }
        return this.func_149691_a(side, metadata);
    }

    public int getLightValue(IBlockAccess iblockaccess, int x, int y, int z) {
        int metadata = iblockaccess.func_72805_g(x, y, z);
        TileEntityBase tileentity = (TileEntityBase)((Object)BlockHelper.getTileEntity(iblockaccess, x, y, z, this.getTileMapData(metadata)));
        if (tileentity != null) {
            return tileentity.getLightValue();
        }
        return super.getLightValue(iblockaccess, x, y, z);
    }

    public boolean superDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return super.addDestroyEffects(world, x, y, z, meta, effectRenderer);
    }

    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentity = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentity != null) {
            return tileentity.addBlockDestroyEffects(this, meta, effectRenderer);
        }
        return super.addDestroyEffects(world, x, y, z, meta, effectRenderer);
    }

    public boolean superHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return super.addHitEffects(world, target, effectRenderer);
    }

    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentity = (TileEntityBase)((Object)BlockHelper.getTileEntity((IBlockAccess)world, x, y, z, this.getTileMapData(metadata)));
        if (tileentity != null) {
            return tileentity.addBlockHitEffects(this, target, effectRenderer);
        }
        return super.addHitEffects(world, target, effectRenderer);
    }

    public Class getTileMapData(int metadata) {
        if (metadata < this.tileEntityMap.length) {
            return this.tileEntityMap[metadata];
        }
        return null;
    }

    public void addMapping(int metadata, Class<? extends TileEntity> tileEntityClass, String unlocalizedName) {
        this.tileEntityMap[metadata] = tileEntityClass;
        GameRegistry.registerTileEntity(tileEntityClass, (String)unlocalizedName);
        this.setItemName(metadata, unlocalizedName);
    }

    public void setItemName(int metadata, String name) {
        Item item = Item.func_150898_a((Block)this);
        if (item != null) {
            ((ItemBlockBase)item).setMetaName(metadata, "tile." + name);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        try {
            return (TileEntity)this.getTileMapData(metadata).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return this.createTileEntity(world, metadata);
    }
}

