/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.main;

import com.wildmobsmod.bison.RegisterBison;
import com.wildmobsmod.blocks.WildMobsModBlocks;
import com.wildmobsmod.butterfly.RegisterButterfly;
import com.wildmobsmod.cougar.RegisterCougar;
import com.wildmobsmod.deer.RegisterDeer;
import com.wildmobsmod.direwolf.RegisterDireWolf;
import com.wildmobsmod.druid.RegisterDruid;
import com.wildmobsmod.fox.RegisterFox;
import com.wildmobsmod.goat.RegisterGoat;
import com.wildmobsmod.items.WildMobsModItems;
import com.wildmobsmod.main.CraftingManager;
import com.wildmobsmod.main.ServerProxy;
import com.wildmobsmod.mired.RegisterMired;
import com.wildmobsmod.mouse.RegisterMouse;
import com.wildmobsmod.spell.RegisterSpell;
import com.wildmobsmod.tarantula.RegisterTarantula;
import com.wildmobsmod.wizard.RegisterWizard;
import com.wildmobsmod.zomgus.RegisterZomgus;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="wildmobsmod", name="Wild Mobs Mod", version="1.2")
public class MainRegistry {
    @SidedProxy(clientSide="com.wildmobsmod.main.ClientProxy", serverSide="com.wildmobsmod.main.ServerProxy")
    public static ServerProxy proxy;
    public static Configuration config;
    public static int deerSpawnRate;
    public static int foxSpawnRate;
    public static int cougarSpawnRate;
    public static int cougarAttackChance;
    public static int bisonSpawnRate;
    public static int mouseSpawnRate;
    public static int butterflySpawnRate;
    public static int wizardAttackRate;
    public static int tarantulaSpawnRate;
    public static int druidSpawnRate;
    public static int goatSpawnRate;
    public static int zomgusSpawnRate;
    public static int direWolfSpawnRate;
    public static int direWolfAttackChance;
    public static boolean enableDeer;
    public static boolean enableFox;
    public static boolean enableCougar;
    public static boolean enableZomgus;
    public static boolean enableBison;
    public static boolean enableWizard;
    public static boolean enableMouse;
    public static boolean enableButterfly;
    public static boolean enableBugNet;
    public static boolean enableFur;
    public static boolean enableBisonLeather;
    public static boolean enableTarantula;
    public static boolean enableDruid;
    public static boolean enableGoat;
    public static boolean enableDireWolf;
    public static boolean enableFoxUnnaturalVariants;
    public static boolean enableDiseasedMice;
    public static final String CATEGORY_DEER = "Deer";
    public static final String CATEGORY_FOX = "Fox";
    public static final String CATEGORY_COUGAR = "Cougar";
    public static final String CATEGORY_ZOMGUS = "Zomgus";
    public static final String CATEGORY_BISON = "Bison";
    public static final String CATEGORY_WIZARD = "Wizard";
    public static final String CATEGORY_MOUSE = "Mouse";
    public static final String CATEGORY_BUTTERFLY = "Butterfly";
    public static final String CATEGORY_ITEMS = "Items";
    public static final String CATEGORY_TARANTULA = "Tarantula";
    public static final String CATEGORY_DRUID = "Druid";
    public static final String CATEGORY_GOAT = "Goat";
    public static final String CATEGORY_DIREWOLF = "DireWolf";
    @Mod.Metadata
    public static ModMetadata meta;
    @Mod.Instance(value="wildmobsmod")
    public static MainRegistry modInstance;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        MainRegistry.syncConfig();
        FMLCommonHandler.instance().bus().register((Object)modInstance);
        WildMobsModItems.mainRegistry();
        WildMobsModBlocks.mainRegistry();
        CraftingManager.mainRegistry();
        RegisterDeer.mainRegistry();
        RegisterFox.mainRegistry();
        RegisterCougar.mainRegistry();
        RegisterZomgus.mainRegistry();
        RegisterBison.mainRegistry();
        RegisterWizard.mainRegistry();
        RegisterSpell.mainRegistry();
        RegisterMouse.mainRegistry();
        RegisterButterfly.mainRegistry();
        RegisterTarantula.mainRegistry();
        RegisterDruid.mainRegistry();
        RegisterMired.mainRegistry();
        RegisterGoat.mainRegistry();
        RegisterDireWolf.mainRegistry();
        proxy.registerRenderThings();
    }

    public static void syncConfig() {
        deerSpawnRate = config.getInt("deerSpawnRate", CATEGORY_DEER, deerSpawnRate, 0, 100, "Deer spawn chance.");
        foxSpawnRate = config.getInt("foxSpawnRate", CATEGORY_FOX, foxSpawnRate, 0, 100, "Fox spawn chance.");
        cougarSpawnRate = config.getInt("cougarSpawnRate", CATEGORY_COUGAR, cougarSpawnRate, 0, 100, "Cougar spawn chance.");
        cougarAttackChance = config.getInt("cougarAttackChance", CATEGORY_COUGAR, cougarAttackChance, 0, 10000, "Sets the chance of cougars attacking the player randomly. Smaller the value, bigger the chance. The value is multiplied by 1.8 on peaceful difficulty, 1.4 on easy, 1.0 on normal and 0.6 on hard.");
        bisonSpawnRate = config.getInt("bisonSpawnRate", CATEGORY_BISON, bisonSpawnRate, 0, 100, "Bison spawn chance.");
        mouseSpawnRate = config.getInt("mouseSpawnRate", CATEGORY_MOUSE, mouseSpawnRate, 0, 100, "Mouse spawn chance.");
        butterflySpawnRate = config.getInt("butterflySpawnRate", CATEGORY_BUTTERFLY, butterflySpawnRate, 0, 100, "Butterfly spawn chance.");
        wizardAttackRate = config.getInt("wizardAttackRate", CATEGORY_WIZARD, wizardAttackRate, 0, 10000, "How often wizards attack. Smaller the value, faster they attack.");
        enableDeer = config.getBoolean("enableDeer", CATEGORY_DEER, enableDeer, "Enable/disable deer.");
        enableFox = config.getBoolean("enableFox", CATEGORY_FOX, enableFox, "Enable/disable fox.");
        enableCougar = config.getBoolean("enableCougar", CATEGORY_COUGAR, enableCougar, "Enable/disable cougar.");
        enableZomgus = config.getBoolean("enableZomgus", CATEGORY_ZOMGUS, enableZomgus, "Enable/disable zomgus.");
        enableBison = config.getBoolean("enableBison", CATEGORY_BISON, enableBison, "Enable/disable bison.");
        enableWizard = config.getBoolean("enableWizard", CATEGORY_WIZARD, enableWizard, "Enable/disable wizard.");
        enableMouse = config.getBoolean("enableMouse", CATEGORY_MOUSE, enableMouse, "Enable/disable mouse.");
        enableButterfly = config.getBoolean("enableButterfly", CATEGORY_BUTTERFLY, enableButterfly, "Enable/disable butterfly.");
        enableBugNet = config.getBoolean("enableBugNet", CATEGORY_ITEMS, enableBugNet, "Enable/disable bug net.");
        enableFur = config.getBoolean("enableFur", CATEGORY_ITEMS, enableFur, "Enable/disable fur and fur armor. If set to false, mobs that drop fur will drop leather instead.");
        enableBisonLeather = config.getBoolean("enableBisonLeather", CATEGORY_ITEMS, enableBisonLeather, "Enable/disable bison leather and bison leather armor. If set to false, bison will drop leather instead.");
        enableTarantula = config.getBoolean("enableTarantula", CATEGORY_TARANTULA, enableTarantula, "Enable/disable tarantula.");
        tarantulaSpawnRate = config.getInt("tarantulaSpawnRate", CATEGORY_TARANTULA, tarantulaSpawnRate, 0, 100, "Tarantula spawn chance.");
        enableDruid = config.getBoolean("enableDruid", CATEGORY_DRUID, enableDruid, "Enable/disable druid and mired.");
        druidSpawnRate = config.getInt("druidSpawnRate", CATEGORY_DRUID, druidSpawnRate, 0, 100, "Druid spawn chance.");
        enableGoat = config.getBoolean("enableGoat", CATEGORY_GOAT, enableGoat, "Enable/disable goat.");
        goatSpawnRate = config.getInt("goatSpawnRate", CATEGORY_GOAT, goatSpawnRate, 0, 100, "Goat spawn chance.");
        enableDireWolf = config.getBoolean("enableDireWolf", CATEGORY_DIREWOLF, enableDireWolf, "Enable/disable dire wolf.");
        direWolfSpawnRate = config.getInt("direWolfSpawnRate", CATEGORY_DIREWOLF, direWolfSpawnRate, 0, 100, "Dire wolf spawn chance.");
        enableFoxUnnaturalVariants = config.getBoolean("enableFoxUnnaturalVariants", CATEGORY_FOX, enableFoxUnnaturalVariants, "Enable/disable fox variants that can't be found naturally.");
        direWolfAttackChance = config.getInt("direWolfAttackChance", CATEGORY_DIREWOLF, direWolfAttackChance, 0, 10000, "Sets the chance of dire wolfs attacking the player randomly. Smaller the value, bigger the chance.");
        enableDiseasedMice = config.getBoolean("enableDiseasedMice", CATEGORY_MOUSE, enableDiseasedMice, "Enable/disable diseased mice.");
        zomgusSpawnRate = config.getInt("zomgusSpawnRate", CATEGORY_ZOMGUS, zomgusSpawnRate, 0, 100, "Zomgus spawn chance.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("wildmobsmod")) {
            MainRegistry.syncConfig();
        }
    }

    static {
        deerSpawnRate = 8;
        foxSpawnRate = 6;
        cougarSpawnRate = 4;
        cougarAttackChance = 120;
        bisonSpawnRate = 5;
        mouseSpawnRate = 8;
        butterflySpawnRate = 5;
        wizardAttackRate = 32;
        tarantulaSpawnRate = 50;
        druidSpawnRate = 5;
        goatSpawnRate = 10;
        zomgusSpawnRate = 100;
        direWolfSpawnRate = 2;
        direWolfAttackChance = 180;
        enableDeer = true;
        enableFox = true;
        enableCougar = true;
        enableZomgus = true;
        enableBison = true;
        enableWizard = true;
        enableMouse = true;
        enableButterfly = true;
        enableBugNet = true;
        enableFur = true;
        enableBisonLeather = true;
        enableTarantula = true;
        enableDruid = true;
        enableGoat = true;
        enableDireWolf = true;
        enableFoxUnnaturalVariants = true;
        enableDiseasedMice = true;
    }
}

