/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import me.otho.customItems.configuration.JsonSchema;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_block;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_crop;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_fluid;
import me.otho.customItems.configuration.jsonReaders.common.Cfg_basicData;
import me.otho.customItems.configuration.jsonReaders.items.Cfg_item;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_boots;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_chestplate;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_helmet;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_leggings;
import me.otho.customItems.configuration.jsonReaders.items.food.Cfg_food;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_axe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_hoe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_pickaxe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_shovel;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_sword;
import me.otho.customItems.configuration.jsonReaders.tileEntity.Cfg_chest;
import me.otho.customItems.mod.creativeTab.customItemsTab;
import me.otho.customItems.registry.BlockRegistry;
import me.otho.customItems.registry.CommonRegistry;
import me.otho.customItems.registry.EntityRegistry;
import me.otho.customItems.registry.ItemRegistry;
import me.otho.customItems.registry.TileEntityRegistry;
import me.otho.customItems.registry.TweakerRegistry;
import me.otho.customItems.utility.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import org.apache.logging.log4j.Level;

public class Registry {
    public static ArrayList<Object> itemsList = new ArrayList();
    public static ArrayList<Object> blocksList = new ArrayList();
    public static String mod_id = "customitems";
    public static String mod_name = "Meta Mod: Custom Items";
    public static int registerId = -1;

    private static void setCreativeTabs() {
        CreativeTabs tab;
        int i;
        for (i = 0; i < itemsList.size(); i += 2) {
            Item item = (Item)itemsList.get(i);
            tab = customItemsTab.getTabByName((String)itemsList.get(i + 1));
            if (tab == null) continue;
            item.func_77637_a(tab);
        }
        for (i = 0; i < blocksList.size(); i += 2) {
            Block block = (Block)blocksList.get(i);
            tab = customItemsTab.getTabByName((String)blocksList.get(i + 1));
            if (tab == null) continue;
            block.func_149647_a(tab);
        }
    }

    private static void mergeArrays(ArrayList<Cfg_basicData> arrL, Cfg_basicData[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arrL.add(arr[i]);
        }
    }

    public static void register(JsonSchema data) {
        ArrayList<Cfg_basicData> allData = new ArrayList<Cfg_basicData>();
        if (data != null) {
            if (data.blocks != null) {
                Registry.mergeArrays(allData, data.blocks);
            }
            if (data.chests != null) {
                Registry.mergeArrays(allData, data.chests);
            }
            if (data.foods != null) {
                Registry.mergeArrays(allData, data.foods);
            }
            if (data.items != null) {
                Registry.mergeArrays(allData, data.items);
            }
            if (data.fluids != null) {
                Registry.mergeArrays(allData, data.fluids);
            }
            if (data.pickaxes != null) {
                Registry.mergeArrays(allData, data.pickaxes);
            }
            if (data.axes != null) {
                Registry.mergeArrays(allData, data.axes);
            }
            if (data.shovels != null) {
                Registry.mergeArrays(allData, data.shovels);
            }
            if (data.hoes != null) {
                Registry.mergeArrays(allData, data.hoes);
            }
            if (data.swords != null) {
                Registry.mergeArrays(allData, data.swords);
            }
            if (data.helmets != null) {
                Registry.mergeArrays(allData, data.helmets);
            }
            if (data.chestplates != null) {
                Registry.mergeArrays(allData, data.chestplates);
            }
            if (data.leggings != null) {
                Registry.mergeArrays(allData, data.leggings);
            }
            if (data.boots != null) {
                Registry.mergeArrays(allData, data.boots);
            }
            if (data.crops != null) {
                Registry.mergeArrays(allData, data.crops);
            }
            Collections.sort(allData, new Comparator<Cfg_basicData>(){

                @Override
                public int compare(Cfg_basicData d1, Cfg_basicData d2) {
                    return d1.registerOrder.compareTo(d2.registerOrder);
                }
            });
            for (int i = 0; i < allData.size(); ++i) {
                LogHelper.log(Level.INFO, allData.get(i).getClass(), 1);
                Cfg_basicData toRegister = allData.get(i);
                if (toRegister instanceof Cfg_chest) {
                    TileEntityRegistry.registerChest((Cfg_chest)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_block) {
                    BlockRegistry.registerBlock((Cfg_block)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_food) {
                    ItemRegistry.registerFood((Cfg_food)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_item) {
                    ItemRegistry.registerItem((Cfg_item)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_fluid) {
                    BlockRegistry.registerFluid((Cfg_fluid)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_pickaxe) {
                    ItemRegistry.registerPickaxe((Cfg_pickaxe)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_axe) {
                    ItemRegistry.registerAxe((Cfg_axe)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_shovel) {
                    ItemRegistry.registerShovel((Cfg_shovel)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_hoe) {
                    ItemRegistry.registerHoe((Cfg_hoe)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_sword) {
                    ItemRegistry.registerSword((Cfg_sword)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_helmet) {
                    ItemRegistry.registerHelmet((Cfg_helmet)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_chestplate) {
                    ItemRegistry.registerChestplate((Cfg_chestplate)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_leggings) {
                    ItemRegistry.registerLeggings((Cfg_leggings)toRegister);
                    continue;
                }
                if (toRegister instanceof Cfg_boots) {
                    ItemRegistry.registerBoots((Cfg_boots)toRegister);
                    continue;
                }
                if (!(toRegister instanceof Cfg_crop)) continue;
                BlockRegistry.registerCrop((Cfg_crop)toRegister);
            }
            CommonRegistry.registerCreativeTabs(data.creativeTabs);
            if (data.entitiesDrop != null) {
                EntityRegistry.registerEntityDrop(data.entitiesDrop);
            }
            if (data.blocksDrop != null) {
                BlockRegistry.registerBlockDrop(data.blocksDrop);
            }
            Registry.setCreativeTabs();
        }
    }

    public static void change(JsonSchema data) {
        LogHelper.info("Starting to change:");
        LogHelper.info("Changing blocks:");
        if (data.changeBlocks != null) {
            TweakerRegistry.changeBlock(data.changeBlocks);
        }
        LogHelper.info("Changing items:");
        if (data.changeItems != null) {
            TweakerRegistry.changeItem(data.changeItems);
        }
        LogHelper.info("Changing foods:");
        if (data.changeFoods != null) {
            TweakerRegistry.changeFood(data.changeFoods);
        }
    }
}

