/*
 * Decompiled with CFR 0.152.
 */
package com.Otho.customItems.handler;

import com.Otho.customItems.handler.ConfigurationHandler;
import com.Otho.customItems.mod.items.tools.CustomAxe;
import com.Otho.customItems.mod.items.tools.CustomHoe;
import com.Otho.customItems.mod.items.tools.CustomPickaxe;
import com.Otho.customItems.mod.items.tools.CustomShovel;
import com.Otho.customItems.mod.items.tools.CustomSword;
import com.Otho.customItems.util.StringUtil;
import com.Otho.customItems.util.logHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.EnumHelper;

public class ToolsHandler {
    public static void init() {
        JsonObject tools = ConfigurationHandler.tools;
        if (tools != null) {
            JsonArray shovels = (JsonArray)tools.get("shovels");
            JsonArray axes = (JsonArray)tools.get("axes");
            JsonArray pickaxes = (JsonArray)tools.get("pickaxes");
            JsonArray swords = (JsonArray)tools.get("swords");
            JsonArray hoes = (JsonArray)tools.get("hoes");
            logHelper.log((String)"customItems", (String)logHelper.debug, (String)"Registering custom Tools");
            if (shovels != null) {
                ToolsHandler.NewTools(shovels, "shovel");
            }
            if (axes != null) {
                ToolsHandler.NewTools(axes, "axe");
            }
            if (pickaxes != null) {
                ToolsHandler.NewTools(pickaxes, "pickaxe");
            }
            if (swords != null) {
                ToolsHandler.NewTools(swords, "sword");
            }
            if (hoes != null) {
                ToolsHandler.NewTools(hoes, "hoe");
            }
        }
    }

    private static void NewTools(JsonArray tools, String type) {
        for (int i = 0; i < tools.size(); ++i) {
            JsonObject data = (JsonObject)tools.get(i);
            logHelper.log((String)"customItems", (String)logHelper.debug, (String)data.toString());
            String name = data.get("name").getAsString();
            String textureName = data.get("textureName").getAsString();
            textureName = StringUtil.parseTextureName((String)textureName);
            int harvestLevel = data.get("harvestLevel").getAsInt();
            int maxUses = data.get("maxUses").getAsInt();
            float efficiencyOnProperMaterial = data.get("efficiencyOnProperMaterial").getAsFloat();
            float damageVsEntity = data.get("damageVsEntity").getAsFloat();
            int enchantability = data.get("enchantability").getAsInt();
            Item.ToolMaterial material = EnumHelper.addToolMaterial((String)textureName, (int)harvestLevel, (int)maxUses, (float)efficiencyOnProperMaterial, (float)damageVsEntity, (int)enchantability);
            Object tool = type.equals("axe") ? new CustomAxe(material) : (type.equals("shovel") ? new CustomShovel(material) : (type.equals("pickaxe") ? new CustomPickaxe(material) : (type.equals("hoe") ? new CustomHoe(material) : (type.equals("sword") ? new CustomSword(material) : new CustomAxe(material)))));
            GameRegistry.registerItem((Item)tool, (String)textureName);
            tool.func_77655_b("customItems".toLowerCase() + ":" + textureName);
            LanguageRegistry.instance().addStringLocalization(tool.func_77658_a() + ".name", "en_US", name.substring(0, 1).toUpperCase() + name.substring(1));
        }
    }
}

