/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skinport.impl.forge;

import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public enum SkinCustomization {
    cape,
    jacket,
    left_sleeve,
    right_sleeve,
    left_pants_leg,
    right_pants_leg,
    hat;

    private static final int _defaultFlags;
    public static final SidedOptionalTupleKeyMap<UUID, Integer> Flags;
    public static int ClientFlags;
    private final IChatComponent _displayName = new ChatComponentTranslation("options.modelPart." + this.name(), new Object[0]);
    private final int _flag = (int)Math.pow(2.0, this.ordinal());

    public static boolean contains(int flags, SkinCustomization ... parts) {
        return (flags & SkinCustomization.of(parts)) != 0;
    }

    public static int getDefaultFlags() {
        return _defaultFlags;
    }

    public static int of(SkinCustomization ... parts) {
        int flags = 0;
        for (SkinCustomization part : parts) {
            flags |= part._flag;
        }
        return flags;
    }

    public IChatComponent getDisplayName() {
        return this._displayName;
    }

    public int getFlag() {
        return this._flag;
    }

    static {
        _defaultFlags = SkinCustomization.of(SkinCustomization.values());
        Flags = new SidedOptionalTupleKeyMap();
        ClientFlags = SkinCustomization.getDefaultFlags();
    }

    public static class SidedOptionalTupleKeyMap<K, V> {
        Map<Side, Map<K, V>> map = new ConcurrentHashMap<Side, Map<K, V>>();

        public void clear(Side side) {
            this.getMap(side).clear();
        }

        public V get(Side side, K key) {
            return this.get(side, key, Optional.empty());
        }

        public V get(Side side, K key, Optional<K> key2) {
            Map<K, V> m = this.getMap(side);
            V v = m.get(key);
            if (v == null && key2.isPresent()) {
                v = m.get(key2.get());
            }
            return v;
        }

        private Map<K, V> getMap(Side side) {
            if (!this.map.containsKey(side)) {
                this.map.putIfAbsent(side, new ConcurrentHashMap());
            }
            return this.map.get(side);
        }

        public V put(Side side, K key, Optional<K> key2, V value) {
            Map<K, V> m = this.getMap(side);
            V v = m.put(key, value);
            if (key2.isPresent()) {
                m.put(key2.get(), value);
            }
            return v;
        }

        public V put(Side side, K key, V value) {
            return this.put(side, key, Optional.empty(), value);
        }

        public V remove(Side side, K key) {
            return this.remove(side, key, Optional.empty());
        }

        public V remove(Side side, K key, Optional<K> key2) {
            Map<K, V> m = this.getMap(side);
            V v = m.remove(key);
            if (key2.isPresent()) {
                m.remove(key2.get());
            }
            return v;
        }
    }
}

