/*
 * Decompiled with CFR 0.152.
 */
package ua.secretagent12.kraftokimplants;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import mekanism.common.block.BlockMachine;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class TooltipEventHandler {
    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static boolean isTrackableBlock(Block block, int meta) {
        if (meta == 4 && block instanceof BlockMachine) {
            BlockMachine machine = (BlockMachine)block;
            if (machine.blockType == BlockMachine.MachineBlock.MACHINE_BLOCK_1) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        block12: {
            long minutes;
            long hours;
            long cooldownUntil;
            long currentTime;
            ItemStack stack = event.itemStack;
            if (!TooltipEventHandler.isTrackableBlock(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j())) {
                return;
            }
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                event.toolTip.add("\u00a7e\u0421\u0440\u043e\u043a \u0441\u043b\u0443\u0436\u0431\u044b: 30 \u0434\u043d\u0435\u0439. \u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442 \u043e\u0442\u043d\u0438\u043c\u0430\u0442\u044c\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            if (tag.func_74764_b("CooldownUntil") && (currentTime = Instant.now().getEpochSecond()) < (cooldownUntil = tag.func_74763_f("CooldownUntil"))) {
                long remainingSeconds = cooldownUntil - currentTime;
                hours = remainingSeconds / 3600L;
                minutes = remainingSeconds % 3600L / 60L;
                String cooldownInfo = "\u00a7c\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c: ";
                if (hours > 0L) {
                    cooldownInfo = cooldownInfo + hours + " \u0447. ";
                }
                cooldownInfo = cooldownInfo + (minutes + 1L) + " \u043c\u0438\u043d.";
                event.toolTip.add(cooldownInfo);
            }
            if (tag.func_74764_b("PlacementDate")) {
                String dateStr = tag.func_74779_i("PlacementDate");
                try {
                    LocalDateTime placementDate = LocalDateTime.parse(dateStr, DateTimeFormatter.ISO_DATE_TIME);
                    LocalDateTime expirationDate = placementDate.plusDays(30L);
                    Duration remaining = Duration.between(LocalDateTime.now(ZoneOffset.UTC), expirationDate);
                    if (remaining.isNegative()) {
                        event.toolTip.add("\u00a7c\u0421\u0440\u043e\u043a \u0441\u043b\u0443\u0436\u0431\u044b \u0438\u0441\u0442\u0435\u043a");
                        break block12;
                    }
                    long days = remaining.toDays();
                    hours = remaining.toHours() % 24L;
                    minutes = remaining.toMinutes() % 60L;
                    long seconds = remaining.getSeconds() % 60L;
                    StringBuilder sb = new StringBuilder("\u00a76\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: ");
                    if (days > 0L) {
                        sb.append(days).append(" \u0434. ");
                    }
                    if (hours > 0L || days > 0L) {
                        sb.append(hours).append(" \u0447. ");
                    }
                    if (minutes > 0L || hours > 0L || days > 0L) {
                        sb.append(minutes).append(" \u043c. ");
                    }
                    sb.append(seconds).append(" \u0441.");
                    event.toolTip.add(sb.toString());
                }
                catch (Exception e) {
                    event.toolTip.add("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u0430\u0442\u044b \u0432 NBT!");
                }
            } else {
                event.toolTip.add("\u00a7e\u0421\u0440\u043e\u043a \u0441\u043b\u0443\u0436\u0431\u044b: 30 \u0434\u043d\u0435\u0439. \u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442 \u043e\u0442\u043d\u0438\u043c\u0430\u0442\u044c\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f");
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderLivingSpecial(RenderLivingEvent.Specials.Pre event) {
        if (event.entity instanceof EntityPlayer && Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && event.isCancelable() && !event.entity.func_70685_l((Entity)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.equals((Object)Minecraft.func_71410_x().field_71439_g) && event.phase == TickEvent.Phase.START && RenderManager.field_85095_o) {
            RenderManager.field_85095_o = false;
        }
    }
}

