/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.utils;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.guns.raytracing.BlockHit;
import com.flansmod.common.guns.raytracing.BulletHit;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.guns.raytracing.EntityHit;
import com.flansmod.common.guns.raytracing.EnumHitboxType;
import com.flansmod.common.guns.raytracing.PlayerBulletHit;
import com.flansmod.common.guns.raytracing.PlayerSnapshot;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldServer;

public class ByteBufferBulletHitBridge {
    private static byte GetClassType(BulletHit hit) {
        if (hit instanceof BlockHit) {
            return 0;
        }
        if (hit instanceof EntityHit) {
            return 1;
        }
        if (hit instanceof DriveableHit) {
            return 2;
        }
        return (byte)(hit instanceof PlayerBulletHit ? 3 : -1);
    }

    public static void WriteToBuffer(BulletHit hit, ByteBuf buffer) {
        buffer.writeByte((int)ByteBufferBulletHitBridge.GetClassType(hit));
        if (hit != null) {
            buffer.writeFloat(hit.intersectTime);
            if (hit instanceof BlockHit) {
                BlockHit blockHit = (BlockHit)hit;
                buffer.writeInt(blockHit.raytraceResult.field_72310_e);
                buffer.writeInt(blockHit.raytraceResult.field_72311_b);
                buffer.writeInt(blockHit.raytraceResult.field_72312_c);
                buffer.writeInt(blockHit.raytraceResult.field_72309_d);
            }
            if (hit instanceof EntityHit) {
                EntityHit entityHit = (EntityHit)hit;
                buffer.writeInt(entityHit.entity.func_145782_y());
            }
            if (hit instanceof DriveableHit) {
                DriveableHit driveableHit = (DriveableHit)hit;
                buffer.writeInt(driveableHit.driveable.func_145782_y());
            }
            if (hit instanceof PlayerBulletHit) {
                PlayerBulletHit playerBulletHit = (PlayerBulletHit)hit;
                buffer.writeInt(playerBulletHit.hitbox.player.func_145782_y());
            }
        }
    }

    public static BulletHit ReadFromBuffer(ByteBuf buffer) {
        byte type = buffer.readByte();
        switch (type) {
            default: {
                return null;
            }
            case 0: {
                float intersectTime = buffer.readFloat();
                int facing = buffer.readInt();
                return new BlockHit(new MovingObjectPosition(buffer.readInt(), buffer.readInt(), buffer.readInt(), facing, Vector3f.readFromBuffer(buffer).toVec3()), intersectTime);
            }
            case 1: {
                float intersectTime = buffer.readFloat();
                Entity entity = ByteBufferBulletHitBridge.GetEntityByID(buffer.readInt());
                return new EntityHit(entity, intersectTime);
            }
            case 2: {
                float intersectTime = buffer.readFloat();
                Entity entity = ByteBufferBulletHitBridge.GetEntityByID(buffer.readInt());
                if (entity instanceof EntityDriveable) {
                    return new DriveableHit((EntityDriveable)entity, EnumDriveablePart.values()[buffer.readByte()], intersectTime);
                }
                FlansMod.log("Entity was not a driveable");
                buffer.readByte();
                Vector3f.readFromBuffer(buffer);
                return null;
            }
            case 3: 
        }
        float intersectTime = buffer.readFloat();
        Entity entity = ByteBufferBulletHitBridge.GetEntityByID(buffer.readInt());
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerSnapshot snapshot = new PlayerSnapshot(player);
            return new PlayerBulletHit(snapshot.getHitboxByType(EnumHitboxType.values()[buffer.readByte()]), intersectTime);
        }
        FlansMod.log("Entity was not a player");
        buffer.readByte();
        Vector3f.readFromBuffer(buffer);
        return null;
    }

    public static Entity GetEntityByID(int id) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                Entity entity = world.func_73045_a(id);
                if (entity == null) continue;
                return entity;
            }
            return null;
        }
        return Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
    }
}

