/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.EntityDamageSourceFlans;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;

public class ItemTeamArmour
extends ItemArmor
implements ISpecialArmor,
IFlanItem {
    public ArmourType type;
    protected static final UUID[] uuid = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
    public static ItemArmor.ArmorMaterial altArmorMat = EnumHelper.addArmorMaterial((String)"FLANSARMOR", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)FlansMod.armourEnchantability);

    public ItemTeamArmour(ArmourType t) {
        super(altArmorMat, 0, t.type);
        this.type = t;
        this.type.item = this;
        this.func_77637_a(FlansMod.tabFlanTeams);
        if (t.durability > 0) {
            this.func_77656_e(t.durability);
        } else if (FlansMod.breakableArmor == 1) {
            this.func_77656_e(FlansMod.defaultArmorDurability);
        }
        GameRegistry.registerItem((Item)this, (String)this.type.shortName, (String)"flansmod");
    }

    public ItemTeamArmour(ItemArmor.ArmorMaterial armorMaterial, int renderIndex, int armourType) {
        super(armorMaterial, renderIndex, armourType);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source instanceof EntityDamageSourceFlans && !((EntityDamageSourceFlans)source).melee && !source.func_94541_c()) {
            return new ISpecialArmor.ArmorProperties(1, this.type.bulletDefence, Integer.MAX_VALUE);
        }
        return new ISpecialArmor.ArmorProperties(1, this.type.defence, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)(this.type.defence * 20.0);
    }

    public int func_77619_b() {
        return FlansMod.armourEnchantability;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        int breakType = FlansMod.breakableArmor;
        if (breakType == 2 && this.type.hasDurability || breakType == 1) {
            stack.func_77972_a(damage, entity);
        }
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String s) {
        return "flansmod:armor/" + this.type.armourTextureName + "_" + (this.type.type == 2 ? "2" : "1") + ".png";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean b) {
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        lines.add("\u00a73Bullet Defence: " + String.format("%.2f", this.type.bulletDefence * 100.0) + "%");
        lines.add("\u00a73Other Defence: " + String.format("%.2f", this.type.defence * 100.0) + "%");
        if (Math.abs(this.type.jumpModifier - 1.0f) > 0.01f) {
            lines.add("\u00a73+" + (int)((this.type.jumpModifier - 1.0f) * 100.0f) + "% Jump Height");
        }
        if (this.type.smokeProtection) {
            lines.add("\u00a72+Smoke Protection");
        }
        if (this.type.nightVision) {
            lines.add("\u00a72+Night Vision");
        }
        if (this.type.invisible) {
            lines.add("\u00a72+Invisibility");
        }
        if (this.type.negateFallDamage) {
            lines.add("\u00a72+Negates Fire Damage");
        }
        if (this.type.fireResistance) {
            lines.add("\u00a72+Fire Resistance");
        }
        if (this.type.waterBreathing) {
            lines.add("\u00a72+Water Breathing");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return this.type.colour;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a("FlansMod:" + this.type.iconPath);
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap map = super.getAttributeModifiers(stack);
        map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid[this.type.type], "KnockbackResist", (double)this.type.knockbackModifier, 0));
        map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid[this.type.type], "MovementSpeed", (double)(this.type.moveSpeedModifier - 1.0f), 2));
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return this.type.model;
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.type.nightVision && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 250));
        }
        if (this.type.invisible && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 250));
        }
        if (this.type.jumpModifier > 1.01f && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 250, (int)((this.type.jumpModifier - 1.0f) * 2.0f), true));
        }
        if (this.type.negateFallDamage) {
            player.field_70143_R = 0.0f;
        }
        if (this.type.fireResistance && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 250));
        }
        if (this.type.waterBreathing && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 250));
        }
        if (this.type.onWaterWalking) {
            if (player.func_70090_H()) {
                player.field_71075_bZ.field_75101_c = true;
            } else {
                player.field_71075_bZ.field_75100_b = false;
            }
        }
    }
}

